INCLUDE "COUNTER.INC"

RESX EQU 320
RESY EQU 200
SPEED EQU 4*4

CNT EQU 0
SX EQU 4
SY EQU 6
C0X EQU 8
C0Y EQU 10
C1X EQU 16
C1Y EQU 18

ORG 256

 MOV    BH,0A0H
 MOV    FS,BX

 MOV    DX,3C8H+1
;SALC
;OUT    DX,AL
;INC    DX
l1:
 MOV    SI,512+3
l2:
 MOV    AL,[SI-512+Pal-1]
 ADD    AL,BH
 CBW
 XOR    AL,AH
 SHR    AL,1
 OUT    DX,AL
 DEC    SI
 JPO    l2
 SUB    BX,160
 JNZ    l1

nextframe:
 CALL ESCAPE
 CBW
 XOR AL,AH
 CBW
 SHL AX,2
 MOV [SI+CNT],AX
nextpixel:
 PUSH   WORD [SI+CNT]
 PUSH   DI
 MOV    CL,1
 MOV    AH,8
 CWD
 XCHG   AX,DI
 MOV    DI,SY+512
 DIV    BP
 MOV    [SI+SX],DX
 STOSW
 MOV    AL,RESX/2
 STOSW
 MOV    AL,RESY/2
 STOSW
 MOV    AL,32
 MOV    [DI],AX
 CWD
 MOV    BL,115                  ; RADIUS
nextcircle:
 PUSH   BX
 XCHG   AX,BX
 MUL    AL
 MOV    [BP+SI],AX

 FILD   WORD [SI+CNT]
 FMUL   DWORD [DIVIDER]
 FSINCOS

twice:
 DEC    SI
 DEC    SI
 FIMUL  WORD [DI]
 FIADD  WORD [SI+C0Y+2]
 FIST   WORD [SI+C1Y+2]
 FISUBR WORD [SI+SY+2]
 FMUL   ST0,ST0
 FISTP  WORD [SI]
 JPO    twice

 LODSW
 XCHG   AX,BX
 LODSW
 ADD    AX,BX
 POP    BX
 SUB    [BP+SI],AX
 JBE    outside

 FILD   WORD [BP+SI]
;FSQRT
 MOV    [BP+SI],BX
 FIDIV  WORD [BP+SI]
 FISTP  WORD [BP+SI]
 ADD    DX,[BP+SI]

 MOV    CL,4
 IMUL   AX,BX,6
 SHR    AX,CL
 CMP    AL,6
 JC     maxlevel
 XCHG   AX,BX
 SUB    AX,BX
 MOV    [DI],AX
 NEG    WORD [SI+CNT]
 FILD   DWORD [SI+C1X]
 FISTP  DWORD [SI+C0X]
outside:
 ADD    WORD [SI+CNT],341       ; 2PI/3
 LOOP   nextcircle
maxlevel:
 POP    DI
 POP    WORD [SI+CNT]
 MOV    [FS:DI],DL
 INC    DI
 JNZ    nextpixel
; MOV AH,1
; INT 16H
 JMP nextframe

DIVIDER:
 DD 0.006135923;DW 163 ; 1024/163 -> 2PI

Pal:
 DB 192-128,225-128,205-128

