/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.doc;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.x4o.xml.X4ODriver;
import org.x4o.xml.X4ODriverManager;
import org.x4o.xml.eld.doc.EldDocWriter;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.lang.X4OLanguageContext;

public class X4OWriteLanguageDocExecutor {
    private String languageName = null;
    private String languageVersion = null;
    private File basePath;

    public static void main(String[] argu) {
        X4OWriteLanguageDocExecutor languageSchema = new X4OWriteLanguageDocExecutor();
        List<String> arguList = Arrays.asList(argu);
        Iterator<String> arguIterator = arguList.iterator();
        while (arguIterator.hasNext()) {
            String arg = arguIterator.next();
            if ("-path".equals(arg) || "-p".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.err.println("No argument for " + arg + " given.");
                    System.exit(1);
                    return;
                }
                File schemaBasePath = new File(arguIterator.next());
                if (!schemaBasePath.exists()) {
                    System.err.println("path does not exists; " + schemaBasePath);
                    System.exit(1);
                    return;
                }
                languageSchema.setBasePath(schemaBasePath);
                continue;
            }
            if (!"-language".equals(arg) && !"-l".equals(arg)) continue;
            if (!arguIterator.hasNext()) {
                System.err.println("No argument for " + arg + " given.");
                System.exit(1);
                return;
            }
            String languageName = arguIterator.next();
            languageSchema.setLanguageName(languageName);
        }
        try {
            languageSchema.execute();
        }
        catch (ElementException e) {
            System.err.println("Error while schema writing: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public void execute() throws ElementException {
        X4ODriver driver = X4ODriverManager.getX4ODriver((String)this.getLanguageName());
        X4OLanguageContext context = driver.createLanguageContext(this.getLanguageVersion());
        EldDocWriter docWriter = new EldDocWriter(context);
        docWriter.writeDoc(this.getBasePath());
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public File getBasePath() {
        return this.basePath;
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath;
    }
}

