/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang.phase;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementBindingHandlerException;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementClassAttribute;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.element.ElementNamespaceInstanceProviderException;
import org.x4o.xml.element.ElementObjectPropertyValueException;
import org.x4o.xml.io.sax.ext.ContentWriterXml;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.x4o.xml.lang.phase.AbstractX4OPhase;
import org.x4o.xml.lang.phase.DefaultX4OPhaseManager;
import org.x4o.xml.lang.phase.X4OPhase;
import org.x4o.xml.lang.phase.X4OPhaseException;
import org.x4o.xml.lang.phase.X4OPhaseType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class X4OPhaseLanguageWrite {
    private Logger logger = Logger.getLogger(X4OPhaseLanguageWrite.class.getName());

    public void createPhases(DefaultX4OPhaseManager manager) {
        manager.addX4OPhase(new X4OPhaseWriteStart());
        manager.addX4OPhase(new X4OPhaseWriteFillTree());
        manager.addX4OPhase(new X4OPhaseWriteXml());
        manager.addX4OPhase(new X4OPhaseWriteEnd());
    }

    class X4OPhaseWriteEnd
    extends AbstractX4OPhase {
        X4OPhaseWriteEnd() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_WRITE;
        }

        public String getId() {
            return "WRITE_END";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"WRITE_XML"};
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            X4OPhaseLanguageWrite.this.logger.finest("Run init end phase");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class X4OPhaseWriteXml
    extends AbstractX4OPhase {
        private AttributeEntryComparator attributeEntryComparator = new AttributeEntryComparator();
        private boolean schemaUriPrint;
        private String schemaUriRoot;

        X4OPhaseWriteXml() {
        }

        @Override
        public X4OPhaseType getType() {
            return X4OPhaseType.XML_WRITE;
        }

        @Override
        public String getId() {
            return "WRITE_XML";
        }

        @Override
        public String[] getPhaseDependencies() {
            return new String[]{"WRITE_FILL_TREE"};
        }

        @Override
        public boolean isElementPhase() {
            return false;
        }

        @Override
        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        @Override
        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            OutputStream out = (OutputStream)languageContext.getLanguageProperty(X4OLanguageProperty.WRITER_OUTPUT_STREAM);
            try {
                String encoding = languageContext.getLanguagePropertyString(X4OLanguageProperty.WRITER_OUTPUT_ENCODING);
                String charNew = languageContext.getLanguagePropertyString(X4OLanguageProperty.WRITER_OUTPUT_CHAR_NEWLINE);
                String charTab = languageContext.getLanguagePropertyString(X4OLanguageProperty.WRITER_OUTPUT_CHAR_TAB);
                this.schemaUriPrint = languageContext.getLanguagePropertyBoolean(X4OLanguageProperty.WRITER_SCHEMA_URI_PRINT);
                this.schemaUriRoot = languageContext.getLanguagePropertyString(X4OLanguageProperty.WRITER_SCHEMA_URI_ROOT);
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                if (charNew == null) {
                    charNew = "\n";
                }
                if (charTab == null) {
                    charTab = "\t";
                }
                Element root = languageContext.getRootElement();
                if (this.schemaUriRoot == null) {
                    String rootUri = this.findElementUri(root);
                    ElementNamespaceContext ns = languageContext.getLanguage().findElementNamespaceContext(rootUri);
                    if (ns != null) {
                        this.schemaUriRoot = ns.getSchemaUri();
                    }
                }
                ContentWriterXml writer = new ContentWriterXml(out, encoding, charNew, charTab);
                writer.startDocument();
                HashMap<String, String> prefixes = new HashMap<String, String>();
                this.startPrefixTree(root, prefixes);
                for (String uri : prefixes.keySet()) {
                    String prefix = (String)prefixes.get(uri);
                    writer.startPrefixMapping(prefix, uri);
                }
                try {
                    this.writeTree(writer, root, true);
                }
                catch (ElementObjectPropertyValueException e) {
                    throw new SAXException(e);
                }
                writer.endDocument();
                out.flush();
            }
            catch (Exception e) {
                throw new X4OPhaseException((X4OPhase)this, e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        X4OPhaseLanguageWrite.this.logger.warning(e.getMessage());
                    }
                }
            }
        }

        private void startPrefixTree(Element element, Map<String, String> result) throws SAXException {
            String elementUri = this.findElementUri(element);
            if (!result.containsKey(elementUri)) {
                String elementUriPrefix = this.findNamespacePrefix(element, elementUri);
                result.put(elementUri, elementUriPrefix);
            }
            for (Element e : element.getChilderen()) {
                this.startPrefixTree(e, result);
            }
        }

        private List<String> getProperties(Class<?> objectClass) {
            ArrayList<String> result = new ArrayList<String>();
            for (Method m : objectClass.getMethods()) {
                Class<?>[] types = m.getParameterTypes();
                if (types.length != 0 || m.getName().equals("getClass") || !m.getName().startsWith("get")) continue;
                String name = m.getName().substring(3, 4).toLowerCase() + m.getName().substring(4);
                result.add(name);
            }
            return result;
        }

        private void writeTree(ContentWriterXml writer, Element element, boolean isRoot) throws SAXException, ElementObjectPropertyValueException {
            ArrayList<AttributeEntry> attr = new ArrayList<AttributeEntry>(20);
            if (element.getElementClass().getAutoAttributes() != null && !element.getElementClass().getAutoAttributes().booleanValue()) {
                for (ElementClassAttribute eca : element.getElementClass().getElementClassAttributes()) {
                    Object value;
                    if (eca.getRunBeanValue() != null && !eca.getRunBeanValue().booleanValue() || (value = element.getLanguageContext().getElementObjectPropertyValue().getProperty(element.getElementObject(), eca.getId())) == null) continue;
                    AttributeEntry attributeEntry = new AttributeEntry();
                    attributeEntry.id = eca.getId();
                    attributeEntry.value = "" + value;
                    attributeEntry.writeOrder = this.calcOrderNumber(attributeEntry.id, eca.getWriteOrder());
                    attr.add(attributeEntry);
                }
            } else {
                for (String p : this.getProperties(element.getElementObject().getClass())) {
                    Object value;
                    Integer writeOrder = null;
                    ElementClassAttribute elementClassAttribute = element.getElementClass().getElementClassAttributeByName(p);
                    if (elementClassAttribute != null) {
                        writeOrder = elementClassAttribute.getWriteOrder();
                    }
                    if (elementClassAttribute != null && elementClassAttribute.getRunBeanValue() != null && elementClassAttribute.getRunBeanValue().booleanValue()) continue;
                    boolean writeValue = true;
                    for (ElementInterface ei : element.getLanguageContext().getLanguage().findElementInterfaces(element.getElementObject().getClass())) {
                        ElementClassAttribute elementClassAttribute2 = ei.getElementClassAttributeByName(p);
                        if (elementClassAttribute2 != null && writeOrder == null) {
                            writeOrder = elementClassAttribute2.getWriteOrder();
                        }
                        if (elementClassAttribute2 == null || elementClassAttribute2.getRunBeanValue() == null || elementClassAttribute2.getRunBeanValue().booleanValue()) continue;
                        writeValue = false;
                        break;
                    }
                    if (!writeValue || (value = element.getLanguageContext().getElementObjectPropertyValue().getProperty(element.getElementObject(), p)) == null || value instanceof List || value instanceof Collection) continue;
                    AttributeEntry e = new AttributeEntry();
                    e.id = p;
                    e.value = "" + value;
                    e.writeOrder = this.calcOrderNumber(e.id, writeOrder);
                    attr.add(e);
                }
            }
            AttributesImpl atts = new AttributesImpl();
            if (isRoot && this.schemaUriPrint) {
                String rootUri = this.findElementUri(element);
                writer.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                atts.addAttribute("xsi", "schemaLocation", "", "", rootUri + " " + this.schemaUriRoot);
            }
            Collections.sort(attr, this.attributeEntryComparator);
            for (int i = 0; i < attr.size(); ++i) {
                AttributeEntry a = (AttributeEntry)attr.get(i);
                atts.addAttribute("", a.id, "", "", a.value);
            }
            String elementUri = this.findElementUri(element);
            writer.startElement(elementUri, element.getElementClass().getId(), "", atts);
            for (Element element2 : element.getChilderen()) {
                this.writeTree(writer, element2, false);
            }
            writer.endElement(elementUri, element.getElementClass().getId(), "");
        }

        private Integer calcOrderNumber(String name, Integer orderNumberOverride) {
            if (orderNumberOverride != null) {
                return orderNumberOverride;
            }
            if (name == null) {
                throw new NullPointerException("Can't calculate order of null name.");
            }
            int nameSize = name.length();
            if (nameSize == 1) {
                return name.charAt(0) * 1000;
            }
            if (nameSize == 2) {
                return name.charAt(0) * 1000 + name.charAt(1) * 100;
            }
            if (nameSize == 3) {
                return name.charAt(0) * 1000 + name.charAt(1) * 100 + name.charAt(2) * 10;
            }
            if (nameSize > 3) {
                return name.charAt(0) * 1000 + name.charAt(1) * 100 + name.charAt(2) * 10 + name.charAt(3) * '\u0001';
            }
            throw new IllegalArgumentException("Can't calculate order of empty name.");
        }

        private String findElementUri(Element e) {
            for (X4OLanguageModule mod : e.getLanguageContext().getLanguage().getLanguageModules()) {
                for (ElementNamespaceContext c : mod.getElementNamespaceContexts()) {
                    ElementClass ec = c.getElementClass(e.getElementClass().getId());
                    if (ec == null) continue;
                    return c.getUri();
                }
            }
            return null;
        }

        private String findNamespacePrefix(Element e, String uri) {
            ElementNamespaceContext ns = e.getLanguageContext().getLanguage().findElementNamespaceContext(uri);
            if (ns.getPrefixMapping() != null) {
                return ns.getPrefixMapping();
            }
            return ns.getId();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AttributeEntryComparator
        implements Comparator<AttributeEntry> {
            AttributeEntryComparator() {
            }

            @Override
            public int compare(AttributeEntry o1, AttributeEntry o2) {
                return o1.writeOrder.compareTo(o2.writeOrder);
            }
        }

        class AttributeEntry {
            String id;
            String value;
            Integer writeOrder;

            AttributeEntry() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class X4OPhaseWriteFillTree
    extends AbstractX4OPhase {
        X4OPhaseWriteFillTree() {
        }

        @Override
        public X4OPhaseType getType() {
            return X4OPhaseType.XML_WRITE;
        }

        @Override
        public String getId() {
            return "WRITE_FILL_TREE";
        }

        @Override
        public String[] getPhaseDependencies() {
            return new String[]{"WRITE_START"};
        }

        @Override
        public boolean isElementPhase() {
            return false;
        }

        @Override
        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        @Override
        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            try {
                Element root = languageContext.getRootElement();
                if (root.getElementClass() == null) {
                    root = this.fillElementTree(languageContext, root.getElementObject());
                }
            }
            catch (Exception e) {
                throw new X4OPhaseException((X4OPhase)this, e);
            }
        }

        private Element fillElementTree(X4OLanguageContext languageContext, Object object) throws ElementNamespaceInstanceProviderException, ElementBindingHandlerException {
            Element element = this.findRootElement(languageContext, object.getClass());
            element.setElementObject(object);
            languageContext.setRootElement(element);
            for (ElementBindingHandler bind : languageContext.getLanguage().findElementBindingHandlers(object)) {
                bind.createChilderen(element);
                this.fillTree(languageContext, element);
            }
            return element;
        }

        private void fillTree(X4OLanguageContext languageContext, Element element) throws ElementNamespaceInstanceProviderException, ElementBindingHandlerException {
            for (Element e : element.getChilderen()) {
                Object object = e.getElementObject();
                for (ElementBindingHandler bind : languageContext.getLanguage().findElementBindingHandlers(object)) {
                    bind.createChilderen(e);
                    this.fillTree(languageContext, e);
                }
            }
        }

        private Element findRootElement(X4OLanguageContext languageContext, Class<?> objectClass) throws ElementNamespaceInstanceProviderException {
            for (X4OLanguageModule modContext : languageContext.getLanguage().getLanguageModules()) {
                for (ElementNamespaceContext nsContext : modContext.getElementNamespaceContexts()) {
                    if (nsContext.getLanguageRoot() == null || !nsContext.getLanguageRoot().booleanValue()) continue;
                    for (ElementClass ec : nsContext.getElementClasses()) {
                        if (ec.getObjectClass() == null || !ec.getObjectClass().equals(objectClass)) continue;
                        return nsContext.getElementNamespaceInstanceProvider().createElementInstance(languageContext, ec.getId());
                    }
                }
            }
            for (X4OLanguageModule modContext : languageContext.getLanguage().getLanguageModules()) {
                for (ElementNamespaceContext nsContext : modContext.getElementNamespaceContexts()) {
                    for (ElementClass ec : nsContext.getElementClasses()) {
                        if (ec.getObjectClass() == null || !ec.getObjectClass().equals(objectClass)) continue;
                        return nsContext.getElementNamespaceInstanceProvider().createElementInstance(languageContext, ec.getId());
                    }
                }
            }
            throw new IllegalArgumentException("Could not find ElementClass for: " + objectClass.getName());
        }
    }

    class X4OPhaseWriteStart
    extends AbstractX4OPhase {
        X4OPhaseWriteStart() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.XML_WRITE;
        }

        public String getId() {
            return "WRITE_START";
        }

        public String[] getPhaseDependencies() {
            return new String[0];
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            X4OPhaseLanguageWrite.this.logger.finest("Run init start phase");
        }
    }
}

