/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.x4o.xml.io.AbstractX4OConnection;
import org.x4o.xml.io.X4OConnectionException;
import org.x4o.xml.io.X4OReaderContext;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractX4OReaderContext<T>
extends AbstractX4OConnection
implements X4OReaderContext<T> {
    public AbstractX4OReaderContext(X4OLanguageContext languageContext) {
        super(languageContext);
    }

    @Override
    public X4OLanguageContext readFileContext(String fileName) throws X4OConnectionException, SAXException, IOException, FileNotFoundException {
        if (fileName == null) {
            throw new NullPointerException("Can't convert null fileName to file object.");
        }
        return this.readFileContext(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X4OLanguageContext readFileContext(File file) throws X4OConnectionException, SAXException, IOException, FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("Can't read null file.");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exists; " + file);
        }
        if (!file.canRead()) {
            throw new IOException("File exists but can't read file: " + file);
        }
        URL basePath = new File(file.getAbsolutePath()).toURI().toURL();
        FileInputStream inputStream = new FileInputStream(file);
        try {
            X4OLanguageContext x4OLanguageContext = this.readContext(inputStream, file.getAbsolutePath(), basePath);
            return x4OLanguageContext;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X4OLanguageContext readResourceContext(String resourceName) throws X4OConnectionException, SAXException, IOException {
        if (resourceName == null) {
            throw new NullPointerException("Can't read null resourceName from classpath.");
        }
        URL url = X4OLanguageClassLoader.getResource(resourceName);
        if (url == null) {
            throw new NullPointerException("Could not find resource on classpath: " + resourceName);
        }
        String baseUrl = url.toExternalForm();
        int lastSlash = baseUrl.lastIndexOf(47);
        if (lastSlash > 0 && lastSlash + 1 < baseUrl.length()) {
            baseUrl = baseUrl.substring(0, lastSlash + 1);
        }
        URL basePath = new URL(baseUrl);
        InputStream inputStream = X4OLanguageClassLoader.getResourceAsStream(resourceName);
        try {
            X4OLanguageContext x4OLanguageContext = this.readContext(inputStream, url.toExternalForm(), basePath);
            return x4OLanguageContext;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public X4OLanguageContext readStringContext(String xmlString) throws X4OConnectionException, SAXException, IOException {
        if (xmlString == null) {
            throw new NullPointerException("Can't read null xml string.");
        }
        URL basePath = new File(System.getProperty("user.dir")).toURI().toURL();
        String encoding = this.getLanguageContext().getLanguagePropertyString(X4OLanguageProperty.READER_INPUT_ENCODING);
        return this.readContext(new ByteArrayInputStream(xmlString.getBytes(encoding)), "inline-xml", basePath);
    }

    @Override
    public X4OLanguageContext readUrlContext(URL url) throws X4OConnectionException, SAXException, IOException {
        if (url == null) {
            throw new NullPointerException("Can't read null url.");
        }
        URL basePath = new URL(url.toExternalForm().substring(0, url.toExternalForm().length() - url.getFile().length()));
        return this.readContext(url.openStream(), url.toExternalForm(), basePath);
    }
}

