/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang;

import junit.framework.TestCase;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.x4o.xml.lang.X4OLanguagePropertyKeys;

public class X4OLanguagePropertyTest
extends TestCase {
    public void testUriValue() throws Exception {
        new X4OLanguagePropertyKeys();
        X4OLanguageProperty prop = X4OLanguageProperty.valueByUri((String)X4OLanguagePropertyKeys.LANGUAGE_NAME);
        X4OLanguagePropertyTest.assertNotNull((Object)prop);
        X4OLanguagePropertyTest.assertEquals((String)X4OLanguagePropertyKeys.LANGUAGE_NAME, (String)prop.toUri());
    }

    public void testUriValueNullError() throws Exception {
        Exception e = null;
        try {
            X4OLanguageProperty.valueByUri(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OLanguagePropertyTest.assertNotNull((Object)e);
        X4OLanguagePropertyTest.assertEquals(NullPointerException.class, e.getClass());
        X4OLanguagePropertyTest.assertTrue((boolean)e.getMessage().contains("uri"));
    }

    public void testUriValueEmptyError() throws Exception {
        Exception e = null;
        try {
            X4OLanguageProperty.valueByUri((String)"");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OLanguagePropertyTest.assertNotNull((Object)e);
        X4OLanguagePropertyTest.assertEquals(IllegalArgumentException.class, e.getClass());
        X4OLanguagePropertyTest.assertTrue((boolean)e.getMessage().contains("empty"));
    }

    public void testUriValuePrefixError() throws Exception {
        Exception e = null;
        try {
            X4OLanguageProperty.valueByUri((String)"foobar");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OLanguagePropertyTest.assertNotNull((Object)e);
        X4OLanguagePropertyTest.assertEquals(IllegalArgumentException.class, e.getClass());
        X4OLanguagePropertyTest.assertTrue((boolean)e.getMessage().contains("foobar"));
    }

    public void testUriValueMissingError() throws Exception {
        Exception e = null;
        try {
            X4OLanguageProperty.valueByUri((String)"http://language.x4o.org/xml/properties/some-missing-property");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OLanguagePropertyTest.assertNotNull((Object)e);
        X4OLanguagePropertyTest.assertEquals(IllegalArgumentException.class, e.getClass());
        X4OLanguagePropertyTest.assertTrue((boolean)e.getMessage().contains("some-missing-property"));
    }

    public void testValidValue() throws Exception {
        X4OLanguageProperty langName = X4OLanguageProperty.valueByUri((String)X4OLanguagePropertyKeys.LANGUAGE_NAME);
        X4OLanguageProperty langVersion = X4OLanguageProperty.valueByUri((String)X4OLanguagePropertyKeys.LANGUAGE_VERSION);
        X4OLanguagePropertyTest.assertEquals((boolean)false, (boolean)langName.isValueValid((Object)"new-name"));
        X4OLanguagePropertyTest.assertEquals((boolean)false, (boolean)langVersion.isValueValid((Object)"new-version"));
    }

    public void testValidValueNull() throws Exception {
        X4OLanguageProperty elMap = X4OLanguageProperty.valueByUri((String)X4OLanguagePropertyKeys.EL_BEAN_INSTANCE_MAP);
        X4OLanguagePropertyTest.assertEquals((boolean)true, (boolean)elMap.isValueValid(null));
    }

    public void testValidValueObject() throws Exception {
        X4OLanguageProperty elMap = X4OLanguageProperty.valueByUri((String)X4OLanguagePropertyKeys.EL_BEAN_INSTANCE_MAP);
        X4OLanguagePropertyTest.assertEquals((boolean)false, (boolean)elMap.isValueValid((Object)"string-object"));
    }
}

