/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.x4o.xml.element.Element;
import org.x4o.xml.io.X4OConnectionException;
import org.x4o.xml.io.X4OReader;
import org.x4o.xml.io.X4OWriterContext;
import org.x4o.xml.io.X4OWriterTest;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.test.TestDriver;
import org.x4o.xml.test.models.TestObjectRoot;
import org.xml.sax.SAXException;

public class X4OWriterContextTest
extends TestCase {
    private File createOutputFile() throws IOException {
        File outputFile = File.createTempFile("test-writer-context", ".xml");
        outputFile.deleteOnExit();
        return outputFile;
    }

    private X4OLanguageContext createContext() throws SAXException, X4OConnectionException, IOException {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        TestObjectRoot root = (TestObjectRoot)reader.readResource("tests/attributes/test-bean.xml");
        X4OLanguageContext context = driver.createLanguageContext();
        Element rootElement = null;
        try {
            rootElement = (Element)context.getLanguage().getLanguageConfiguration().getDefaultElement().newInstance();
        }
        catch (InstantiationException e) {
            throw new SAXException(e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException(e);
        }
        rootElement.setElementObject((Object)root);
        context.setRootElement(rootElement);
        return context;
    }

    public void testWriteFile() throws Exception {
        File outputFile = this.createOutputFile();
        TestDriver driver = TestDriver.getInstance();
        X4OWriterContext writer = driver.createWriterContext();
        writer.writeFileContext(this.createContext(), outputFile);
        String text = X4OWriterTest.readFile(outputFile);
        outputFile.delete();
        X4OWriterContextTest.assertTrue((boolean)text.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("http://test.x4o.org/xml/ns/test-root"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("<test-lang:parent name=\"test-bean.xml\"/>"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("<test-lang:testBean"));
    }

    public void testWriteFileNull() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OWriterContext writer = driver.createWriterContext();
        Exception e = null;
        File nullFile = null;
        try {
            writer.writeFileContext(this.createContext(), nullFile);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OWriterContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OWriterContextTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OWriterContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OWriterContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("file"));
    }

    public void testWriteFileName() throws Exception {
        File outputFile = this.createOutputFile();
        TestDriver driver = TestDriver.getInstance();
        X4OWriterContext writer = driver.createWriterContext();
        writer.writeFileContext(this.createContext(), outputFile.getAbsolutePath());
        String text = X4OWriterTest.readFile(outputFile);
        outputFile.delete();
        X4OWriterContextTest.assertTrue((boolean)text.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("http://test.x4o.org/xml/ns/test-root"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("<test-lang:parent name=\"test-bean.xml\"/>"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("<test-lang:testBean"));
    }

    public void testWriteFileNameNull() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OWriterContext writer = driver.createWriterContext();
        Exception e = null;
        String nullFileName = null;
        try {
            writer.writeFileContext(this.createContext(), nullFileName);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OWriterContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OWriterContextTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OWriterContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OWriterContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("fileName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteStream() throws Exception {
        File outputFile = this.createOutputFile();
        TestDriver driver = TestDriver.getInstance();
        X4OWriterContext writer = driver.createWriterContext();
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            writer.writeContext(this.createContext(), (OutputStream)outputStream);
        }
        finally {
            ((OutputStream)outputStream).close();
        }
        String text = X4OWriterTest.readFile(outputFile);
        outputFile.delete();
        X4OWriterContextTest.assertTrue((boolean)text.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("http://test.x4o.org/xml/ns/test-root"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("<test-lang:parent name=\"test-bean.xml\"/>"));
        X4OWriterContextTest.assertTrue((boolean)text.contains("<test-lang:testBean"));
    }
}

