/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.x4o.xml.io.X4OReader;
import org.x4o.xml.io.X4OReaderContext;
import org.x4o.xml.io.X4OWriter;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.test.TestDriver;
import org.x4o.xml.test.models.TestBean;
import org.x4o.xml.test.models.TestObjectRoot;

public class X4OReaderContextTest
extends TestCase {
    private File copyResourceToTempFile() throws IOException {
        File tempFile = File.createTempFile("test-resource", ".xml");
        tempFile.deleteOnExit();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        X4OWriter writer = driver.createWriter();
        try {
            writer.writeFile(reader.readResource("tests/attributes/test-bean.xml"), tempFile);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return tempFile;
    }

    public void testReadFileName() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        File xmlFile = this.copyResourceToTempFile();
        X4OLanguageContext context = reader.readFileContext(xmlFile.getAbsolutePath());
        TestObjectRoot root = (TestObjectRoot)context.getRootElement().getElementObject();
        X4OReaderContextTest.assertNotNull((Object)root);
        X4OReaderContextTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderContextTest.assertNotNull((Object)bean);
    }

    public void testReadFileNameNull() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        Exception e = null;
        try {
            String nullFileName = null;
            reader.readFileContext(nullFileName);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderContextTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("fileName"));
    }

    public void testReadFile() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        File xmlFile = this.copyResourceToTempFile();
        X4OLanguageContext context = reader.readFileContext(xmlFile);
        TestObjectRoot root = (TestObjectRoot)context.getRootElement().getElementObject();
        X4OReaderContextTest.assertNotNull((Object)root);
        X4OReaderContextTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderContextTest.assertNotNull((Object)bean);
    }

    public void testReadFileNull() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        Exception e = null;
        try {
            File nullFile = null;
            reader.readFileContext(nullFile);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderContextTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("file"));
    }

    public void testReadFileNotExists() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        Exception e = null;
        try {
            File tempFile = File.createTempFile("test-file", ".xml");
            tempFile.delete();
            reader.readFileContext(tempFile);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderContextTest.assertEquals((String)"Wrong exception class", FileNotFoundException.class, e.getClass());
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("exists"));
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("File"));
    }

    public void testReadFileNotReadable() throws Exception {
        if (File.separatorChar != '/') {
            return;
        }
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        Exception e = null;
        try {
            reader.readFileContext(new File("/etc/shadow"));
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderContextTest.assertEquals((String)"Wrong exception class", IOException.class, e.getClass());
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("exists"));
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("read"));
    }

    public void testReadResource() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        X4OLanguageContext context = reader.readResourceContext("tests/attributes/test-bean.xml");
        TestObjectRoot root = (TestObjectRoot)context.getRootElement().getElementObject();
        X4OReaderContextTest.assertNotNull((Object)root);
    }

    public void testReadResourceNull() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        Exception e = null;
        try {
            reader.readResourceContext(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderContextTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("resourceName"));
    }

    public void testReadString() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        X4OLanguageContext context = reader.readStringContext("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root:root xmlns:root=\"http://test.x4o.org/xml/ns/test-root\" xmlns=\"http://test.x4o.org/xml/ns/test-lang\"><testBean privateIntegerTypeField=\"987654321\"/></root:root>");
        TestObjectRoot root = (TestObjectRoot)context.getRootElement().getElementObject();
        X4OReaderContextTest.assertNotNull((Object)root);
        X4OReaderContextTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderContextTest.assertNotNull((Object)bean);
        X4OReaderContextTest.assertEquals((String)"987654321", (String)("" + bean.getPrivateIntegerTypeField()));
    }

    public void testReadStringNull() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        Exception e = null;
        try {
            reader.readStringContext(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderContextTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("string"));
    }

    public void testReadUrl() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        URL xmlUrl = Thread.currentThread().getContextClassLoader().getResource("tests/attributes/test-bean.xml");
        X4OLanguageContext context = reader.readUrlContext(xmlUrl);
        TestObjectRoot root = (TestObjectRoot)context.getRootElement().getElementObject();
        X4OReaderContextTest.assertNotNull((Object)root);
        X4OReaderContextTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderContextTest.assertNotNull((Object)bean);
    }

    public void testReadUrlNull() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        Exception e = null;
        try {
            reader.readUrlContext(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderContextTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderContextTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderContextTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("url"));
    }
}

