/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml;

import java.util.List;
import junit.framework.TestCase;
import org.x4o.xml.X4ODriver;
import org.x4o.xml.X4ODriverManager;

public class X4ODriverManagerTest
extends TestCase {
    public void testDefaultLanguageVersionSelect() throws Exception {
        String version = X4ODriverManager.getDefaultLanguageVersion((String[])new String[]{"1.0", "2.0", "3.0"});
        X4ODriverManagerTest.assertNotNull((Object)version);
        X4ODriverManagerTest.assertEquals((String)"3.0", (String)version);
    }

    public void testDefaultLanguageVersionEmpty() throws Exception {
        String version = X4ODriverManager.getDefaultLanguageVersion((String[])new String[0]);
        X4ODriverManagerTest.assertNotNull((Object)version);
        X4ODriverManagerTest.assertEquals((String)"1.0", (String)version);
    }

    public void testDefaultLanguageVersionNull() throws Exception {
        String version = X4ODriverManager.getDefaultLanguageVersion(null);
        X4ODriverManagerTest.assertNotNull((Object)version);
        X4ODriverManagerTest.assertEquals((String)"1.0", (String)version);
    }

    public void testLanguageNull() throws Exception {
        String language = null;
        Exception e = null;
        try {
            X4ODriverManager.getX4ODriver(language);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((Object)e);
        X4ODriverManagerTest.assertEquals(NullPointerException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((boolean)e.getMessage().contains("language"));
    }

    public void testLanguageEmpty() throws Exception {
        String language = "";
        Exception e = null;
        try {
            X4ODriverManager.getX4ODriver((String)language);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((Object)e);
        X4ODriverManagerTest.assertEquals(IllegalArgumentException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Error message string is missing language", (boolean)e.getMessage().contains("language"));
    }

    public void testLanguageVersionNonExcisting() throws Exception {
        String language = "test";
        String version = "99.9";
        Throwable e = null;
        try {
            X4ODriver driver = X4ODriverManager.getX4ODriver((String)language);
            driver.createLanguageContext(version);
        }
        catch (Throwable catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((Object)e);
    }

    public void testLanguageCount() throws Exception {
        List languages = X4ODriverManager.getX4OLanguages();
        X4ODriverManagerTest.assertNotNull((Object)languages);
        X4ODriverManagerTest.assertFalse((boolean)languages.isEmpty());
    }

    public void testLanguageNames() throws Exception {
        List languages = X4ODriverManager.getX4OLanguages();
        X4ODriverManagerTest.assertNotNull((Object)languages);
        X4ODriverManagerTest.assertTrue((String)"cel language is missing", (boolean)languages.contains("cel"));
        X4ODriverManagerTest.assertTrue((String)"eld language is missing", (boolean)languages.contains("eld"));
        X4ODriverManagerTest.assertTrue((String)"test language is missing", (boolean)languages.contains("test"));
    }

    public void testLanguagesLoopSpeed() throws Exception {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            this.testLanguageCount();
        }
        long loopTime = System.currentTimeMillis() - startTime;
        X4ODriverManagerTest.assertEquals((String)("Language list loop is slow;" + loopTime), (boolean)true, (loopTime < 500L ? 1 : 0) != 0);
    }

    public void testRegisterDriverNull() throws Exception {
        Exception e = null;
        try {
            X4ODriverManager.registerX4ODriver(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((String)"No exception", (Object)e);
        X4ODriverManagerTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
    }

    public void testRegisterDriverNameNull() throws Exception {
        Exception e = null;
        try {
            X4ODriverManager.registerX4ODriver((X4ODriver)new X4ODriver<Object>(){

                public String[] getLanguageVersions() {
                    return new String[]{"1.0"};
                }

                public String getLanguageName() {
                    return null;
                }
            });
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((String)"No exception", (Object)e);
        X4ODriverManagerTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
    }

    public void testRegisterDriverNameEmpty() throws Exception {
        Exception e = null;
        try {
            X4ODriverManager.registerX4ODriver((X4ODriver)new X4ODriver<Object>(){

                public String[] getLanguageVersions() {
                    return new String[]{"1.0"};
                }

                public String getLanguageName() {
                    return "";
                }
            });
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((String)"No exception", (Object)e);
        X4ODriverManagerTest.assertEquals((String)"Wrong exception class", IllegalArgumentException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("empty"));
    }

    public void testRegisterDriverVersionNull() throws Exception {
        Exception e = null;
        try {
            X4ODriverManager.registerX4ODriver((X4ODriver)new X4ODriver<Object>(){

                public String[] getLanguageVersions() {
                    return null;
                }

                public String getLanguageName() {
                    return "junit-driver-test";
                }
            });
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((String)"No exception", (Object)e);
        X4ODriverManagerTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
    }

    public void testRegisterDriverVersionEmpty() throws Exception {
        Exception e = null;
        try {
            X4ODriverManager.registerX4ODriver((X4ODriver)new X4ODriver<Object>(){

                public String[] getLanguageVersions() {
                    return new String[0];
                }

                public String getLanguageName() {
                    return "junit-driver-test";
                }
            });
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((String)"No exception", (Object)e);
        X4ODriverManagerTest.assertEquals((String)"Wrong exception class", IllegalArgumentException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("empty"));
    }

    public void testDeregisterDriverNull() throws Exception {
        Exception e = null;
        try {
            X4ODriverManager.deregisterX4ODriver(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((String)"No exception", (Object)e);
        X4ODriverManagerTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
    }

    public void testDeregisterDriverNameNull() throws Exception {
        Exception e = null;
        try {
            X4ODriverManager.deregisterX4ODriver((X4ODriver)new X4ODriver<Object>(){

                public String[] getLanguageVersions() {
                    return new String[]{"1.0"};
                }

                public String getLanguageName() {
                    return null;
                }
            });
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((String)"No exception", (Object)e);
        X4ODriverManagerTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
    }

    public void testDeregisterDriverInstance() throws Exception {
        Exception e = null;
        try {
            X4ODriver<Object> driver = new X4ODriver<Object>(){

                public String[] getLanguageVersions() {
                    return new String[]{"1.0"};
                }

                public String getLanguageName() {
                    return "junit-driver-test";
                }
            };
            X4ODriverManager.registerX4ODriver((X4ODriver)driver);
            X4ODriverManagerTest.assertEquals((int)driver.hashCode(), (int)X4ODriverManager.getX4ODriver((String)"junit-driver-test").hashCode());
            X4ODriverManager.deregisterX4ODriver((X4ODriver)driver);
            X4ODriverManager.getX4ODriver((String)"junit-driver-test");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4ODriverManagerTest.assertNotNull((String)"No exception", (Object)e);
        X4ODriverManagerTest.assertEquals((String)"Wrong exception class", IllegalArgumentException.class, e.getClass());
        X4ODriverManagerTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("junit-driver-test"));
    }
}

