/* Copyright (c) 2009 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id$ */
/** Example for use of Lightweight Mesh, third node (receiving) */

/* === includes ============================================================ */
#include "board.h"
#include "xmpl_lw_mesh.h"
#include "lw_mesh.h"

/* === macros ============================================================== */

/* === types =============================================================== */

/* === globals ============================================================= */

/* === prototypes ========================================================== */

/* === functions =========================================================== */
static bool rx_endpoint_data_ind(NWK_DataInd_t *ind)
{
    LED_TOGGLE(0);

    /* do not send acknowledgment frames except underlying layers needs some */
    return false;
}

void app_task_handler()
{
    /* do some application specific things */
}

int main(void)
{
    /* This will stop the application before initializing the radio transceiver
     * (ISP issue with MISO pin, see FAQ)
     */
    trap_if_key_pressed();

    /* init LEDs */
    LED_INIT();
    LED_SET_VALUE(LED_MAX_VALUE);
    DELAY_MS(20);
    LED_SET_VALUE(0);

    /* init radio and lw_mesh and enable global interrupts */
    lw_mesh_init(PANID, RX_SHORT_ADDR, CHANNEL);
    sei();

    /* register endpoint */
    lw_mesh_open_endpoint(RX_ENDPOINT_ID, rx_endpoint_data_ind);

    while(1)
    {
        lw_mesh_task_handler();
        app_task_handler();
    }
}
/* EOF */

