/* Copyright (c) 2011 Daniel Thiele
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

#ifndef SENSORS_H_
#define SENSORS_H_

/* === includes ============================================================ */

/* === macros ============================================================== */

#define PRESS_EOC_PORT PORTD
#define PRESS_EOC_DDR DDRD
#define PRESS_EOC_PIN PIND
#define PRESS_EOC_bp (PD0)

#define COMP_DRDY_PORT PORTC
#define COMP_DRDY_DDR DDRC
#define COMP_DRDY_PIN PINC
#define COMP_DRDY_bp (PC3)

#define ACC_INT1_PORT PORTD
#define ACC_INT1_DDR DDRD
#define ACC_INT1_PIN PIND
#define ACC_INT1_bp (PD1)

#define MMA7455_INT1_EN() do{ PCMSK2 |= _BV(PCINT18); }while(0)
#define MMA7455_INT1_DIS() do{ PCMSK2 &= ~_BV(PCINT18); }while(0)
#define MMA7455_INT2_EN() do{ PCMSK2 |= _BV(PCINT17); }while(0)
#define MMA7455_INT2_DIS() do{ PCMSK2 &= ~_BV(PCINT17); }while(0)

#define STH21_CMD_TMEAS_HOLD	(0xE3)
#define STH21_CMD_RHMEAS_HOLD	(0xE5)
#define STH21_CMD_TMEAS_NOHOLD	(0xF3)
#define STH21_CMD_RHMEAS_NOHOLD	(0xF5)
#define SHT21_CMD_WR_USERREG	(0xE6)
#define SHT21_CMD_RD_USERREG	(0xE7)
#define STH21_CMD_SOFTRESET		(0xFE)

/* I2C addresses (already shifted left 1 to left-align to MSB) */
#define SENSORS_I2CADDR_LIS3331 (0x32)
#define SENSORS_I2CADDR_HMC5883 (0x3C)
#define SENSORS_I2CADDR_BMP085 (0xEE)

#define SENSORS_I2CADDR_MMA7455 (0x3A)
#define SENSORS_I2CADDR_SHT21   (0x80)

/* === types =============================================================== */

typedef struct{
	int16_t x;
	int16_t y;
	int16_t z;
}sensors_xyz_result_t;

/* === prototypes ========================================================== */
#ifdef __cplusplus
extern "C" {
#endif

void sensors_init(void);

void sensors_lis331_trigger(void);
void sensors_lis331_powerdown(void);
void sensors_lis331_finished_cb(uint16_t result);
void sensors_lis331hh_readresult(sensors_xyz_result_t *result);

uint16_t sensors_bmp085_readresult(void);
void sensors_bmp085_readee(uint8_t *buf);
void sensors_bmp085_ut_trigger(void);
void sensors_bmp085_up_trigger(void);
void sensors_bmp085_finished_cb(uint16_t result);

void sensors_hmc5883l_identification(uint8_t *buf);
void sensors_hmc5883l_trigger(void);
void sensors_hmc5883l_readresult(sensors_xyz_result_t *result);

void sensors_sht21_softreset(void);
uint8_t sensors_sht21_identification(uint8_t *buf, uint8_t maxbytes);
void sensors_sht21_trigger(uint8_t cmd);
uint8_t sensors_sht21_readresult(uint16_t *res);

uint16_t measure_vmcu(void);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif  /* #ifndef SENSORS_H_ */
