# menu.sh - an introduction to busybox and tinycc

# tcc executable (full path)
test "$USRBIN" || USRBIN=$(pwd)
tcc="$USRBIN/tcc/tcc.exe"
cd $USRBIN

# URL to a current tinycc mob snapshot
snapshot="http://repo.or.cz/tinycc.git/snapshot/mob.tar.gz"
test "$wget" || wget="wget"

# Machine target
target=`uname -m`
if test "$target" = "x86_64" ; then m="-m64" ; else m="-m32" ; fi

# ./configure args
config_tcc="--config-mingw32 --prefix=../tcc --cc=\"$tcc $m\""
config_gcc="--config-mingw32 --prefix=../tcc --cc=\"gcc $m\""

# silent make
export SILENT=yes

# useful functions
show() { test -f "$1" && cat "$1" | less; }
run_in() { echo "\$ $2"; ( cd "$1" && eval "$2" ); }
pause() { read -p "Press [Enter] key to continue..."; }
newest() { ls -tc -d $1 2>/dev/null | head -n1; }

# start loop
while true
do
    src=$(newest "tcc-*/ tinycc-*/"); src=${src%/}
    tar=$(newest "tcc-*.tar.* tinycc-*.tar.*")
    if test "${tar%.tar.*}" == "$src"; then tar=""; fi

    clear
    echo
    echo " Welcome to Busybox for TinyCC"
    echo " -----------------------------"
    if test "$menu" != 2; then
        echo " 1 : About (q to return)"
        echo " 2 : Busybox README"
        echo " 3 : Compile and run the 'Fibonacci number' example"
        echo " 4 : Compile and run the 'Find basic ops' example"
        echo " 5 : Compile and run the 'Hello Windows' example"
        echo " 6 : Show TinyCC options"
        echo " 8 : Advanced"
        echo " 0 : Quit"
        echo
        read -p "Enter: " input

        case $input in
	1)  show about.txt;;
	2)  show busybox/README;;
        3)  while read -p "Enter a number (1..20) : " arg; do
              test "$arg" || continue 2
              test $(expr $arg \> 20) = 0 || continue 1
              run_in . "tcc -run tcc/examples/fib.c $arg"
            done;;
        4)  while read -p "Enter <result> <numbers...> : " arg; do
              test "$arg" || continue 2
              run_in . "tcc -run utils/ex21.c $arg"
            done;;
        5)  run_in . "tcc -run tcc/examples/hello_win.c";;
        6)  tcc -h | less;;
        8)  menu=2;;
        0)  break;;
        esac

    else
        test "$src" && echo " 1 : TinyCC README (q to return)"
        echo " S : Download TinyCC source snapshot from http://repo.or.cz"
        if test "$tar"; then
        echo " X : Extract ${tar} from $(date +%a\ %d\ %b\ %Y\ %H:%M -r $tar)"
        fi
        if test -f "$src/config.mak"; then
        echo " m : Make TCC"
        echo " t : Run the TCC tests"
        echo " I : Install/Replace TCC"
        echo " D : Make distclean (delete configuration)"
        elif test "$src"; then
        echo " c : Configure $src to build TCC using TCC"
        echo " g : Configure using GCC instead"
        fi
        echo " s : Shell (exit to return)"
        echo " 7 : Back to Basics"
        echo " 0 : Quit"
        echo
        read -p "Enter: " input

        case $input in
	1)  show $src/README;;
        7)  menu=1;;
        0)  break;;
        S)  if run_in . "$wget $snapshot" && test -f "mob.tar.gz"; then
              rev="$(tar -tf mob.tar.gz | head -n1)"; rev="${rev%%/}"
              test "$rev" && run_in . "mv mob.tar.gz $rev.tar.gz"
            fi
            pause;;
        X)  test "$tar" || continue; run_in . "tar -xf $tar";;
        s)  sh;;
        *)  test "$src" || continue;
            case $input in
            c)  run_in "$src" "./configure ${config_tcc}";;
            g)  run_in "$src" "./configure ${config_gcc}";;
            m)  run_in "$src" "make clean && time make all" && echo "Compilation OK.";;
            t)  run_in "$src" "make test" && echo "Tests OK.";;
            I)  run_in "$src" "make install";;
            D)  run_in "$src" "make distclean";;
            *)  continue;;
            esac
            pause;;
        esac
    fi
done
