/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.BufferedPort;
import gnu.mapping.Future;
import gnu.mapping.LogWriter;
import gnu.mapping.Printable;
import gnu.mapping.SFormat;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class OutPort
extends PrintWriter
implements Printable {
    String name;
    private Writer base;
    BufferedPort bout;
    public boolean printReadable;
    private static OutPort outInitial;
    private static OutPort out;
    private static OutPort errInitial;
    private static OutPort err;
    static Writer logFile;

    static {
        out = outInitial = new OutPort((Writer)new LogWriter(new BufferedWriter(new OutputStreamWriter(System.out))), true, "<stdout>");
        err = errInitial = new OutPort((Writer)new LogWriter(new OutputStreamWriter(System.err)), true, "<stderr>");
    }

    public OutPort(OutputStream outputStream) {
        this(outputStream, null);
    }

    public OutPort(OutputStream outputStream, String string) {
        this((Writer)new OutputStreamWriter(outputStream), true, string);
    }

    public OutPort(Writer writer) {
        this(writer, 512, false);
    }

    public OutPort(Writer writer, int n, boolean bl) {
        this(writer, new BufferedPort(writer, n), bl);
    }

    OutPort(Writer writer, BufferedPort bufferedPort, boolean bl) {
        super((Writer)bufferedPort, bl);
        this.bout = bufferedPort;
        this.base = writer;
    }

    public OutPort(Writer writer, String string) {
        this(writer, 512, false);
        this.name = string;
    }

    public OutPort(Writer writer, boolean bl, String string) {
        this(writer, 512, bl);
        this.name = string;
    }

    public static void closeLogFile() throws IOException {
        if (logFile != null) {
            logFile.close();
            logFile = null;
        }
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile((Writer)null);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile((Writer)null);
        }
    }

    public void echo(char[] cArray, int n, int n2) throws IOException {
        if (this.base instanceof LogWriter) {
            ((LogWriter)this.base).echo(cArray, n, n2);
        }
    }

    public static OutPort errDefault() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            return ((Future)thread2).err;
        }
        return err;
    }

    public int getColumnNumber() {
        return this.bout.getColumnNumber();
    }

    public static OutPort outDefault() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            return ((Future)thread2).out;
        }
        return out;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<output-port");
        if (this.name != null) {
            printWriter.print(' ');
            printWriter.print(this.name);
        }
        printWriter.print('>');
    }

    public static void setErrDefault(OutPort outPort) {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            ((Future)thread2).err = outPort;
        } else {
            err = outPort;
        }
    }

    public static void setLogFile(String string) throws IOException {
        if (logFile != null) {
            OutPort.closeLogFile();
        }
        logFile = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile(logFile);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile(logFile);
        }
    }

    public static void setOutDefault(OutPort outPort) {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            ((Future)thread2).out = outPort;
        } else {
            out = outPort;
        }
    }

    public void writeChar(int n) {
        this.write(n);
    }

    public void writeSchemeObject(Object object2, boolean bl) {
        boolean bl2 = this.printReadable;
        try {
            this.printReadable = bl;
            SFormat.print(object2, this);
        }
        finally {
            Object var5_4 = null;
            this.printReadable = bl2;
        }
    }
}

