/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.Sequence;
import gnu.kawa.util.UniformVector;
import gnu.math.IntNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class U64Vector
extends UniformVector
implements Externalizable {
    long[] data;

    public U64Vector() {
    }

    public U64Vector(int n) {
        this.data = new long[n];
    }

    public U64Vector(int n, long l) {
        long[] lArray = new long[n];
        this.data = lArray;
        while (--n >= 0) {
            lArray[n] = l;
        }
    }

    public U64Vector(Sequence sequence) {
        this.data = new long[sequence.length()];
        this.copy(sequence);
    }

    public U64Vector(long[] lArray) {
        this.data = lArray;
    }

    public final Object get(int n) {
        return IntNum.makeU(this.data[n]);
    }

    public final String getTag() {
        return "u64";
    }

    public final int length() {
        return this.data.length;
    }

    public final long longValue(int n) {
        return this.data[n];
    }

    public final void print(int n, PrintWriter printWriter) {
        long l = this.data[n];
        if (l >= 0L) {
            printWriter.print(l);
        } else {
            printWriter.print(IntNum.makeU(l));
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = objectInput.readLong();
            ++n2;
        }
        this.data = lArray;
    }

    public final void set(int n, long l) {
        this.data[n] = l;
    }

    public final void setElementAt(Object object2, int n) {
        this.data[n] = ((Number)object2).longValue();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.data.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeLong(this.data[n2]);
            ++n2;
        }
    }
}

