/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.AbstractString;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Writer;

public class FString
extends AbstractString
implements Externalizable {
    char[] value;

    public FString() {
    }

    public FString(int n) {
        this.value = new char[n];
    }

    public FString(int n, char c) {
        this.value = new char[n];
        int n2 = n;
        while (--n2 >= 0) {
            this.value[n2] = c;
        }
    }

    public FString(String string) {
        this.value = string.toCharArray();
    }

    public FString(StringBuffer stringBuffer) {
        this(stringBuffer, 0, stringBuffer.length());
    }

    public FString(StringBuffer stringBuffer, int n, int n2) {
        this.value = new char[n2];
        if (n2 > 0) {
            stringBuffer.getChars(n, n + n2, this.value, 0);
        }
    }

    public FString(char[] cArray) {
        this.value = cArray;
    }

    public FString(char[] cArray, int n, int n2) {
        this.value = new char[n2];
        System.arraycopy(cArray, n, this.value, 0, n2);
    }

    public char charAt(int n) {
        return this.value[n];
    }

    public FString copy(int n, int n2) {
        char[] cArray = new char[n2 - n];
        int n3 = n;
        while (n3 < n2) {
            cArray[n3 - n] = this.value[n3];
            ++n3;
        }
        return new FString(cArray);
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof FString)) {
            return false;
        }
        char[] cArray = ((FString)object2).value;
        int n = this.value.length;
        if (cArray == null || cArray.length != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            if (this.value[n2] == cArray[n2]) continue;
            return false;
        }
        return true;
    }

    public final void fill(char c) {
        int n = this.value.length;
        while (--n >= 0) {
            this.value[n] = c;
        }
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.value.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 + n2 - n > cArray.length) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n < n2) {
            System.arraycopy(this.value, n, cArray, n3, n2 - n);
        }
    }

    public int hashCode() {
        char[] cArray = this.value;
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = 31 * n2 + cArray[n3];
            ++n3;
        }
        return n2;
    }

    public final int length() {
        return this.value.length;
    }

    public InPort open() {
        return new CharArrayInPort(this.value, this.value.length);
    }

    public void print(PrintWriter printWriter) {
        if (printWriter instanceof OutPort && ((OutPort)printWriter).printReadable) {
            super.print(printWriter);
        } else {
            printWriter.print(this.toString());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = objectInput.readChar();
            ++n2;
        }
        this.value = cArray;
    }

    public void replace(int n, String string) {
        string.getChars(0, string.length(), this.value, n);
    }

    public void replace(int n, char[] cArray, int n2, int n3) {
        System.arraycopy(cArray, n2, this.value, n, n3);
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.value.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = c;
    }

    public String substring(int n, int n2) {
        return new String(this.value, n, n2 - n);
    }

    public char[] toCharArray() {
        return this.value;
    }

    public String toString() {
        return new String(this.value);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.value.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeChar(this.value[n2]);
            ++n2;
        }
    }

    public void writeTo(int n, int n2, Writer writer) throws IOException {
        int n3 = this.value.length - n;
        if (n2 > n3 || n2 == -1) {
            n2 = n3;
        }
        writer.write(this.value, n, n2);
    }
}

