/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.Frame;
import gnu.jemacs.buffer.Modeline;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;

public class Window
extends JTextPane
implements FocusListener,
ChangeListener {
    Modeline modeline;
    Frame frame;
    Buffer buffer;
    JPanel panel;
    JScrollPane scrollPane;
    int charHeight;
    int charWidth;

    public Window(Buffer buffer) {
        this(buffer, true);
    }

    public Window(Buffer buffer, boolean bl) {
        super(buffer);
        if (bl) {
            this.modeline = new Modeline(this, buffer.modelineDocument);
        }
        this.setBuffer(buffer);
        this.addFocusListener(this);
    }

    public void activateRegion() {
        System.err.println("(activateRegions)");
        Caret caret = this.getCaret();
        caret.setDot(this.buffer.markMarker.getOffset());
        caret.moveDot(this.buffer.getDot());
    }

    public void delete() {
        Frame frame2 = this.frame;
        this.deleteNoValidate();
        if (frame2.getFirstWindow() == null) {
            frame2.delete();
        } else {
            frame2.validate();
        }
    }

    void deleteNoValidate() {
        Container container;
        if (this.frame.selectedWindow == this) {
            container = this.getNextWindowInFrame(1);
            if (this.frame == Frame.selectedFrame) {
                Window.setSelected((Window)container);
            } else {
                this.frame.selectedWindow = container;
            }
        }
        if (this.modeline != null) {
            this.panel.remove(this.modeline);
        }
        this.panel.remove(this.scrollPane);
        container = this.panel.getParent();
        if (container instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)container;
            Component component = this.panel == jSplitPane.getLeftComponent() ? jSplitPane.getRightComponent() : jSplitPane.getLeftComponent();
            jSplitPane.remove(this);
            jSplitPane.remove(component);
            Container container2 = jSplitPane.getParent();
            if (container2 instanceof JSplitPane) {
                JSplitPane jSplitPane2 = (JSplitPane)container2;
                if (jSplitPane == jSplitPane2.getLeftComponent()) {
                    jSplitPane2.setLeftComponent(component);
                } else {
                    jSplitPane2.setRightComponent(component);
                }
            } else {
                container2.remove(jSplitPane);
                container2.add(component);
            }
        } else {
            container.remove(this.panel);
        }
        this.panel = null;
        this.scrollPane = null;
        this.frame = null;
    }

    public void deleteOtherWindows() {
        Window window = this.frame.getFirstWindow();
        while (window != null) {
            Window window2 = window.getNextWindow(true);
            if (window != this) {
                window.deleteNoValidate();
            }
            window = window2;
        }
        this.frame.validate();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setSelected();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    void getCharSize() {
        Font font = this.buffer.getFont(Buffer.defaultStyle);
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(font);
        this.charHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.charWidth('m');
    }

    public static Window getContainedWindow(Container container, boolean bl) {
        while (!(container instanceof Window)) {
            if (container instanceof JScrollPane) {
                container = (Container)((JScrollPane)container).getViewport().getView();
                continue;
            }
            if (container instanceof JFrame) {
                container = ((JFrame)container).getContentPane();
                continue;
            }
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                container = (Container)(bl ? jSplitPane.getRightComponent() : jSplitPane.getLeftComponent());
                continue;
            }
            int n = container.getComponentCount();
            if (n == 0) {
                return null;
            }
            container = (Container)container.getComponent(bl ? n - 1 : 0);
        }
        return (Window)container;
    }

    public static Window getFirstWindow(Container container) {
        return Window.getContainedWindow(container, false);
    }

    public Frame getFrame() {
        return this.frame;
    }

    public int getHeightInLines() {
        if (this.charHeight == 0) {
            this.getCharSize();
        }
        return this.getHeight() / this.charHeight;
    }

    public static Window getLastWindow(Container container) {
        return Window.getContainedWindow(container, true);
    }

    public Window getNextWindow(boolean bl) {
        Container container = this;
        Container container2;
        while ((container2 = container.getParent()) != null) {
            if (container2 instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container2;
                if (container == jSplitPane.getLeftComponent()) {
                    if (bl) {
                        return Window.getFirstWindow((Container)jSplitPane.getRightComponent());
                    }
                } else if (!bl) {
                    return Window.getLastWindow((Container)jSplitPane.getLeftComponent());
                }
            }
            container = container2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Window getNextWindowInFrame(int var1_1) {
        block2: {
            var2_2 = this;
            if (var1_1 <= 0) ** GOTO lbl8
            while (--var1_1 >= 0) {
                var2_2 = var2_2.getOtherWindow(true);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var2_2 = var2_2.getOtherWindow(false);
lbl8:
                // 2 sources

                ** while (++var1_1 <= 0)
            }
        }
        return var2_2;
    }

    public Window getOtherWindow(boolean bl) {
        Window window = this.getNextWindow(bl);
        if (window == null) {
            window = bl ? this.frame.getFirstWindow() : this.frame.getLastWindow();
        }
        return window;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public int getPoint() {
        return 1 + this.getCaret().getDot();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.panel.getSize();
        if (this.modeline != null) {
            dimension = new Dimension(dimension.width, dimension.height - this.modeline.getPreferredSize().height);
        }
        return dimension;
    }

    public static Window getSelected() {
        return Frame.selectedFrame == null ? null : Frame.selectedFrame.selectedWindow;
    }

    public int getWidthInColumns() {
        if (this.charWidth == 0) {
            this.getCharSize();
        }
        return this.getWidth() / this.charWidth;
    }

    public static Window getWindow(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        while (!(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    private void select(Caret caret) {
        this.buffer.curPosition = caret;
        if (this.buffer.pointMarker.position >= 0) {
            this.buffer.content.releasePosition(this.buffer.pointMarker.position);
        }
        this.buffer.pointMarker.position = -1;
        caret.addChangeListener(this);
    }

    public void setBuffer(Buffer buffer) {
        Window window;
        if (this.buffer == buffer) {
            return;
        }
        this.setDocument(buffer);
        this.setKeymap(buffer.keymap);
        if (this.modeline != null) {
            this.modeline.setDocument(buffer.modelineDocument);
        }
        if ((window = Window.getSelected()) == this) {
            this.unselect();
            Caret caret = this.getCaret();
            caret.setDot(buffer.getDot());
            this.select(caret);
        }
        this.buffer = buffer;
    }

    public void setDot(int n) {
        this.getCaret().setDot(n);
    }

    public void setPoint(int n) {
        this.getCaret().setDot(n - 1);
    }

    public void setSelected() {
        Window window = Window.getSelected();
        if (window != null && window.buffer != this.buffer) {
            window.unselect();
        }
        if (this.frame != null) {
            this.frame.selectedWindow = this;
        }
        Frame.selectedFrame = this.frame;
        Buffer.setCurrent(this.buffer);
        this.select(this.getCaret());
    }

    public static void setSelected(Window window) {
        window.setSelected();
        window.requestFocus();
    }

    public Window split(int n, boolean bl) {
        return this.split(this.buffer, n, bl);
    }

    public Window split(Buffer buffer, int n, boolean bl) {
        Window window = new Window(buffer);
        Frame frame2 = this.frame;
        window.modeline = new Modeline(window, buffer.modelineDocument);
        window.frame = frame2;
        JPanel jPanel = this.getPanel();
        Dimension dimension = jPanel.getSize();
        Container container = jPanel.getParent();
        container.remove(jPanel);
        JSplitPane jSplitPane = new JSplitPane(bl ? 1 : 0, jPanel, window.wrap());
        jSplitPane.setDividerSize(2);
        jSplitPane.setDividerLocation((bl ? dimension.width : dimension.height) / 2);
        container.add(jSplitPane);
        container.validate();
        if (this == Window.getSelected()) {
            this.requestFocus();
        }
        return window;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        Caret caret;
        int n2;
        Object object2 = changeEvent.getSource();
        if (object2 instanceof Caret && this.buffer != null && (n2 = (caret = (Caret)object2).getMark()) != (n = caret.getDot())) {
            this.buffer.markMarker.set(this.buffer, n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<window on ");
        if (this.buffer == null) {
            stringBuffer.append("no buffer");
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(this.buffer.getName());
            stringBuffer.append('\"');
        }
        stringBuffer.append(" 0x");
        stringBuffer.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    void unselect() {
        int n;
        int n2 = this.buffer.curPosition.getDot();
        int n3 = 2;
        this.buffer.pointMarker.position = n = this.buffer.content.createPosition(n2, n3);
        this.buffer.curPosition = null;
        this.getCaret().removeChangeListener(this);
    }

    public JPanel wrap() {
        BorderLayout borderLayout = new BorderLayout();
        JPanel jPanel = new JPanel(borderLayout);
        this.scrollPane = new JScrollPane(this, 22, 31);
        jPanel.add((Component)this.scrollPane, "Center");
        if (this.modeline != null) {
            jPanel.add((Component)this.modeline, "South");
        }
        this.panel = jPanel;
        return jPanel;
    }
}

