/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.Target;
import gnu.mapping.Binding;
import gnu.mapping.Binding2;
import gnu.mapping.Environment;
import gnu.mapping.SFormat;
import java.io.PrintWriter;

public class ReferenceExp
extends Expression {
    String symbol;
    Declaration binding;
    static int counter;
    int id = ++counter;
    private static int DONT_DEREFERENCE;
    private static int PROCEDURE_NAME;
    public static int PREFER_BINDING2;

    static {
        DONT_DEREFERENCE = 1;
        PROCEDURE_NAME = 2;
        PREFER_BINDING2 = 4;
    }

    public ReferenceExp(Declaration declaration) {
        this.binding = declaration;
        this.symbol = declaration.getName();
    }

    public ReferenceExp(String string) {
        this.symbol = string;
    }

    public ReferenceExp(String string, Declaration declaration) {
        this.symbol = string;
        this.binding = declaration;
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        Declaration declaration = Declaration.followAliases(this.binding);
        if (declaration != null) {
            declaration.load(compilation);
            if (declaration.isIndirectBinding() && !this.getDontDereference()) {
                codeAttr.emitInvokeVirtual(Compilation.getLocationMethod);
            } else if (declaration.isFluid()) {
                codeAttr.emitGetField(FluidLetExp.valueField);
            }
        } else {
            Field field = compilation.getBindingField(this.symbol);
            if (field.getStaticFlag()) {
                codeAttr.emitGetStatic(field);
            } else {
                LambdaExp lambdaExp = compilation.curLambda;
                while (!(lambdaExp instanceof ModuleExp)) {
                    lambdaExp = lambdaExp.outerLambda();
                }
                lambdaExp.loadHeapFrame(compilation);
                codeAttr.emitGetField(field);
            }
            if (!this.getDontDereference()) {
                if (!this.isProcedureName()) {
                    codeAttr.emitInvokeVirtual(Compilation.getLocationMethod);
                } else {
                    codeAttr.emitInvokeVirtual(Compilation.getProcedureBindingMethod);
                }
            }
        }
        target.compileFromStack(compilation, this.getType());
    }

    public Object eval(Environment environment) {
        if (this.binding != null && (!(this.binding.context instanceof ModuleExp) || this.binding.isPrivate())) {
            throw new Error("internal error: ReferenceExp.eval on lexical binding");
        }
        if (this.getDontDereference()) {
            return environment.getBinding(this.symbol);
        }
        if (this.getFlag(PREFER_BINDING2)) {
            Binding2 binding2 = Binding2.getBinding2(environment, this.symbol);
            return this.isProcedureName() ? ((Binding)binding2).getProcedure() : binding2.get();
        }
        return environment.getChecked(this.symbol);
    }

    public final Declaration getBinding() {
        return this.binding;
    }

    public final boolean getDontDereference() {
        return (this.flags & DONT_DEREFERENCE) != 0;
    }

    public final String getName() {
        return this.symbol;
    }

    public final Type getType() {
        return this.binding == null || this.binding.isFluid() ? Type.pointer_type : (this.getDontDereference() ? Compilation.typeLocation : this.binding.getType());
    }

    public final boolean isProcedureName() {
        return (this.flags & PROCEDURE_NAME) != 0;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(#%ref/");
        printWriter.print(this.id);
        printWriter.print("/ ");
        SFormat.print(this.symbol, printWriter);
        printWriter.print(")");
    }

    public final void setDontDereference(boolean bl) {
        this.setFlag(bl, DONT_DEREFERENCE);
    }

    public final void setProcedureName(boolean bl) {
        this.setFlag(bl, PROCEDURE_NAME);
    }

    public String string_name() {
        return this.symbol;
    }

    public String toString() {
        return "RefExp/" + this.symbol + '/' + this.id + '/';
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkReferenceExp(this);
    }
}

