/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.ScopeExp;
import gnu.text.SourceMessages;

public abstract class Parser {
    ScopeExp current_scope;
    protected String current_filename;
    protected int current_line;
    protected int current_column;
    protected SourceMessages messages;

    public Parser(SourceMessages sourceMessages) {
        this.messages = sourceMessages;
    }

    public LambdaExp currentLambda() {
        return this.current_scope.currentLambda();
    }

    public ScopeExp currentScope() {
        return this.current_scope;
    }

    public void error(char c, Declaration declaration, String string, String string2) {
        String string3 = this.current_filename;
        int n = this.current_line;
        int n2 = this.current_column;
        int n3 = declaration.getLine();
        if (n3 > 0) {
            string3 = declaration.getFile();
            n = n3;
            n2 = declaration.getColumn();
        }
        this.messages.error(c, string3, n, n2, String.valueOf(string) + declaration.getName() + string2);
    }

    public void error(char c, String string) {
        this.messages.error(c, this.current_filename, this.current_line, this.current_column, string);
    }

    public final int getColumn() {
        return this.current_column;
    }

    public final String getFile() {
        return this.current_filename;
    }

    public Interpreter getInterpreter() {
        return Interpreter.getInterpreter();
    }

    public final int getLine() {
        return this.current_line;
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    public void mustCompileHere() {
        LambdaExp lambdaExp = this.currentLambda();
        if (lambdaExp instanceof ModuleExp) {
            ((ModuleExp)lambdaExp).mustCompile = true;
        }
    }

    public abstract Expression parse(Object var1);

    void pop(Declaration declaration) {
        String string = declaration.getName();
        if (string == null) {
            return;
        }
        this.popBinding();
    }

    public void pop(ScopeExp scopeExp) {
        this.popDecls(scopeExp);
        this.current_scope = scopeExp.outer;
    }

    public abstract boolean popBinding();

    public final void popDecls(ScopeExp scopeExp) {
        Declaration declaration = scopeExp.firstDecl();
        while (declaration != null) {
            this.pop(declaration);
            declaration = declaration.nextDecl();
        }
    }

    public void push(Declaration declaration) {
        String string = declaration.getName();
        if (string == null) {
            return;
        }
        this.pushBinding(string, declaration);
    }

    public void push(ScopeExp scopeExp) {
        scopeExp.outer = this.current_scope;
        if (!(scopeExp instanceof ModuleExp)) {
            this.mustCompileHere();
        }
        this.current_scope = scopeExp;
        this.pushDecls(scopeExp);
    }

    public abstract void pushBinding(String var1, Object var2);

    public final void pushDecls(ScopeExp scopeExp) {
        Declaration declaration = scopeExp.firstDecl();
        while (declaration != null) {
            this.push(declaration);
            declaration = declaration.nextDecl();
        }
    }

    public void setColumn(int n) {
        this.current_column = n;
    }

    public void setFile(String string) {
        this.current_filename = string;
    }

    public void setLine(int n) {
        this.current_line = n;
    }

    public void setLine(String string, int n, int n2) {
        this.current_filename = string;
        this.current_line = n;
        this.current_column = n2;
    }

    public void setMessages(SourceMessages sourceMessages) {
        this.messages = sourceMessages;
    }
}

