
#include "JavaEnv.h"

@implementation JavaEnv

+ new {
  self = [JavaEnv alloc];
  fprintf(stderr, "creating... java env\n");
  [self init];
  return self;
}

- init {
    jint res;

#ifdef onepoint2
    /* IMPORTANT: specify vm_args version # if you use JDK1.1.2 and beyond */
    vm_args.version = 0x00010001;
#endif

    JNI_GetDefaultJavaVMInitArgs(&vm_args);
    fprintf(stderr, "initializing\n");

    res = JNI_CreateJavaVM(&jvm,&env,&vm_args);
    if (res < 0) {
        fprintf(stderr, "Can't create Java VM\n");
        exit(1);
    }

    return self;
}

- free {
  (*jvm)->DestroyJavaVM(jvm);
}

- (JNIEnv *)getEnv {
  return env;
}

- (jclass)findClass: (char *)class {
  jclass cls = (*env)->FindClass(env, class);
  if (cls == 0) {
    fprintf(stderr, "Can't find class %s\n", class);
    exit(1);
  }

  return cls;
}



@end

