
import java.awt.*;
import java.awt.event.*;

// JavaJMemCanvas: a canvas holding the image that needs to
// be redrawn every time we repaint

class JavaJMemCanvas extends Canvas 
{

  private int w;
  private int h;
  private Image i;
  private Graphics ig;		// image graphics context

  JavaJMemCanvas() {
    super();
    System.out.println("Mem:");

    w = getSize().width;
    h = getSize().height;

    if (w != 0 && h != 0) {
      // create a new cached image
      i = createImage(w, h);
      ig = i.getGraphics();
    } else {
      i = null;
    }
  }

  public void setSize(int w, int h) {
    if (w != this.w && h != this.h) {
      super.setSize(w, h);

      this.w = w; this.h = h;
      i = createImage(w, h);
      ig = i.getGraphics();
    }
  }

  public Graphics imageGraphics() {
    if (i == null) {
      setSize(getSize().width, getSize().height);
    }
    return ig;
  }

  public void update(Graphics g) {
    // since we're doing the whole bitmap, don't clear
    // the background
    paint(g);
  }

  public void paint(Graphics g) {

    if (g instanceof PrintGraphics) {
      System.out.println("PRINT! "+w+" "+h);
      return;
    }

    if (i != null) {
      g.drawImage(i, 0, 0, null);
    }
  }
    
}

