/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.xml.sax.SAXException;

public class DatabaseReader
extends ServiceableReader
implements Configurable,
Disposable,
CacheableProcessingComponent {
    private ServiceSelector dbselector;
    private String dsn;
    private long lastModified = System.currentTimeMillis();
    private InputStream resource = null;
    private Connection con = null;
    private DataSourceComponent datasource = null;
    private String mimeType = null;
    private int typeColumn = 0;
    private boolean doCommit = false;
    private boolean defaultCache = true;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.dbselector = (ServiceSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.dsn = conf.getChild("use-connection").getValue();
        this.defaultCache = conf.getChild("invalidate").getValue("never").equals("always");
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.datasource = (DataSourceComponent)this.dbselector.select((Object)this.dsn);
            this.con = this.datasource.getConnection();
            if (this.con.getAutoCommit()) {
                this.con.setAutoCommit(false);
            }
            PreparedStatement statement = this.con.prepareStatement(this.getQuery());
            statement.setString(1, this.source);
            ResultSet set = statement.executeQuery();
            if (!set.next()) {
                throw new ResourceNotFoundException("There is no resource with that key");
            }
            Response response = ObjectModelHelper.getResponse((Map)objectModel);
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            if (this.modifiedSince(set, request, response)) {
                this.resource = set.getBinaryStream(1);
                if (this.typeColumn != 0) {
                    this.mimeType = set.getString(this.typeColumn);
                }
                if (this.resource == null) {
                    throw new ResourceNotFoundException("There is no resource with that key");
                }
            }
            this.doCommit = true;
        }
        catch (Exception e) {
            this.doCommit = false;
            throw new ResourceNotFoundException("DatabaseReader error:", (Throwable)e);
        }
    }

    public void generate() throws ProcessingException, SAXException, IOException {
        try {
            Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
            this.serialize(response);
        }
        catch (IOException ioe) {
            this.getLogger().warn("Assuming client reset stream");
            this.doCommit = false;
        }
        catch (Exception e) {
            this.doCommit = false;
            throw new ResourceNotFoundException("DatabaseReader error:", (Throwable)e);
        }
    }

    public String getQuery() throws Exception {
        String table = this.parameters.getParameter("table", null);
        String column = this.parameters.getParameter("image", null);
        String key = this.parameters.getParameter("key", null);
        String where = this.parameters.getParameter("where", null);
        String orderBy = this.parameters.getParameter("order-by", null);
        String typeColumn = this.parameters.getParameter("type-column", null);
        int columnNo = 1;
        if (table == null || column == null || key == null) {
            throw new ProcessingException("We are missing a required parameter.  Please include 'table', 'image', and 'key'");
        }
        String date = this.parameters.getParameter("last-modified", null);
        StringBuffer query = new StringBuffer("SELECT ");
        query.append(column);
        ++columnNo;
        if (date != null) {
            query.append(", ").append(date);
            ++columnNo;
        }
        if (null != orderBy) {
            query.append(", ");
            if (orderBy.endsWith(" DESC")) {
                query.append(orderBy.substring(0, orderBy.length() - 5));
            } else {
                query.append(orderBy);
            }
            ++columnNo;
        }
        if (null != typeColumn) {
            query.append(", ").append(typeColumn);
            this.typeColumn = columnNo++;
        }
        query.append(" FROM ").append(table);
        query.append(" WHERE ").append(key).append(" = ?");
        if (null != where) {
            query.append(" AND ").append(where);
        }
        if (null != orderBy) {
            query.append(" ORDER BY ").append(orderBy);
        }
        return query.toString();
    }

    public boolean modifiedSince(ResultSet set, Request request, Response response) throws SQLException {
        String lastModified = this.parameters.getParameter("last-modified", null);
        if (lastModified != null) {
            Timestamp modified = set.getTimestamp(lastModified, null);
            if (null != modified) {
                this.lastModified = modified.getTime();
            }
            response.setDateHeader("Last-Modified", this.lastModified);
            return this.lastModified > request.getDateHeader("if-modified-since");
        }
        return true;
    }

    public void serialize(Response response) throws IOException, SQLException {
        if (this.resource == null) {
            throw new SQLException("The Blob is empty!");
        }
        BufferedInputStream is = new BufferedInputStream(this.resource);
        long expires = this.parameters.getParameterAsInteger("expires", -1);
        if (expires > 0L) {
            response.setDateHeader("Expires", System.currentTimeMillis() + expires);
        }
        response.setHeader("Accept-Ranges", "bytes");
        byte[] buffer = new byte[8192];
        int length = -1;
        while ((length = ((InputStream)is).read(buffer)) > -1) {
            this.out.write(buffer, 0, length);
        }
        ((InputStream)is).close();
        this.out.flush();
    }

    public Serializable getKey() {
        return this.source;
    }

    public SourceValidity getValidity() {
        if (this.lastModified > 0L) {
            return new TimeStampValidity(this.lastModified);
        }
        if (this.defaultCache) {
            return NOPValidity.SHARED_INSTANCE;
        }
        return null;
    }

    public void recycle() {
        super.recycle();
        this.resource = null;
        this.lastModified = 0L;
        this.mimeType = null;
        this.typeColumn = 0;
        if (this.con != null) {
            try {
                if (this.doCommit) {
                    this.con.commit();
                } else {
                    this.con.rollback();
                }
            }
            catch (SQLException se) {
                this.getLogger().warn("Could not commit or rollback connection", (Throwable)se);
            }
            try {
                this.con.close();
            }
            catch (SQLException se) {
                this.getLogger().warn("Could not close connection", (Throwable)se);
            }
            this.con = null;
        }
        if (this.datasource != null) {
            this.dbselector.release((Object)this.datasource);
            this.datasource = null;
        }
    }

    public void dispose() {
        this.manager.release((Object)this.dbselector);
    }

    public String getMimeType() {
        return this.mimeType != null ? this.mimeType : this.parameters.getParameter("content-type", super.getMimeType());
    }
}

