/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.SortElementBuilder;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.eclipse.jdt.internal.core.util.Util;

public class SortElementsOperation
extends JavaModelOperation {
    Comparator comparator;
    int[] positions;

    public SortElementsOperation(IJavaElement[] elements, int[] positions, Comparator comparator) {
        super(elements);
        this.comparator = comparator;
        this.positions = positions;
    }

    protected int getMainAmountOfWork() {
        return this.elementsToProcess.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block6: {
            block5: {
                try {
                    this.beginTask(Util.bind("operation.sortelements"), this.getMainAmountOfWork());
                    CompilationUnit copy = (CompilationUnit)this.elementsToProcess[0];
                    ICompilationUnit unit = copy.getPrimary();
                    IBuffer buffer = copy.getBuffer();
                    if (buffer == null) {
                        Object var6_4 = null;
                        break block5;
                    }
                    char[] bufferContents = buffer.getCharacters();
                    String result = this.processElement(unit, this.positions, bufferContents);
                    if (!CharOperation.equals(result.toCharArray(), bufferContents)) {
                        copy.getBuffer().setContents(result);
                    }
                    this.worked(1);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.done();
                    throw throwable;
                }
            }
            this.done();
            return;
        }
        Object var6_6 = null;
        this.done();
    }

    private String processElement(ICompilationUnit unit, int[] positionsToMap, char[] source) {
        SortElementBuilder builder = new SortElementBuilder(source, positionsToMap, this.comparator);
        SourceElementParser parser = new SourceElementParser(builder, ProblemFactory.getProblemFactory(Locale.getDefault()), new CompilerOptions(JavaCore.getOptions()), true);
        if (unit.exists()) {
            IPackageFragment packageFragment = (IPackageFragment)unit.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
            }
            parser.parseCompilationUnit(new BasicCompilationUnit(source, expectedPackageName, unit.getElementName(), unit), false);
        } else {
            parser.parseCompilationUnit(new BasicCompilationUnit(source, null, "", unit.getJavaProject()), false);
        }
        return builder.getSource();
    }

    public IJavaModelStatus verify() {
        if (this.elementsToProcess.length != 1) {
            return new JavaModelStatus(968);
        }
        if (this.elementsToProcess[0] == null) {
            return new JavaModelStatus(968);
        }
        if (!(this.elementsToProcess[0] instanceof ICompilationUnit) || !((ICompilationUnit)this.elementsToProcess[0]).isWorkingCopy()) {
            return new JavaModelStatus(967, this.elementsToProcess[0]);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

