/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.transcoder;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.cocoon.components.transcoder.TranscoderFactory;

public class ExtendableTranscoderFactory
implements TranscoderFactory {
    protected static final Map transcoders = new HashMap();
    protected static final TranscoderFactory singleton = new ExtendableTranscoderFactory();

    private ExtendableTranscoderFactory() {
        this.addTranscoder("image/jpeg", JPEGTranscoder.class);
        this.addTranscoder("image/jpg", JPEGTranscoder.class);
        this.addTranscoder("image/png", PNGTranscoder.class);
        this.addTranscoder("image/tiff", TIFFTranscoder.class);
    }

    public static final TranscoderFactory getTranscoderFactoryImplementation() {
        return singleton;
    }

    public Transcoder createTranscoder(String mimeType) {
        Class transcoderClass = (Class)transcoders.get(mimeType);
        if (transcoderClass == null) {
            return null;
        }
        try {
            return (Transcoder)transcoderClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void addTranscoder(String mimeType, Class transcoderClass) {
        transcoders.put(mimeType, transcoderClass);
    }

    public void removeTranscoder(String mimeType) {
        transcoders.remove(mimeType);
    }
}

