/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.filter.Filter;
import fr.gouv.culture.sdx.search.lucene.query.AbstractQuery;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Vector;
import org.apache.lucene.search.BooleanQuery;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ComplexQuery
extends AbstractQuery {
    private Vector components = new Vector();
    private int operator;
    private float boost = 1.0f;

    public void setBoost(float boost) {
        if (boost >= 0.0f) {
            this.boost = boost;
            for (int i = 0; i < this.components.size(); ++i) {
                ((Query)this.components.get(i)).setBoost(((Query)this.components.get(i)).getBoost() * boost);
            }
        }
    }

    public float getBoost() {
        return this.boost;
    }

    public void setUp(SearchLocations sLocs, int operator) throws SDXException {
        super.setSearchLocations(sLocs);
        switch (operator) {
            case 0: 
            case 1: 
            case 2: {
                this.operator = operator;
                break;
            }
            default: {
                this.operator = 1;
            }
        }
    }

    public Filter prepare() {
        if (this.components != null && this.components.size() > 0) {
            this.luceneQuery = Utilities.newBooleanQuery();
            block14: for (int i = 0; i < this.components.size(); ++i) {
                org.apache.lucene.search.Query componentQuery;
                Query q = (Query)this.components.get(i);
                Filter f = q.prepare();
                if (f != null) {
                    switch (this.operator) {
                        case 1: {
                            if (this.filter == null) {
                                this.filter = new Filter(1);
                            }
                            this.filter.add(f);
                            break;
                        }
                        case 0: {
                            if (this.filter == null) {
                                this.filter = new Filter(0);
                            }
                            this.filter.add(f);
                            break;
                        }
                        case 2: {
                            if (this.filter == null) {
                                this.filter = new Filter(2);
                            }
                            this.filter.add(f);
                        }
                    }
                }
                if ((componentQuery = q.getLuceneQuery()) == null) continue;
                switch (this.operator) {
                    case 1: {
                        ((BooleanQuery)this.luceneQuery).add(q.getLuceneQuery(), true, false);
                        continue block14;
                    }
                    case 0: {
                        ((BooleanQuery)this.luceneQuery).add(q.getLuceneQuery(), false, false);
                        continue block14;
                    }
                    case 2: {
                        if (i == 0) {
                            ((BooleanQuery)this.luceneQuery).add(q.getLuceneQuery(), true, false);
                            continue block14;
                        }
                        ((BooleanQuery)this.luceneQuery).add(q.getLuceneQuery(), false, true);
                    }
                }
            }
            if (this.baseQuery != null) {
                BooleanQuery newQuery = Utilities.newBooleanQuery();
                switch (this.baseOperator) {
                    case 0: {
                        newQuery.add(this.luceneQuery, false, false);
                        newQuery.add(this.baseQuery.getLuceneQuery(), false, false);
                        break;
                    }
                    case 2: {
                        newQuery.add(this.luceneQuery, false, true);
                        newQuery.add(this.baseQuery.getLuceneQuery(), true, false);
                        break;
                    }
                    default: {
                        this.baseOperator = 1;
                        newQuery.add(this.luceneQuery, true, false);
                        newQuery.add(this.baseQuery.getLuceneQuery(), true, false);
                    }
                }
                this.luceneQuery = newQuery;
            }
        }
        return this.filter;
    }

    public void addComponent(Query component) {
        if (component != null) {
            this.components.add(component);
        }
    }

    public int size() {
        return this.components.size();
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "query";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "complex");
        atts = super.addAttributesLucene(atts);
        switch (this.operator) {
            case 1: {
                atts.addAttribute("", "operator", "operator", "CDATA", "and");
                break;
            }
            case 0: {
                atts.addAttribute("", "operator", "operator", "CDATA", "or");
                break;
            }
            case 2: {
                atts.addAttribute("", "operator", "operator", "CDATA", "not");
            }
        }
        hdl.startElement(sdxNsUri, localName, qName, atts);
        if (this.getSearchLocations() != null) {
            this.getSearchLocations().toSAX(hdl);
        }
        if (this.filter != null) {
            this.filter.toSAX(hdl);
        }
        if (this.baseQuery != null) {
            String bqLocalName = "baseQuery";
            String bqQName = sdxNsPrefix + ":" + bqLocalName;
            AttributesImpl emptyAtts = new AttributesImpl();
            hdl.startElement(sdxNsUri, bqLocalName, bqQName, emptyAtts);
            this.baseQuery.toSAX(hdl);
            hdl.endElement(sdxNsUri, bqLocalName, bqQName);
        }
        for (int i = 0; i < this.components.size(); ++i) {
            Query q = (Query)this.components.get(i);
            q.toSAX(hdl);
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }

    protected Query removeLastComponent() {
        int lastIndex = this.components.size() - 1;
        if (lastIndex < 0) {
            return null;
        }
        return (Query)this.components.remove(lastIndex);
    }
}

