/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ant;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DelayedFileOutputStream
extends OutputStream {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private OutputStream fos = null;

    public void setFileOutputStream(File file) throws FileNotFoundException {
        if (this.fos == null) {
            this.fos = new FileOutputStream(file);
        }
    }

    public void setFileOutputStream(File file, boolean append) throws IOException {
        if (this.fos == null) {
            this.fos = new FileOutputStream(file.getCanonicalPath(), append);
        }
    }

    public void setFileOutputStream(FileDescriptor fdObj) {
        if (this.fos == null) {
            this.fos = new BufferedOutputStream(new FileOutputStream(fdObj));
        }
    }

    public void setFileOutputStream(String name) throws FileNotFoundException {
        if (this.fos == null) {
            this.fos = new FileOutputStream(name);
        }
    }

    public void setFileOutputStream(String name, boolean append) throws FileNotFoundException {
        if (this.fos == null) {
            this.fos = new FileOutputStream(name, append);
        }
    }

    public void write(int b) throws IOException {
        OutputStream os = this.getTargetOutputStream();
        os.write(b);
    }

    public void write(byte[] b) throws IOException {
        OutputStream os = this.getTargetOutputStream();
        os.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        OutputStream os = this.getTargetOutputStream();
        os.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IOException ioexception = null;
        this.getTargetOutputStream();
        try {
            block11: {
                try {
                    if (this.baos == null) break block11;
                    this.baos.close();
                }
                catch (IOException ioe) {
                    if (ioexception == null) {
                        ioexception = ioe;
                    }
                    Object var4_3 = null;
                    this.baos = null;
                }
            }
            Object var4_2 = null;
            this.baos = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.baos = null;
            throw throwable;
        }
        try {
            block13: {
                try {
                    if (this.fos == null) break block13;
                    this.fos.close();
                }
                catch (IOException ioe) {
                    if (ioexception == null) {
                        ioexception = ioe;
                    }
                    Object var6_9 = null;
                    this.fos = null;
                }
            }
            Object var6_8 = null;
            this.fos = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.fos = null;
            throw throwable;
        }
        if (ioexception != null) {
            throw ioexception;
        }
    }

    public void flush() throws IOException {
        IOException ioexception;
        block8: {
            block7: {
                ioexception = null;
                this.getTargetOutputStream();
                try {
                    if (this.baos != null) {
                        this.baos.flush();
                    }
                }
                catch (IOException ioe) {
                    if (ioexception != null) break block7;
                    ioexception = ioe;
                }
            }
            try {
                if (this.fos != null) {
                    this.fos.flush();
                }
            }
            catch (IOException ioe) {
                if (ioexception != null) break block8;
                ioexception = ioe;
            }
        }
        if (ioexception != null) {
            throw ioexception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getTargetOutputStream() throws IOException {
        if (this.baos != null && this.fos == null) {
            return this.baos;
        }
        if (this.baos != null && this.fos != null) {
            IOException ioexception = null;
            try {
                try {
                    this.baos.flush();
                    this.baos.writeTo(this.fos);
                    this.baos.close();
                }
                catch (IOException ioe) {
                    ioexception = ioe;
                    Object var4_3 = null;
                    this.baos = null;
                }
                Object var4_2 = null;
                this.baos = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.baos = null;
                throw throwable;
            }
            if (ioexception != null) {
                throw ioexception;
            }
            return this.fos;
        }
        if (this.baos == null && this.fos != null) {
            return this.fos;
        }
        throw new IOException("No outputstream available!");
    }
}

