/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.user;

import java.io.Serializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.webapps.authentication.configuration.ApplicationConfiguration;
import org.apache.cocoon.webapps.authentication.user.UserHandler;
import org.apache.excalibur.source.SourceResolver;

public final class RequestState
implements Serializable {
    private UserHandler handler;
    private String application;

    public RequestState(UserHandler handler, String app) {
        this.handler = handler;
        this.application = app;
    }

    public void initialize(SourceResolver resolver) throws ProcessingException {
        ApplicationConfiguration conf;
        if (this.application != null && !this.handler.getApplicationsLoaded() && !this.handler.isApplicationLoaded(conf = (ApplicationConfiguration)this.handler.getHandlerConfiguration().getApplications().get(this.application))) {
            this.handler.getContext().loadApplicationXML(conf, resolver);
        }
    }

    public String getApplicationName() {
        return this.application;
    }

    public UserHandler getHandler() {
        return this.handler;
    }

    public String getHandlerName() {
        return this.handler.getHandlerName();
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        if (this.application != null) {
            return (ApplicationConfiguration)this.handler.getHandlerConfiguration().getApplications().get(this.application);
        }
        return null;
    }

    public Configuration getModuleConfiguration(String name) {
        Configuration conf = null;
        if (this.handler != null && this.application != null) {
            conf = this.getApplicationConfiguration().getConfiguration(name);
        }
        if (this.handler != null && conf == null) {
            conf = this.handler.getHandlerConfiguration().getConfiguration(name);
        }
        return conf;
    }
}

