/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 8 oct. 2002
 * Time: 13:19:53
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.utils.Utilities;

public class SimpleIDGenerator extends AbstractIDGenerator {

    long currentId = 0;

    /**Generates an idea appending the given strings
     * to an incremented long class field beginning from
     * zero.
     *
     * @param prefix    The prefix for the generated id
     * @param suffix    The suffix for the generated id
     * */
    public String generate(String prefix, String suffix) {
        String id = "";

        id = Long.toString(currentId);
        currentId++;

        if (Utilities.checkString(prefix))
            id = prefix + id;

        if (Utilities.checkString(suffix))
            id = id + suffix;

        if (!isIdUnique(id))
            return generate(prefix, suffix); //a recursive call will loop until a unique id is generated

        return id;
    }


}
