/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.oai;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.SAXException;

/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: May 8, 2003
 * Time: 3:05:07 PM
 * To change this template use Options | File Templates.
 */

/**Basic interface for an OAI metadata format
 *
 */
public interface OAIMetadataFormat extends OAIObject, Configurable {

    /**Gets the name of the oai format used in the ListMetadataFormats response*/
    String getName();

    /**Sets the name of the oai format used in the ListMetadataFormats response*/
    void setName(String formatName);

    /**Gets the name of the oai format metadataPrefix*/
    String getPrefix();

    /**Sets the name of the oai format metadataPrefix*/
    void setPrefix(String prefix);

    /**Gets the url of the schemaLocation for the metadata format*/
    String getSchemaUrl();

    /**Sets the url of the schemaLocation for the metadata format*/
    void setSchemaUrl(String schemaUrl);

    /**Gets the namespace for the metadata format*/
    String getNamespace();

    /**Sets the namespace for the metadata format*/
    void setNamespace(String namespace);

    /**Sends the startElement event of the root element (ie. oai:dc or 'prefix') of the metadata format */
    void startMetadataFormatRootElement() throws SAXException;

    /**Sends the endElement event of the root element (ie. oai:dc or 'prefix') of the metadata format */
    void endMetadataFormatRootElement() throws SAXException;

    /**Gets the parameters object containing mappings of elements to metadata format elements*/
    Parameters getMappings();

    /**Sets the parameters object containing mappings of elements to metadata format elements*/
    void setMappings(Parameters mappings);

    /**Sends an element to the consumer doing any necessary transformations using mappings*/
    void sendElement(String origName, String value) throws SAXException;


}
