/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xmlizer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.excalibur.xmlizer.impl.AbstractXMLizer;
import org.w3c.tidy.Tidy;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class HTMLXMLizer
extends AbstractXMLizer {
    private static final String HTML_MIME_TYPE = "text/html";
    private static final Properties c_format = HTMLXMLizer.createFormatProperties();

    public HTMLXMLizer() {
        super(HTML_MIME_TYPE);
    }

    protected void toSAX(InputStream stream, String systemID, ContentHandler handler) throws SAXException, IOException {
        Tidy xhtmlconvert = new Tidy();
        xhtmlconvert.setXmlOut(true);
        xhtmlconvert.setXHTML(true);
        xhtmlconvert.setShowWarnings(false);
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperties(c_format);
            DOMSource domSource = new DOMSource(xhtmlconvert.parseDOM(stream, null));
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException te) {
            String message = "Exception during transformation.";
            throw new SAXException("Exception during transformation.", te);
        }
        InputSource inputSource = new InputSource(new StringReader(writer.toString()));
        if (null != systemID) {
            inputSource.setSystemId(systemID);
        }
        this.getParser().parse(inputSource, handler);
    }

    private static Properties createFormatProperties() {
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("omit-xml-declaration", "no");
        format.put("indent", "yes");
        return format;
    }
}

