/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.EndConnectionReply;
import org.apache.excalibur.altrmi.server.AltrmiServerConnection;
import org.apache.excalibur.altrmi.server.impl.AbstractServer;
import org.apache.excalibur.altrmi.server.impl.ServerStreamReadWriter;

public abstract class StreamServerConnection
implements Runnable,
AltrmiServerConnection,
LogEnabled {
    private AbstractServer mAbstractServer;
    private boolean mEndConnection = false;
    private ServerStreamReadWriter mReadWriter;
    private Logger mLogger;

    public StreamServerConnection(AbstractServer abstractServer, ServerStreamReadWriter readWriter) {
        this.mAbstractServer = abstractServer;
        this.mReadWriter = readWriter;
    }

    public void enableLogging(Logger logger) {
        this.mLogger = logger;
    }

    public void run() {
        this.mAbstractServer.connectionStart(this);
        try {
            this.mReadWriter.initialize();
            boolean more = true;
            AltrmiRequest request = null;
            AltrmiReply reply = null;
            while (more) {
                try {
                    if (request != null) {
                        reply = this.mAbstractServer.handleInvocation(request);
                    }
                    request = this.mReadWriter.writeReplyAndGetRequest(reply);
                    if (!this.mEndConnection) continue;
                    reply = new EndConnectionReply();
                    more = false;
                }
                catch (IOException ioe) {
                    more = false;
                    if (ioe instanceof EOFException) {
                        this.mLogger.info("One Connection closed. (EOF)");
                        continue;
                    }
                    if (ioe instanceof SocketException || ioe.getClass().getName().equals("java.net.SocketTimeoutException") || ioe instanceof InterruptedIOException || ioe.getMessage() != null && (ioe.getMessage().equals("Write end dead") || ioe.getMessage().equals("Pipe broken"))) {
                        this.mLogger.info("One Connection closed.");
                        continue;
                    }
                    this.mLogger.error("Unexpected IOE in StreamServerConnection #1", (Throwable)ioe);
                }
            }
        }
        catch (IOException e) {
            this.mLogger.error("Unexpected IOE in StreamServerConnection #2", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.mLogger.error("Unexpected ClassNotFoundException in StreamServerConnection", (Throwable)e);
        }
        this.mAbstractServer.connectionCompleted(this);
    }

    public void endConnection() {
        this.mEndConnection = true;
        this.mReadWriter.close();
    }

    protected abstract void killConnection();
}

