/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.util.Locale;
import java.util.StringTokenizer;

public class I18nUtils {
    private static final String LOCALE_DELIMITER = "_";

    public static Locale parseLocale(String localeString, Locale defaultLocale) {
        if (localeString != null) {
            StringTokenizer st = new StringTokenizer(localeString, LOCALE_DELIMITER);
            String l = st.hasMoreElements() ? st.nextToken() : defaultLocale.getLanguage();
            String c = st.hasMoreElements() ? st.nextToken() : "";
            String v = st.hasMoreElements() ? st.nextToken() : "";
            return new Locale(l, c, v);
        }
        return defaultLocale;
    }

    public static Locale parseLocale(String localeString) {
        return I18nUtils.parseLocale(localeString, Locale.getDefault());
    }

    private I18nUtils() {
    }
}

