/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.gjt.mm.mysql.xa.ClientConnection;
import org.gjt.mm.mysql.xa.TwoPhaseConnection;
import org.gjt.mm.mysql.xa.TxConnection;
import org.gjt.mm.mysql.xa.XADataSourceImpl;

public final class XAConnectionImpl
implements XAConnection,
XAResource {
    Connection _underlying;
    private TxConnection _txConn;
    private ConnectionEventListener _listener;
    private XADataSourceImpl _resManager;
    private int _clientId = 1;
    private String _userName;
    private String _password;

    XAConnectionImpl(XADataSourceImpl xADataSourceImpl, Connection connection, String string, String string2) {
        this._underlying = connection;
        this._resManager = xADataSourceImpl;
        this._userName = string;
        this._password = string2;
    }

    public synchronized void close() throws SQLException {
        if (this._resManager == null) {
            throw new SQLException("This connection has been closed");
        }
        this._clientId = -1;
        try {
            if (this._underlying != null) {
                this._underlying.commit();
                this._underlying.close();
            } else if (this._txConn != null) {
                try {
                    this.end(this._txConn.xid, 0x4000000);
                }
                catch (XAException xAException) {
                }
            }
            Object var3_2 = null;
            this._resManager = null;
            this._underlying = null;
            this._txConn = null;
            this._listener = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._resManager = null;
            this._underlying = null;
            this._txConn = null;
            this._listener = null;
            throw throwable;
        }
    }

    public XAResource getXAResource() {
        return this;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            throw new NullPointerException("XAConnection: Argument 'listener' is null");
        }
        if (this._listener != null) {
            throw new IllegalStateException("XAConnection: Only one listener supported per connection");
        }
        this._listener = connectionEventListener;
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            throw new NullPointerException("XAConnection: Argument 'listener' is null");
        }
        if (this._listener == null || this._listener != connectionEventListener) {
            throw new IllegalStateException("XAConnection: Listener never registered with this pooled connection");
        }
        this._listener = null;
    }

    public synchronized Connection getConnection() throws SQLException {
        block4: {
            if (this._resManager == null) {
                throw new SQLException("This connection has been closed");
            }
            if (this._underlying != null) {
                try {
                    this._underlying.commit();
                }
                catch (SQLException sQLException) {
                    if (this._listener == null) break block4;
                    ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
                    this._listener.connectionErrorOccurred(connectionEvent);
                }
            }
        }
        return new ClientConnection(this, ++this._clientId);
    }

    synchronized void notifyClose(int n) {
        if (n != this._clientId) {
            return;
        }
        if (this._underlying != null) {
            try {
                this._underlying.commit();
            }
            catch (SQLException sQLException) {
                if (this._listener != null) {
                    ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
                    this._listener.connectionErrorOccurred(connectionEvent);
                }
                return;
            }
        }
        if (this._listener != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            this._listener.connectionClosed(connectionEvent);
        }
    }

    synchronized void notifyError(int n, SQLException sQLException) {
        if (n != this._clientId) {
            return;
        }
        if (this._underlying != null) {
            if (!(this._underlying instanceof TwoPhaseConnection) || !((TwoPhaseConnection)((Object)this._underlying)).isCriticalError(sQLException)) {
                return;
            }
            if (this._txConn.conn == null || !(this._txConn.conn instanceof TwoPhaseConnection) || !((TwoPhaseConnection)((Object)this._txConn.conn)).isCriticalError(sQLException)) {
                return;
            }
        }
        ++this._clientId;
        if (this._underlying != null) {
            try {
                this._underlying.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            this._underlying = null;
        } else if (this._txConn != null) {
            try {
                this.end(this._txConn.xid, 0x20000000);
            }
            catch (XAException xAException) {
                // empty catch block
            }
            this._txConn = null;
        }
        if (this._listener != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            this._listener.connectionErrorOccurred(connectionEvent);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String toString() {
        if (this._underlying != null) {
            return "XAConnection: " + this._underlying;
        }
        return "XAConnection: unused";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void start(Xid xid, int n) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        if (this._txConn != null) {
            throw new XAException(-9);
        }
        XADataSourceImpl xADataSourceImpl = this._resManager;
        synchronized (xADataSourceImpl) {
            if (n == 0) {
                if (this._resManager.getTxConnection(xid) != null) {
                    throw new XAException(-8);
                }
                try {
                    this._txConn = new TxConnection(this._userName, this._password);
                    if (this._underlying != null) {
                        this._txConn.conn = this._underlying;
                        this._underlying = null;
                    } else {
                        this._txConn.conn = this._resManager.newConnection(this._userName, this._password);
                    }
                    this._txConn.xid = xid;
                    this._txConn.count = 1;
                    this._txConn.started = System.currentTimeMillis();
                    this._txConn.timeout = this._txConn.started + (long)(this._resManager.getTransactionTimeout() * 1000);
                    this._resManager.setTxConnection(xid, this._txConn);
                }
                catch (SQLException sQLException) {
                    if (this._resManager.getLogWriter() == null) throw new XAException(-3);
                    this._resManager.getLogWriter().println("XAConnection: failed to begin a transaction: " + sQLException);
                    throw new XAException(-3);
                }
                try {
                    this._txConn.conn.setAutoCommit(false);
                    try {
                        if (this._resManager.isolationLevel() != 0) {
                            this._txConn.conn.setTransactionIsolation(this._resManager.isolationLevel());
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (!(this._txConn.conn instanceof TwoPhaseConnection)) return;
                    ((TwoPhaseConnection)((Object)this._txConn.conn)).enableSQLTransactions(false);
                }
                catch (SQLException sQLException) {
                    if (this._resManager.getLogWriter() == null) throw new XAException(-3);
                    this._resManager.getLogWriter().println("XAConnection: failed to begin a transaction: " + sQLException);
                    throw new XAException(-3);
                }
            }
            if (n != 0x200000 && n != 0x8000000) throw new XAException(-5);
            this._txConn = this._resManager.getTxConnection(xid);
            if (this._txConn == null) {
                throw new XAException(-5);
            }
            if (n == 0x200000 && this._txConn.count == 0) {
                throw new XAException(-6);
            }
            ++this._txConn.count;
            if (this._underlying == null) return;
            this.releaseConnection(this._underlying);
            this._underlying = null;
            return;
        }
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        if (this._txConn == null && n == 0x2000000) {
            throw new XAException(-4);
        }
        XADataSourceImpl xADataSourceImpl = this._resManager;
        synchronized (xADataSourceImpl) {
            if (n == 0x4000000 || n == 0x20000000) {
                if (this._txConn == null) {
                    this._txConn = this._resManager.getTxConnection(xid);
                    if (this._txConn == null) {
                        throw new XAException(-4);
                    }
                } else {
                    if (this._txConn.xid != null && !this._txConn.xid.equals(xid)) {
                        throw new XAException(-4);
                    }
                    --this._txConn.count;
                }
                if (n == 0x20000000 && this._txConn.conn != null) {
                    try {
                        if (this._txConn.conn instanceof TwoPhaseConnection) {
                            ((TwoPhaseConnection)((Object)this._txConn.conn)).enableSQLTransactions(true);
                        }
                        this._txConn.conn.rollback();
                        this.releaseConnection(this._txConn.conn);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this._resManager.setTxConnection(this._txConn.xid, null);
                    this._txConn.conn = null;
                    this._txConn.xid = null;
                }
                if (n == 0x4000000) {
                    this._txConn = null;
                }
            } else if (n == 0x2000000) {
                --this._txConn.count;
                this._txConn = null;
            } else {
                throw new XAException(-5);
            }
        }
    }

    public synchronized void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        XADataSourceImpl xADataSourceImpl = this._resManager;
        synchronized (xADataSourceImpl) {
            TxConnection txConnection = this._resManager.setTxConnection(xid, null);
            if (this._txConn == txConnection) {
                this._txConn = null;
            }
            if (txConnection != null) {
                if (txConnection.conn != null) {
                    this.releaseConnection(txConnection.conn);
                    txConnection.conn = null;
                }
                txConnection.xid = null;
            }
        }
    }

    public synchronized int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        XADataSourceImpl xADataSourceImpl = this._resManager;
        synchronized (xADataSourceImpl) {
            TxConnection txConnection = this._resManager.getTxConnection(xid);
            if (txConnection == null) {
                throw new XAException(-4);
            }
            if (txConnection.count > 0) {
                throw new XAException(-6);
            }
            if (txConnection.timedOut) {
                throw new XAException(106);
            }
            if (txConnection.conn == null) {
                throw new XAException(100);
            }
            try {
                txConnection.prepared = true;
                if (txConnection.conn instanceof TwoPhaseConnection) {
                    try {
                        if (((TwoPhaseConnection)((Object)txConnection.conn)).prepare()) {
                            int n = 0;
                            return n;
                        }
                        txConnection.readOnly = true;
                        int n = 3;
                        return n;
                    }
                    catch (SQLException sQLException) {
                        throw new XAException(100);
                    }
                }
                if (txConnection.conn.isReadOnly()) {
                    txConnection.readOnly = true;
                    int n = 3;
                    return n;
                }
                int n = 0;
                return n;
            }
            catch (SQLException sQLException) {
                try {
                    txConnection.conn.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                txConnection.conn = null;
                if (this._resManager.getLogWriter() != null) {
                    this._resManager.getLogWriter().println("XAConnection: failed to commit a transaction: " + sQLException);
                }
                throw new XAException(100);
            }
        }
    }

    public Xid[] recover(int n) throws XAException {
        XADataSourceImpl xADataSourceImpl = this._resManager;
        synchronized (xADataSourceImpl) {
            Xid[] xidArray = this._resManager.getTxRecover();
            return xidArray;
        }
    }

    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        XADataSourceImpl xADataSourceImpl = this._resManager;
        synchronized (xADataSourceImpl) {
            TxConnection txConnection = this._resManager.getTxConnection(xid);
            if (txConnection == null) {
                throw new XAException(-4);
            }
            if (txConnection.conn == null) {
                throw new XAException(100);
            }
            if (txConnection.readOnly) {
                return;
            }
            if (bl || txConnection.prepared) {
                try {
                    txConnection.readOnly = true;
                    if (txConnection.conn instanceof TwoPhaseConnection) {
                        ((TwoPhaseConnection)((Object)txConnection.conn)).enableSQLTransactions(true);
                    }
                    txConnection.conn.commit();
                }
                catch (SQLException sQLException) {
                    try {
                        txConnection.conn.close();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    txConnection.conn = null;
                    if (this._resManager.getLogWriter() != null) {
                        this._resManager.getLogWriter().println("XAConnection: failed to commit a transaction: " + sQLException);
                    }
                    throw new XAException(6);
                }
            }
            if (!txConnection.prepared) {
                throw new XAException(-6);
            }
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        XADataSourceImpl xADataSourceImpl = this._resManager;
        synchronized (xADataSourceImpl) {
            TxConnection txConnection = this._resManager.getTxConnection(xid);
            if (txConnection == null) {
                throw new XAException(-4);
            }
            if (txConnection.readOnly || txConnection.conn == null) {
                return;
            }
            try {
                try {
                    txConnection.prepared = false;
                    if (txConnection.conn instanceof TwoPhaseConnection) {
                        ((TwoPhaseConnection)((Object)txConnection.conn)).enableSQLTransactions(true);
                    }
                    txConnection.conn.rollback();
                }
                catch (SQLException sQLException) {
                    try {
                        txConnection.conn.close();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    txConnection.conn = null;
                    if (this._resManager.getLogWriter() != null) {
                        this._resManager.getLogWriter().println("XAConnection: failed to rollback a transaction: " + sQLException);
                    }
                    throw new XAException(100);
                }
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                this.forget(xid);
                throw throwable;
            }
            this.forget(xid);
        }
    }

    public synchronized boolean isSameRM(XAResource xAResource) throws XAException {
        if (xAResource == null || !(xAResource instanceof XAConnectionImpl)) {
            return false;
        }
        return this._resManager.equals(((XAConnectionImpl)xAResource)._resManager);
    }

    public synchronized boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        if (n == 0) {
            n = this._resManager.getTransactionTimeout();
        }
        if (this._txConn != null) {
            this._txConn.timeout = this._txConn.started + (long)(n * 1000);
            return true;
        }
        return false;
    }

    public int getTransactionTimeout() {
        if (this._txConn == null) {
            return 0;
        }
        return (int)(this._txConn.timeout - this._txConn.started) / 1000;
    }

    boolean insideGlobalTx() {
        return this._txConn != null;
    }

    Connection getUnderlying(int n) throws SQLException {
        if (n != this._clientId) {
            throw new SQLException("This application connection has been closed");
        }
        if (this._txConn != null) {
            if (this._txConn.timedOut) {
                throw new SQLException("The transaction has timed out and has been rolledback and closed");
            }
            if (this._txConn.conn == null) {
                throw new SQLException("The transaction has been terminated and this connection has been closed");
            }
            return this._txConn.conn;
        }
        if (this._underlying == null) {
            this._underlying = this._resManager.newConnection(this._userName, this._password);
            this._underlying.setAutoCommit(true);
        }
        return this._underlying;
    }

    private void releaseConnection(Connection connection) {
        this._resManager.releaseConnection(connection, this._userName, this._password);
    }
}

