/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultComponentFactory;
import org.apache.avalon.excalibur.component.LogkitLoggerManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;

public class DefaultComponentHandler
extends ComponentHandler {
    private final DefaultComponentFactory m_factory;
    private boolean m_initialized;
    private boolean m_disposed;

    protected DefaultComponentHandler(Class componentClass, Configuration config, ComponentManager manager, Context context, RoleManager roles, LogkitLoggerManager logkit) throws Exception {
        this(new DefaultComponentFactory(componentClass, config, manager, context, roles, logkit), config);
    }

    public DefaultComponentHandler(DefaultComponentFactory factory, Configuration config) throws Exception {
        this.m_factory = factory;
    }

    public void initialize() {
        if (this.m_initialized) {
            return;
        }
        this.m_factory.setLogger(this.getLogkitLogger());
        this.m_factory.enableLogging(this.getLogger());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ComponentHandler initialized for: " + this.m_factory.getCreatedClass().getName());
        }
        this.m_initialized = true;
    }

    protected Component doGet() throws Exception {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a component from an uninitialized holder.");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a component from a disposed holder");
        }
        return (Component)this.m_factory.newInstance();
    }

    protected void doPut(Component component) {
        block3: {
            if (!this.m_initialized) {
                throw new IllegalStateException("You cannot put a component in an uninitialized holder.");
            }
            try {
                this.m_factory.decommission(component);
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("Error decommissioning component: " + this.m_factory.getCreatedClass().getName(), (Throwable)e);
            }
        }
    }

    public void dispose() {
        block3: {
            try {
                if (this.m_factory instanceof Disposable) {
                    this.m_factory.dispose();
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("Error decommissioning component: " + this.m_factory.getCreatedClass().getName(), (Throwable)e);
            }
        }
        this.m_disposed = true;
    }
}

