/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.rdb.ConstraintsGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.DBIDInt;
import com.hp.hpl.mesa.rdf.jena.rdb.IConstraints;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.PropertyImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResourceImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetResourceIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetStatementIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetStringIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.SQLCache;
import com.hp.hpl.mesa.rdf.jena.rdb.StoreRDB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;

public class DriverGenericGeneric
implements IRDBDriver {
    protected String DRIVER_NAME = "java.lang.Class";
    protected String LAYOUT_TYPE = "Generic";
    protected String DATABASE_TYPE = "Generic";
    protected int MAX_LITERAL = 32000;
    protected String SQL_FILE = "etc/generic_generic.sql";
    protected String ID_SQL_TYPE = "INTEGER";
    protected boolean SKIP_DUPLICATE_CHECK = false;
    protected boolean SKIP_ALLOCATE_ID = false;
    protected boolean INSERT_BY_PROCEDURE = false;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected IDBConnection m_dbcon = null;
    protected SQLCache m_sql = null;
    protected List m_clientStores = new ArrayList();
    protected IDBID m_anonNSId = new DBIDInt(0);
    public static final String ANON_NAMESPACE = "_";
    protected static final String SQL_DEFAULT_FILE = "etc/generic_generic.sql";
    protected static Properties m_defaultSQL = null;
    protected static final int NS_BLOCKSIZE = 50;
    protected Map m_namespaceMap = new HashMap(50);
    protected Map m_namespaceIDMap = new HashMap(50);

    public DriverGenericGeneric() {
        this.cacheNamespaceId(ANON_NAMESPACE, this.m_anonNSId);
    }

    public void setConnection(IDBConnection iDBConnection) throws RDFRDBException {
        this.m_dbcon = iDBConnection;
        try {
            this.m_sql = new SQLCache(this.SQL_FILE, this.getDefaultSQL(), iDBConnection, this.ID_SQL_TYPE);
            this.m_sql.setCachePreparedStatements(this.CACHE_PREPARED_STATEMENTS);
        }
        catch (IOException iOException) {
            throw new RDFRDBException("Internal error loading sql defintion file: " + this.SQL_FILE, (Exception)iOException);
        }
    }

    protected Properties getDefaultSQL() throws IOException {
        if (m_defaultSQL == null) {
            m_defaultSQL = SQLCache.loadSQLFile(SQL_DEFAULT_FILE, null, this.ID_SQL_TYPE);
        }
        return m_defaultSQL;
    }

    public void close() throws RDFRDBException {
        try {
            this.m_dbcon.close();
            this.m_sql.close();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Problem closing RDB driver", (Exception)sQLException);
        }
    }

    public Connection getConnection() throws RDFRDBException {
        try {
            return this.m_dbcon.getConnection();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Problem opening database connection: " + sQLException);
        }
    }

    public SQLCache getSQLCache() {
        return this.m_sql;
    }

    public boolean isDBFormatOK() throws RDFRDBException {
        try {
            Connection connection = this.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, "RDF%", stringArray);
            ArrayList<String> arrayList = new ArrayList<String>(10);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("TABLE_NAME").toUpperCase());
            }
            resultSet.close();
            boolean bl = true;
            bl &= arrayList.contains("RDF_RESOURCES");
            bl &= arrayList.contains("RDF_STATEMENTS");
            return bl &= arrayList.contains("RDF_LAYOUT_INFO");
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal SQL error in driver", (Exception)sQLException);
        }
    }

    public void formatDB() throws RDFRDBException {
        try {
            this.m_sql.runSQLGroup("initDBtables");
            this.m_sql.runSQLGroup("initDBgenerators");
            this.m_sql.runSQLGroup("initDBprocedures");
            this.m_dbcon.addProperty("databaseType", this.DATABASE_TYPE);
            this.m_dbcon.addProperty("layoutType", this.LAYOUT_TYPE);
            this.m_dbcon.addProperty("driverClassname", this.getClass().getName());
            this.saveProperties();
        }
        catch (SQLException sQLException) {
            Log.warning("Problem formatting database", sQLException);
            throw new RDFRDBException("Failed to format database", (Exception)sQLException);
        }
    }

    public void cleanDB() {
        Object var1_1 = null;
        try {
            this.m_sql.runSQLGroup("cleanDBprocedures");
        }
        catch (SQLException sQLException) {
            Log.finest("Problem during database clean up", sQLException);
        }
        try {
            this.m_sql.runSQLGroup("cleanDBtables");
        }
        catch (SQLException sQLException) {
            Log.finest("Problem during database clean up", sQLException);
        }
        try {
            this.m_sql.runSQLGroup("cleanDBgenerators");
        }
        catch (SQLException sQLException) {
            Log.finest("Problem during database clean up", sQLException);
        }
    }

    public void loadProperties(Properties properties) {
        String string = properties.getProperty("jdbcDriver");
        if (string != null) {
            this.DRIVER_NAME = string;
        }
        if ((string = properties.getProperty("sqlFile")) != null) {
            this.SQL_FILE = string;
        }
        if ((string = properties.getProperty("layout")) != null) {
            this.LAYOUT_TYPE = string;
        }
        if ((string = properties.getProperty("database")) != null) {
            this.DATABASE_TYPE = string;
        }
        if ((string = properties.getProperty("idType")) != null) {
            this.ID_SQL_TYPE = string;
        }
        if ((string = properties.getProperty("maxLiteral")) != null) {
            this.MAX_LITERAL = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("allocateID")) != null) {
            boolean bl = this.SKIP_ALLOCATE_ID = !string.equals("true");
        }
        if ((string = properties.getProperty("checkDuplicates")) != null) {
            boolean bl = this.SKIP_DUPLICATE_CHECK = !string.equals("true");
        }
        if ((string = properties.getProperty("insertByProcedure")) != null) {
            this.INSERT_BY_PROCEDURE = string.equals("true");
        }
    }

    public void saveProperties() throws SQLException {
        this.m_dbcon.addProperty("jdbcDriver", this.DRIVER_NAME);
        this.m_dbcon.addProperty("sqlFile", this.SQL_FILE);
        this.m_dbcon.addProperty("layout", this.LAYOUT_TYPE);
        this.m_dbcon.addProperty("database", this.DATABASE_TYPE);
        this.m_dbcon.addProperty("idType", this.ID_SQL_TYPE);
        this.m_dbcon.addProperty("maxLiteral", Integer.toString(this.MAX_LITERAL));
        this.m_dbcon.addProperty("allocateID", this.SKIP_ALLOCATE_ID ? "false" : "true");
        this.m_dbcon.addProperty("checkDuplicates", this.SKIP_DUPLICATE_CHECK ? "false" : "true");
        this.m_dbcon.addProperty("insertByProcedure", this.INSERT_BY_PROCEDURE ? "true" : "false");
        this.m_dbcon.addProperty("cachePreparedStatements", this.CACHE_PREPARED_STATEMENTS ? "true" : "false");
    }

    public String toString() {
        return "jena.rdb.Driver" + this.LAYOUT_TYPE + this.DATABASE_TYPE + "(" + this.SQL_FILE + ")";
    }

    public synchronized void attachStore(StoreRDB storeRDB) {
        this.m_clientStores.add(storeRDB);
    }

    public synchronized void detachStore(StoreRDB storeRDB) {
        this.m_clientStores.remove(storeRDB);
        if (this.m_clientStores.isEmpty()) {
            try {
                this.close();
            }
            catch (RDFRDBException rDFRDBException) {
                Log.warning("Error which cleaning up RDB store", rDFRDBException);
            }
        }
    }

    public void addStatement(Statement statement, ModelRDB modelRDB) throws RDFException {
        if (!this.SKIP_DUPLICATE_CHECK && this.isStatementPresent(statement.getSubject(), statement.getPredicate(), statement.getObject(), modelRDB)) {
            return;
        }
        IDBID iDBID = this.addResource(statement.getPredicate());
        IDBID iDBID2 = this.addResource(statement.getSubject());
        RDFNode rDFNode = statement.getObject();
        IDBID iDBID3 = null;
        boolean bl = rDFNode instanceof Literal;
        iDBID3 = bl ? this.addLiteral((Literal)rDFNode) : this.addResource((Resource)rDFNode);
        try {
            Object[] objectArray = new Object[]{iDBID2.getID(), iDBID.getID(), iDBID3.getID(), new Short(bl ? (short)1 : 0), modelRDB.getDBID().getID()};
            this.m_sql.runSQLQuery(this.INSERT_BY_PROCEDURE ? "insertStatementProc" : "insertStatement", objectArray);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to register statement", (Exception)sQLException);
        }
    }

    public ResultSetIterator listSubjects(ModelRDB modelRDB) throws RDFRDBException {
        try {
            Object[] objectArray = null;
            if (this.supportsMultipleModels()) {
                objectArray = new Object[]{modelRDB.getDBID().getID()};
            }
            ResultSetResourceIterator resultSetResourceIterator = new ResultSetResourceIterator(modelRDB, this);
            return this.m_sql.runSQLQuery("listSubjects", objectArray, resultSetResourceIterator);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failure in listSubjects", (Exception)sQLException);
        }
    }

    public ResultSetIterator listNamespaces(ModelRDB modelRDB) throws RDFRDBException {
        try {
            ResultSetStringIterator resultSetStringIterator = new ResultSetStringIterator();
            Object[] objectArray = null;
            if (this.supportsMultipleModels()) {
                objectArray = new Object[]{modelRDB.getDBID().getID()};
            }
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("listNamespaces", objectArray, resultSetStringIterator);
            return resultSetIterator;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failure in listNamespaces", (Exception)sQLException);
        }
    }

    public ResultSetIterator listStatements(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        String string = "list";
        if (resource != null) {
            string = string + "S";
        }
        if (property != null) {
            string = string + "P";
        }
        if (rDFNode != null) {
            string = string + "O";
        }
        try {
            Object[] objectArray = this.statementArgs(resource, property, rDFNode, modelRDB);
            if (objectArray == null) {
                return new ResultSetIterator();
            }
            return this.m_sql.runSQLQuery(string, objectArray, new ResultSetStatementIterator(modelRDB, this));
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in " + string, (Exception)sQLException);
        }
    }

    public boolean isStatementPresent(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        try {
            Object[] objectArray = this.statementArgs(resource, property, rDFNode, modelRDB);
            if (objectArray == null) {
                return false;
            }
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("checkStatement", objectArray);
            boolean bl = resultSetIterator.hasNext();
            resultSetIterator.close();
            return bl;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in isStatementPresent", (Exception)sQLException);
        }
    }

    public ResultSetIterator listStatements(IConstraints iConstraints, ModelRDB modelRDB) throws RDFException {
        return iConstraints.runQuery(this, modelRDB);
    }

    public IConstraints createConstraints(ModelRDB modelRDB) {
        return new ConstraintsGeneric(modelRDB);
    }

    public void deleteStatement(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        try {
            Object[] objectArray = this.statementArgs(resource, property, rDFNode, modelRDB);
            if (objectArray == null) {
                return;
            }
            this.m_sql.runSQLQuery("deleteStatement", objectArray);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in deleteStatement", (Exception)sQLException);
        }
    }

    public Resource getResource(String string, ModelRDB modelRDB) throws RDFException {
        ResourceImplRDB resourceImplRDB = new ResourceImplRDB(string, (Model)modelRDB);
        return resourceImplRDB;
    }

    public Property getProperty(String string, ModelRDB modelRDB) throws RDFException {
        PropertyImplRDB propertyImplRDB = new PropertyImplRDB(string, (Model)modelRDB);
        return propertyImplRDB;
    }

    public boolean supportsMultipleModels() {
        return false;
    }

    public IDBID allocateModelID(String string) throws RDFRDBException {
        return new DBIDInt(0);
    }

    public IDBID getModelID(String string) throws RDFRDBException {
        throw new RDFRDBException("Generic driver does not support multiple models in one database.\nCaught attempting to access model: " + string);
    }

    public Iterator listModels() throws RDFRDBException {
        return ((AbstractList)new ArrayList()).iterator();
    }

    protected IDBID allocateID(String string) throws RDFRDBException {
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery(string, new Object[0]);
            if (resultSetIterator.hasNext()) {
                return this.wrapDBID(resultSetIterator.getSingleton());
            }
            throw new RDFRDBException("Failed to allocate ID");
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    public String getNamespace(IDBID iDBID) throws RDFRDBException {
        String string = (String)this.m_namespaceMap.get(iDBID);
        if (string == null) {
            try {
                ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getNamespace", new Object[]{iDBID.getID()});
                if (resultSetIterator.hasNext()) {
                    string = (String)resultSetIterator.getSingleton();
                } else {
                    string = null;
                    resultSetIterator.close();
                }
                if (string != null) {
                    this.cacheNamespaceId(string, iDBID);
                }
            }
            catch (SQLException sQLException) {
                throw new RDFRDBException("Internal error fetching namespace name", (Exception)sQLException);
            }
        }
        return string;
    }

    protected IDBID getNamespaceID(String string) throws RDFRDBException {
        if (this.m_namespaceIDMap.containsKey(string)) {
            return (IDBID)this.m_namespaceIDMap.get(string);
        }
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getNamespaceID", new Object[]{string});
            if (resultSetIterator.hasNext()) {
                IDBID iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                this.cacheNamespaceId(string, iDBID);
                return iDBID;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    protected IDBID allocateNamespaceID(String string) throws RDFRDBException {
        if (this.m_namespaceIDMap.containsKey(string)) {
            return (IDBID)this.m_namespaceIDMap.get(string);
        }
        return this.allocateID("allocateNamespaceID");
    }

    protected IDBID addNamespace(String string) throws RDFRDBException {
        if (this.m_namespaceIDMap.containsKey(string)) {
            return (IDBID)this.m_namespaceIDMap.get(string);
        }
        Object[] objectArray = null;
        IDBID iDBID = null;
        if (!this.SKIP_DUPLICATE_CHECK && (iDBID = this.getNamespaceID(string)) != null) {
            return iDBID;
        }
        if (!this.SKIP_ALLOCATE_ID) {
            iDBID = this.allocateNamespaceID(string);
            objectArray = new Object[]{iDBID.getID(), string};
        } else {
            objectArray = new Object[]{string};
        }
        try {
            if (this.INSERT_BY_PROCEDURE) {
                ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("insertNamespaceProc", objectArray);
                if (resultSetIterator != null && resultSetIterator.hasNext()) {
                    iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                }
            } else {
                this.m_sql.runSQLQuery("insertNamespace", objectArray);
            }
            if (iDBID == null) {
                iDBID = this.getNamespaceID(string);
            }
            this.cacheNamespaceId(string, iDBID);
            return iDBID;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    public Literal getLiteral(IDBID iDBID) throws RDFException {
        try {
            int n;
            Object object;
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("getLiteral");
            preparedStatement.setObject(1, iDBID.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                this.m_sql.returnPreparedSQLStatement(preparedStatement, "getLiteral");
                return null;
            }
            Object object2 = resultSet.getObject(1);
            String string = null;
            if (object2 == null) {
                string = resultSet.getString(2);
            } else {
                object = null;
                object = object instanceof InputStream ? (InputStream)object2 : resultSet.getBinaryStream(1);
                n = ((InputStream)object).read() & 0xFF;
                n |= (((InputStream)object).read() & 0xFF) << 8;
                n |= (((InputStream)object).read() & 0xFF) << 16;
                byte[] byArray = new byte[n |= (((InputStream)object).read() & 0xFF) << 24];
                int n2 = 0;
                while (n2 < n) {
                    int n3 = ((InputStream)object).read(byArray, n2, n - n2);
                    if (n3 == -1) {
                        throw new RDFRDBException("Premature end of blob in large literal, got " + n2);
                    }
                    n2 += n3;
                }
                ((InputStream)object).close();
                string = new String(byArray, "UTF-8");
            }
            object = resultSet.getString(3);
            n = resultSet.getInt(4);
            resultSet.close();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, "getLiteral");
            return new LiteralImpl(string, (String)object, n == 1);
        }
        catch (Exception exception) {
            throw new RDFRDBException("Internal sql error", exception);
        }
    }

    protected IDBID addLiteral(Literal literal) throws RDFRDBException {
        IDBID iDBID = null;
        if (!this.SKIP_DUPLICATE_CHECK && (iDBID = this.getLiteralID(literal)) != null) {
            return iDBID;
        }
        try {
            Object object;
            String string;
            int n;
            String string2;
            int n2 = 0;
            boolean bl = false;
            try {
                n2 = Integer.parseInt(literal.toString());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            String string3 = string2 = bl ? "insertLiteralInt" : "insertLiteral";
            if (this.INSERT_BY_PROCEDURE) {
                string2 = string2 + "Proc";
            }
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2);
            int n3 = 1;
            if (!this.SKIP_ALLOCATE_ID) {
                iDBID = this.allocateLiteralID(literal);
                preparedStatement.setObject(n3++, iDBID.getID());
            }
            if ((n = (string = literal.toString()).length()) >= this.MAX_LITERAL) {
                preparedStatement.setString(n3++, this.getLiteralIdx(string));
                object = string.getBytes("UTF-8");
                int n4 = ((byte[])object).length;
                byte[] byArray = new byte[n4 + 4];
                byArray[0] = (byte)(n4 & 0xFF);
                byArray[1] = (byte)(n4 >> 8 & 0xFF);
                byArray[2] = (byte)(n4 >> 16 & 0xFF);
                byArray[3] = (byte)(n4 >> 24 & 0xFF);
                System.arraycopy(object, 0, byArray, 4, n4);
                preparedStatement.setBinaryStream(n3++, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            } else {
                preparedStatement.setString(n3++, string);
                preparedStatement.setNull(n3++, 2004);
            }
            preparedStatement.setString(n3++, literal.getLanguage());
            preparedStatement.setInt(n3++, literal.getWellFormed() ? 1 : 0);
            if (bl) {
                preparedStatement.setInt(n3++, n2);
            }
            if (this.INSERT_BY_PROCEDURE) {
                object = preparedStatement.executeQuery();
                ResultSetIterator resultSetIterator = new ResultSetIterator((ResultSet)object, preparedStatement, this.m_sql, string2);
                if (resultSetIterator != null && resultSetIterator.hasNext()) {
                    iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                }
            } else {
                preparedStatement.executeUpdate();
                this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
            }
            if (iDBID == null) {
                iDBID = this.getLiteralID(literal);
            }
            return iDBID;
        }
        catch (Exception exception) {
            System.out.println("Problem on literal (l=" + literal.toString().length() + ") ");
            System.out.println("ID is: " + iDBID);
            throw new RDFRDBException("Failed to register literal", exception);
        }
    }

    public IDBID getLiteralID(Literal literal) throws RDFRDBException {
        try {
            ResultSetIterator resultSetIterator;
            String string = literal.toString();
            if (string.length() >= this.MAX_LITERAL) {
                string = this.getLiteralIdx(string);
            }
            if ((resultSetIterator = this.m_sql.runSQLQuery("getLiteralID", new Object[]{string, literal.getLanguage()})).hasNext()) {
                return this.wrapDBID(resultSetIterator.getSingleton());
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find literal", (Exception)sQLException);
        }
    }

    protected IDBID allocateLiteralID(Literal literal) throws RDFRDBException {
        return this.allocateID("allocateLiteralID");
    }

    protected IDBID addResource(Resource resource) throws RDFException {
        IDBID iDBID;
        IDBID iDBID2;
        boolean bl = resource instanceof ResourceImplRDB;
        ResourceImplRDB resourceImplRDB = bl ? (ResourceImplRDB)resource : null;
        IDBID iDBID3 = iDBID2 = bl ? resourceImplRDB.getRDBId() : null;
        if (iDBID2 != null) {
            return iDBID2;
        }
        Object[] objectArray = null;
        int n = 0;
        if (!this.SKIP_DUPLICATE_CHECK && (iDBID2 = this.getResourceID(resource)) != null) {
            return iDBID2;
        }
        if (!this.SKIP_ALLOCATE_ID) {
            iDBID2 = this.allocateResourceID(resource);
            objectArray = new Object[3];
            objectArray[n++] = iDBID2.getID();
        } else {
            objectArray = new Object[2];
        }
        objectArray[n++] = resource.isAnon() ? resource.getId().toString() : resource.getLocalName();
        IDBID iDBID4 = iDBID = bl ? resourceImplRDB.getRDBNSId() : null;
        if (iDBID == null) {
            IDBID iDBID5 = iDBID = resource.isAnon() ? this.m_anonNSId : this.addNamespace(resource.getNameSpace());
            if (bl) {
                resourceImplRDB.setRDBNSId(iDBID);
            }
        }
        objectArray[n++] = iDBID.getID();
        try {
            if (this.INSERT_BY_PROCEDURE) {
                ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("insertResourceProc", objectArray);
                if (resultSetIterator != null && resultSetIterator.hasNext()) {
                    iDBID2 = this.wrapDBID(resultSetIterator.getSingleton());
                }
            } else {
                this.m_sql.runSQLQuery("insertResource", objectArray);
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to register resource", (Exception)sQLException);
        }
        if (iDBID2 == null) {
            iDBID2 = this.getResourceID(resource);
        }
        if (bl) {
            resourceImplRDB.setRDBId(iDBID2);
        }
        return iDBID2;
    }

    public IDBID getResourceID(Resource resource) throws RDFException {
        try {
            ResourceImplRDB resourceImplRDB = (ResourceImplRDB)resource;
            IDBID iDBID = resourceImplRDB.getRDBId();
            if (iDBID != null) {
                return iDBID;
            }
            String string = resource.isAnon() ? ANON_NAMESPACE : resource.getNameSpace();
            IDBID iDBID2 = this.getNamespaceID(string);
            if (iDBID2 == null) {
                return null;
            }
            resourceImplRDB.setRDBNSId(iDBID2);
            String string2 = resource.isAnon() ? resource.getId().toString() : resource.getLocalName();
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getResourceID", new Object[]{string2, iDBID2.getID()});
            if (resultSetIterator.hasNext()) {
                iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                resourceImplRDB.setRDBId(iDBID);
                return iDBID;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find resource", (Exception)sQLException);
        }
    }

    protected IDBID allocateResourceID(Resource resource) throws RDFException {
        return this.allocateID("allocateResourceID");
    }

    public Resource getResource(IDBID iDBID, ModelRDB modelRDB) throws RDFException {
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getResource", new Object[]{iDBID.getID()});
            if (resultSetIterator.hasNext()) {
                List list = (List)resultSetIterator.next();
                String string = (String)list.get(0);
                IDBID iDBID2 = this.wrapDBID(list.get(1));
                resultSetIterator.close();
                return this.makeResource(iDBID, string, iDBID2, modelRDB);
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    public Property getProperty(IDBID iDBID, ModelRDB modelRDB) throws RDFException {
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getResource", new Object[]{iDBID.getID()});
            if (resultSetIterator.hasNext()) {
                List list = (List)resultSetIterator.next();
                String string = (String)list.get(0);
                IDBID iDBID2 = this.wrapDBID(list.get(1));
                resultSetIterator.close();
                PropertyImplRDB propertyImplRDB = new PropertyImplRDB(this.getNamespace(iDBID2), string, modelRDB);
                propertyImplRDB.setRDBId(iDBID);
                propertyImplRDB.setRDBNSId(iDBID2);
                return propertyImplRDB;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", (Exception)sQLException);
        }
    }

    protected String getLiteralIdx(String string) {
        String string2 = string;
        if (string.length() > this.MAX_LITERAL - 16) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(string.getBytes());
            string2 = string.substring(0, this.MAX_LITERAL - 16) + Long.toHexString(cRC32.getValue());
        }
        return string2;
    }

    public IDBID wrapDBID(Object object) {
        return new DBIDInt((Integer)object);
    }

    protected void cacheNamespaceId(String string, IDBID iDBID) {
        if (!this.m_namespaceMap.containsKey(iDBID)) {
            this.m_namespaceMap.put(iDBID, string);
            this.m_namespaceIDMap.put(string, iDBID);
        }
    }

    public Resource makeResource(IDBID iDBID, String string, IDBID iDBID2, ModelRDB modelRDB) throws RDFException {
        ResourceImplRDB resourceImplRDB = null;
        resourceImplRDB = iDBID2.equals(this.m_anonNSId) ? new ResourceImplRDB(new AnonId(string), (Model)modelRDB) : new ResourceImplRDB(this.getNamespace(iDBID2) + string, (Model)modelRDB);
        resourceImplRDB.setRDBId(iDBID);
        resourceImplRDB.setRDBNSId(iDBID2);
        return resourceImplRDB;
    }

    public void loadDatabaseDriver() throws RDFRDBException {
        try {
            Class.forName(this.DRIVER_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RDFRDBException("Unable to load driver: " + this.DRIVER_NAME);
        }
    }

    protected Object[] statementArgs(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        IDBID iDBID;
        int n = 0;
        int n2 = 0;
        if (resource != null) {
            ++n2;
        }
        if (property != null) {
            ++n2;
        }
        if (rDFNode != null) {
            n2 += 2;
        }
        if (this.supportsMultipleModels()) {
            ++n2;
        }
        Object[] objectArray = new Object[n2];
        if (resource != null) {
            iDBID = this.getResourceID(resource);
            if (iDBID == null) {
                return null;
            }
            objectArray[n++] = iDBID.getID();
        }
        if (property != null) {
            iDBID = this.getResourceID(property);
            if (iDBID == null) {
                return null;
            }
            objectArray[n++] = iDBID.getID();
        }
        if (rDFNode != null) {
            if (rDFNode instanceof Literal) {
                iDBID = this.getLiteralID((Literal)rDFNode);
                if (iDBID == null) {
                    return null;
                }
                objectArray[n++] = iDBID.getID();
                objectArray[n++] = new Short(1);
            } else {
                iDBID = this.getResourceID((Resource)rDFNode);
                if (iDBID == null) {
                    return null;
                }
                objectArray[n++] = iDBID.getID();
                objectArray[n++] = new Short(0);
            }
        }
        if (this.supportsMultipleModels()) {
            objectArray[n++] = modelRDB.getDBID().getID();
        }
        return objectArray;
    }

    public void hintPropertyTable(Property property) throws RDFException {
    }
}

