/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.rdb.IDBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class DBConnection
implements IDBConnection {
    protected Connection m_connection;
    protected String m_url;
    protected String m_user;
    protected String m_password;
    protected IRDBDriver m_driver;
    protected boolean m_loadedLayout = false;
    protected boolean m_formated = false;
    protected Properties m_properties = new Properties();
    static /* synthetic */ Class class$com$hp$hpl$mesa$rdf$jena$rdb$DBConnection;

    public DBConnection(String string, String string2, String string3) {
        this.m_url = string;
        this.m_user = string2;
        this.m_password = string3;
    }

    public DBConnection(Connection connection) {
        this.m_connection = connection;
    }

    public Connection getConnection() throws SQLException {
        if (this.m_connection == null && this.m_url != null) {
            this.m_connection = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
            this.m_connection.setAutoCommit(true);
        }
        return this.m_connection;
    }

    public void close() throws SQLException {
        if (this.m_connection != null) {
            this.m_connection.close();
        }
        this.m_connection = null;
    }

    public boolean isFormatOK() throws RDFRDBException {
        try {
            this.loadProperties();
            return this.m_formated;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to access database format information: ", (Exception)sQLException);
        }
    }

    public String getProperty(String string) throws SQLException {
        this.loadProperties();
        return this.m_properties.getProperty(string);
    }

    public Properties getProperties() throws SQLException {
        this.loadProperties();
        return this.m_properties;
    }

    public IRDBDriver getDriver() throws RDFRDBException {
        if (this.m_driver != null) {
            return this.m_driver;
        }
        try {
            String string = this.getProperty("driverClassname");
            if (string == null) {
                String string2 = this.getProperty("databaseType");
                String string3 = this.getProperty("layoutType");
                if (string2 == null || string3 == null) {
                    return null;
                }
                this.m_driver = this.getDriver(string3, string2);
            } else {
                this.m_driver = this.getDriver(string);
            }
            this.m_driver.loadProperties(this.getProperties());
            this.m_driver.setConnection(this);
            return this.m_driver;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failure to instansiate DB driver", (Exception)sQLException);
        }
    }

    public void setDriver(IRDBDriver iRDBDriver) {
        this.m_driver = iRDBDriver;
    }

    public IRDBDriver getDriver(String string, String string2) throws RDFRDBException {
        if (this.m_driver != null) {
            return this.m_driver;
        }
        String string3 = "com.hp.hpl.mesa.rdf.jena.rdb.Driver" + string2 + string;
        try {
            this.m_driver = this.getDriver(string3);
        }
        catch (RDFRDBException rDFRDBException) {
            String string4 = "etc/" + string2 + "_" + string + ".config";
            InputStream inputStream = (class$com$hp$hpl$mesa$rdf$jena$rdb$DBConnection == null ? (class$com$hp$hpl$mesa$rdf$jena$rdb$DBConnection = DBConnection.class$("com.hp.hpl.mesa.rdf.jena.rdb.DBConnection")) : class$com$hp$hpl$mesa$rdf$jena$rdb$DBConnection).getClassLoader().getResourceAsStream(string4);
            if (inputStream == null) {
                string4 = "etc/" + string2 + ".config";
                this.m_driver = this.getDriver(string, "Generic");
                inputStream = (class$com$hp$hpl$mesa$rdf$jena$rdb$DBConnection == null ? (class$com$hp$hpl$mesa$rdf$jena$rdb$DBConnection = DBConnection.class$("com.hp.hpl.mesa.rdf.jena.rdb.DBConnection")) : class$com$hp$hpl$mesa$rdf$jena$rdb$DBConnection).getClassLoader().getResourceAsStream(string4);
                if (inputStream == null) {
                    throw new RDFRDBException("Failure to instansiate DB driver for " + string + " on " + string2);
                }
            }
            try {
                this.m_properties = new Properties();
                this.m_properties.load(inputStream);
                inputStream.close();
                if (this.m_driver == null) {
                    String string5 = this.m_properties.getProperty("baseClass");
                    this.m_driver = (IRDBDriver)Class.forName(string5).newInstance();
                }
                this.m_driver.loadProperties(this.m_properties);
            }
            catch (Exception exception) {
                throw new RDFRDBException("Failure to instansiate DB driver for " + string + " on " + string2);
            }
        }
        if (this.m_driver != null) {
            this.m_driver.setConnection(this);
        }
        return this.m_driver;
    }

    private IRDBDriver getDriver(String string) throws RDFRDBException {
        if (this.m_driver != null) {
            return this.m_driver;
        }
        try {
            this.m_driver = (IRDBDriver)Class.forName(string).newInstance();
            return this.m_driver;
        }
        catch (Exception exception) {
            throw new RDFRDBException("Failure to instansiate DB driver: " + string, exception);
        }
    }

    public void addProperty(String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("INSERT INTO RDF_LAYOUT_INFO (NAME, VAL) VALUES (?,?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ((Hashtable)this.m_properties).put(string, string2);
    }

    protected void loadProperties() throws SQLException {
        if (!this.m_loadedLayout) {
            Connection connection = this.getConnection();
            if (connection == null) {
                throw new SQLException("Failed to open database " + this.m_url);
            }
            try {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT NAME, VAL FROM RDF_LAYOUT_INFO");
                this.m_properties = new Properties();
                while (resultSet.next()) {
                    ((Hashtable)this.m_properties).put(resultSet.getString(1), resultSet.getString(2));
                }
                this.m_formated = true;
            }
            catch (SQLException sQLException) {
                this.m_formated = false;
            }
            this.m_loadedLayout = true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

