/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.Constraint;
import com.hp.hpl.jena.rdf.query.EvalFailureException;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Sys;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.util.Log;

public class ConstraintExpr
implements Constraint {
    Expr expr;

    ConstraintExpr(Expr expr) {
        this.expr = expr;
    }

    public boolean isSatified(Query query, ResultBinding resultBinding) {
        if (this.expr == null) {
            return false;
        }
        try {
            if (query.getLog() != null) {
                query.getLog();
                Log.debug("Eval: " + this.expr.asInfixString() + " :: " + resultBinding);
            }
            return this.expr.eval(query, resultBinding).getBoolean();
        }
        catch (EvalFailureException evalFailureException) {
            return false;
        }
        catch (Exception exception) {
            Sys.unhandledException(exception, "ConstraintExpr", "isSatified");
            return false;
        }
    }

    public String toString() {
        return this.expr.asInfixString();
    }
}

