/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class NullPointer
extends PropertyOwnerPointer {
    private QName name;
    private String id;

    public NullPointer(QName name, Locale locale) {
        super(null, locale);
        this.name = name;
    }

    public NullPointer(NodePointer parent, QName name) {
        super(parent);
        this.name = name;
    }

    public NullPointer(Locale locale, String id) {
        super(null, locale);
        this.id = id;
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return null;
    }

    public void setValue(Object value) {
        super.setValue(value);
        if (!(this.parent instanceof PropertyPointer)) {
            throw new UnsupportedOperationException("Cannot setValue of an object that is not some other object's property/child");
        }
        this.parent.setValue(value);
    }

    public boolean isActual() {
        return false;
    }

    public PropertyPointer getPropertyPointer() {
        return new NullPropertyPointer(this);
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.parent != null) {
            if (this.parent instanceof PropertyPointer) {
                return this.parent.createPath(context, value);
            }
            return this.parent.createChild(context, this.getName(), 0, value);
        }
        throw new UnsupportedOperationException("Cannot create the root object: " + this.asPath());
    }

    public NodePointer createPath(JXPathContext context) {
        if (this.parent != null) {
            if (this.parent instanceof PropertyPointer) {
                return this.parent.createPath(context).getValuePointer();
            }
            return this.parent.createChild(context, this.getName(), 0).getValuePointer();
        }
        throw new UnsupportedOperationException("Cannot create the root object: " + this.asPath());
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        NodePointer pointer;
        if (this.parent != null && (pointer = this.createPath(context)) != null) {
            pointer = pointer.getValuePointer().createChild(context, name, index, value);
            return pointer;
        }
        throw new UnsupportedOperationException("Cannot create the root object: " + this.asPath());
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        NodePointer pointer;
        if (this.parent != null && (pointer = this.createPath(context)) != null) {
            return pointer.createChild(context, name, index);
        }
        throw new UnsupportedOperationException("Cannot create the root object: " + this.asPath());
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NullPointer)) {
            return false;
        }
        NullPointer other = (NullPointer)object;
        return this.name == null && other.name == null || this.name != null && this.name.equals(other.name);
    }

    public String asPath() {
        if (this.id != null) {
            return "id(" + this.id + ")";
        }
        if (this.parent != null) {
            return super.asPath();
        }
        return "null()";
    }

    public int getLength() {
        return 0;
    }
}

