/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class CollectionPointer
extends NodePointer {
    private Object collection;
    private NodePointer valuePointer;

    public CollectionPointer(Object collection, Locale locale) {
        super(null, locale);
        this.collection = collection;
    }

    public CollectionPointer(NodePointer parent, Object collection) {
        super(parent);
        this.collection = collection;
    }

    public QName getName() {
        return null;
    }

    public Object getBaseValue() {
        return this.collection;
    }

    public Object getNodeValue() {
        if (this.index != NodePointer.WHOLE_COLLECTION) {
            return ValueUtils.getValue(this.collection, this.index);
        }
        return this.collection;
    }

    public void setValue(Object value) {
        if (this.index == NodePointer.WHOLE_COLLECTION) {
            this.parent.setValue(value);
        } else {
            ValueUtils.setValue(this.collection, this.index, value);
        }
    }

    public NodePointer getValuePointer() {
        if (this.valuePointer == null) {
            Object value = this.getNodeValue();
            this.valuePointer = NodePointer.newChildNodePointer(this, this.getName(), value);
        }
        return this.valuePointer;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        if (this.parent instanceof PropertyPointer) {
            return this.parent.createChild(context, name, index, value);
        }
        Object collection = this.getBaseValue();
        if (ValueUtils.getLength(collection) <= index) {
            ValueUtils.expandCollection(this.getNodeValue(), index + 1);
        }
        ValueUtils.setValue(collection, index, value);
        NodePointer ptr = (NodePointer)this.clone();
        ptr.setIndex(index);
        return ptr;
    }

    public NodePointer createPath(JXPathContext context) {
        if (this.parent instanceof PropertyPointer) {
            return this.parent.createPath(context);
        }
        Object collection = this.getBaseValue();
        if (ValueUtils.getLength(collection) <= this.index) {
            ValueUtils.expandCollection(this.getNodeValue(), this.index + 1);
        }
        return this;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        if (this.parent instanceof PropertyPointer) {
            return this.parent.createChild(context, name, index);
        }
        Object collection = this.getBaseValue();
        if (ValueUtils.getLength(collection) <= index) {
            ValueUtils.expandCollection(this.getNodeValue(), index + 1);
        }
        return this;
    }

    public int hashCode() {
        return System.identityHashCode(this.collection) + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CollectionPointer)) {
            return false;
        }
        CollectionPointer other = (CollectionPointer)object;
        return this.collection == other.collection && this.index == other.index;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        if (this.index == NodePointer.WHOLE_COLLECTION) {
            return null;
        }
        return this.getValuePointer().childIterator(test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return this.getValuePointer().attributeIterator(name);
    }

    public NodeIterator namespaceIterator() {
        return this.getValuePointer().namespaceIterator();
    }

    public NodePointer namespacePointer(String namespace) {
        return this.getValuePointer().namespacePointer(namespace);
    }

    public boolean testNode(NodeTest nodeTest) {
        return this.getValuePointer().testNode(nodeTest);
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return pointer1.getIndex() - pointer2.getIndex();
    }
}

