/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.regression;

import com.hp.hpl.mesa.rdf.jena.common.StatementImpl;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.Filter;
import com.hp.hpl.mesa.rdf.jena.common.regression.testWriterAndReader;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class MakeAnon {
    Filter isAnon;
    Map mapping;
    Model rslt;
    String baseNameSpace;
    Set anonymous;

    MakeAnon(String string) {
        if (string.equals("RDF/XML-ABBREV")) {
            this.isAnon = new Filter(){

                public boolean accept(Object object) {
                    String string = (String)object;
                    return string.startsWith("RDFAnon");
                }
            };
        } else if (string.equals("RDF/XML")) {
            this.isAnon = new Filter(){

                public boolean accept(Object object) {
                    String string = (String)object;
                    if (string.startsWith("A")) {
                        try {
                            Integer.parseInt(string.substring(1));
                            return true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return false;
                }
            };
        } else if (string.equals("N-TRIPLE")) {
            this.isAnon = new Filter(){

                public boolean accept(Object object) {
                    return false;
                }
            };
        } else {
            throw new IllegalArgumentException("Unsupported language: " + string);
        }
    }

    private void addStatements(StmtIterator stmtIterator) throws RDFException {
        try {
            while (stmtIterator.hasNext()) {
                this.rslt.add(this.mapAnon(stmtIterator.next()));
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
    }

    Model makeAnon(Model model, String string, Model model2) throws RDFException {
        this.rslt = model2;
        this.anonymous = new HashSet();
        testWriterAndReader.empty(this.rslt);
        this.mapping = new HashMap();
        this.baseNameSpace = string;
        this.addStatements(model.listStatements());
        return this.rslt;
    }

    private Statement mapAnon(Statement statement) throws RDFException {
        Resource resource = statement.getSubject();
        RDFNode rDFNode = statement.getObject();
        Resource resource2 = this.map(resource);
        RDFNode rDFNode2 = rDFNode instanceof Resource ? this.map((Resource)rDFNode) : rDFNode;
        if (resource2 != resource || rDFNode2 != rDFNode) {
            return new StatementImpl(resource2, statement.getPredicate(), rDFNode2);
        }
        return statement;
    }

    private Resource map(Resource resource) throws RDFException {
        if (resource.isAnon()) {
            this.anonymous.add(resource);
            return resource;
        }
        String string = resource.getURI();
        int n = string.lastIndexOf(35);
        if (n == -1) {
            return resource;
        }
        if (n != this.baseNameSpace.length() || !string.startsWith(this.baseNameSpace)) {
            return resource;
        }
        String string2 = string.substring(n + 1);
        if (this.isAnon.accept(string2)) {
            Resource resource2 = (Resource)this.mapping.get(resource);
            if (resource2 == null) {
                resource2 = this.rslt.createResource();
                this.anonymous.add(resource2);
                this.mapping.put(resource, resource2);
            }
            return resource2;
        }
        return resource;
    }

    int lastCnt() {
        return this.anonymous.size();
    }
}

