/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.EvalTypeException;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryFormatUtils;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Settable;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.WorkingVar;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.rdf.query.parser.ExprBoolean;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.rdf.query.parser.SimpleNode;
import java.io.PrintWriter;

class Q_LogicalOr
extends SimpleNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    private String printName = "or";
    private String opSymbol = "||";

    Q_LogicalOr(int n) {
        super(n);
    }

    Q_LogicalOr(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        Value value = this.left.eval(query, resultBinding);
        Value value2 = this.right.eval(query, resultBinding);
        if (!value.isBoolean()) {
            throw new EvalTypeException("Q_LogicalOr: Wanted a boolean: " + value);
        }
        if (!value2.isBoolean()) {
            throw new EvalTypeException("Q_LogicalOr: Wanted a boolean: " + value2);
        }
        Settable settable = value instanceof Settable ? (Settable)value : (value2 instanceof Settable ? (Settable)value2 : new WorkingVar());
        boolean bl = value.getBoolean() || value2.getBoolean();
        settable.setBoolean(bl);
        return settable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_LogicalOr: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public String asInfixString() {
        return QueryFormatUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryFormatUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryFormatUtils.print(printWriter, this.left, this.right, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

