/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jfor.jfor.rtflib.exceptions.RtfStructureException;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfElement;
import org.jfor.jfor.rtflib.rtfdoc.RtfFile;
import org.jfor.jfor.rtflib.rtfdoc.RtfOptions;
import org.jfor.jfor.rtflib.rtfdoc.RtfText;

public class RtfContainer
extends RtfElement {
    private final LinkedList m_children;
    private RtfOptions m_options = new RtfOptions();
    private RtfElement m_lastChild;

    RtfContainer(RtfContainer rtfContainer, Writer writer) throws IOException {
        this(rtfContainer, writer, null);
    }

    RtfContainer(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super(rtfContainer, writer, rtfAttributes);
        this.m_children = new LinkedList();
    }

    public void setOptions(RtfOptions rtfOptions) {
        this.m_options = rtfOptions;
    }

    protected void addChild(RtfElement rtfElement) throws RtfStructureException {
        if (this.isClosed()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("addChild: container already closed (parent=");
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(" child=");
            stringBuffer.append(rtfElement.getClass().getName());
            stringBuffer.append(")");
            String string = stringBuffer.toString();
            RtfFile rtfFile = this.getRtfFile();
            if (rtfFile.getLog() != null) {
                rtfFile.getLog().logWarning(string);
            }
        }
        this.m_children.add(rtfElement);
        this.m_lastChild = rtfElement;
    }

    public List getChildren() {
        return (List)this.m_children.clone();
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    protected void writeRtfContent() throws IOException {
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            RtfElement rtfElement = (RtfElement)iterator.next();
            rtfElement.writeRtf();
        }
    }

    RtfOptions getOptions() {
        return this.m_options;
    }

    boolean containsText() {
        boolean bl = false;
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            RtfElement rtfElement = (RtfElement)iterator.next();
            if (rtfElement instanceof RtfText) {
                bl = !rtfElement.isEmpty();
            } else if (rtfElement instanceof RtfContainer && ((RtfContainer)rtfElement).containsText()) {
                bl = true;
            }
            if (bl) break;
        }
        return bl;
    }

    void dump(Writer writer, int n) throws IOException {
        super.dump(writer, n);
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            RtfElement rtfElement = (RtfElement)iterator.next();
            rtfElement.dump(writer, n + 1);
        }
    }

    public String toString() {
        return super.toString() + " (" + this.getChildCount() + " children)";
    }

    protected boolean okToWriteRtf() {
        boolean bl;
        boolean bl2 = bl = super.okToWriteRtf() && !this.isEmpty();
        if (bl && !this.m_options.renderContainer(this)) {
            bl = false;
        }
        return bl;
    }

    public boolean isEmpty() {
        boolean bl = true;
        Iterator iterator = this.m_children.iterator();
        while (iterator.hasNext()) {
            RtfElement rtfElement = (RtfElement)iterator.next();
            if (rtfElement.isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

