/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;

final class FieldInfos {
    private Vector byNumber = new Vector();
    private Hashtable byName = new Hashtable();

    FieldInfos() {
        this.add("", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfos(Directory d, String name) throws IOException {
        InputStream input = d.openFile(name);
        try {
            this.read(input);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            input.close();
            throw throwable;
        }
        input.close();
    }

    final void add(Document doc) {
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            Field field = (Field)fields.nextElement();
            this.add(field.name(), field.isIndexed());
        }
    }

    final void add(Collection names, boolean isIndexed) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            this.add((String)i.next(), isIndexed);
        }
    }

    final void add(String name, boolean isIndexed) {
        FieldInfo fi = this.fieldInfo(name);
        if (fi == null) {
            this.addInternal(name, isIndexed);
        } else if (fi.isIndexed != isIndexed) {
            fi.isIndexed = true;
        }
    }

    private final void addInternal(String name, boolean isIndexed) {
        FieldInfo fi = new FieldInfo(name, isIndexed, this.byNumber.size());
        this.byNumber.addElement(fi);
        this.byName.put(name, fi);
    }

    final int fieldNumber(String fieldName) {
        FieldInfo fi = this.fieldInfo(fieldName);
        if (fi != null) {
            return fi.number;
        }
        return -1;
    }

    final FieldInfo fieldInfo(String fieldName) {
        return (FieldInfo)this.byName.get(fieldName);
    }

    final String fieldName(int fieldNumber) {
        return this.fieldInfo((int)fieldNumber).name;
    }

    final FieldInfo fieldInfo(int fieldNumber) {
        return (FieldInfo)this.byNumber.elementAt(fieldNumber);
    }

    final int size() {
        return this.byNumber.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void write(Directory d, String name) throws IOException {
        OutputStream output = d.createFile(name);
        try {
            this.write(output);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            output.close();
            throw throwable;
        }
        output.close();
    }

    final void write(OutputStream output) throws IOException {
        output.writeVInt(this.size());
        int i = 0;
        while (i < this.size()) {
            FieldInfo fi = this.fieldInfo(i);
            output.writeString(fi.name);
            output.writeByte((byte)(fi.isIndexed ? 1 : 0));
            ++i;
        }
    }

    private final void read(InputStream input) throws IOException {
        int size = input.readVInt();
        int i = 0;
        while (i < size) {
            this.addInternal(input.readString().intern(), input.readByte() != 0);
            ++i;
        }
    }
}

