/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.Attribute;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.CheckAttribs;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Report;

public class CheckAttribsImpl {
    private static CheckAttribs _checkHTML = new CheckHTML();
    private static CheckAttribs _checkSCRIPT = new CheckSCRIPT();
    private static CheckAttribs _checkTABLE = new CheckTABLE();
    private static CheckAttribs _checkCaption = new CheckCaption();
    private static CheckAttribs _checkIMG = new CheckIMG();
    private static CheckAttribs _checkAREA = new CheckAREA();
    private static CheckAttribs _checkAnchor = new CheckAnchor();
    private static CheckAttribs _checkMap = new CheckMap();
    private static CheckAttribs _checkStyle = new CheckSTYLE();
    private static CheckAttribs _checkTableCell = new CheckTableCell();
    private static CheckAttribs _checkLINK = new CheckLINK();
    private static CheckAttribs _checkHR = new CheckHR();

    public static CheckAttribs getCheckHTML() {
        return _checkHTML;
    }

    public static CheckAttribs getCheckSCRIPT() {
        return _checkSCRIPT;
    }

    public static CheckAttribs getCheckTABLE() {
        return _checkTABLE;
    }

    public static CheckAttribs getCheckCaption() {
        return _checkCaption;
    }

    public static CheckAttribs getCheckIMG() {
        return _checkIMG;
    }

    public static CheckAttribs getCheckAREA() {
        return _checkAREA;
    }

    public static CheckAttribs getCheckAnchor() {
        return _checkAnchor;
    }

    public static CheckAttribs getCheckMap() {
        return _checkMap;
    }

    public static CheckAttribs getCheckSTYLE() {
        return _checkStyle;
    }

    public static CheckAttribs getCheckTableCell() {
        return _checkTableCell;
    }

    public static CheckAttribs getCheckLINK() {
        return _checkLINK;
    }

    public static CheckAttribs getCheckHR() {
        return _checkHR;
    }

    public static class CheckLINK
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            AttVal attVal;
            AttVal attVal2 = node.getAttrByName("rel");
            node.checkUniqueAttributes(lexer);
            if (attVal2 != null && attVal2.value != null && attVal2.value.equals("stylesheet") && (attVal = node.getAttrByName("type")) == null) {
                Report.attrError(lexer, node, "type", (short)2);
                node.addAttribute("type", "text/css");
            }
        }
    }

    public static class CheckTableCell
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            if (node.getAttrByName("width") != null || node.getAttrByName("height") != null) {
                lexer.versions = (short)(lexer.versions & 0xFFFFFFFB);
            }
        }
    }

    public static class CheckSTYLE
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            AttVal attVal = node.getAttrByName("type");
            node.checkUniqueAttributes(lexer);
            if (attVal == null) {
                Report.attrError(lexer, node, "type", (short)2);
                node.addAttribute("type", "text/css");
            }
        }
    }

    public static class CheckMap
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            lexer.fixId(node);
        }
    }

    public static class CheckAnchor
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            lexer.fixId(node);
        }
    }

    public static class CheckAREA
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            boolean bl = false;
            boolean bl2 = false;
            node.checkUniqueAttributes(lexer);
            AttVal attVal = node.attributes;
            while (attVal != null) {
                Attribute attribute = attVal.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrAlt) {
                    bl = true;
                } else if (attribute == AttributeTable.attrHref) {
                    bl2 = true;
                }
                attVal = attVal.next;
            }
            if (!bl) {
                lexer.badAccess = (short)(lexer.badAccess | 2);
                Report.attrError(lexer, node, "alt", (short)2);
            }
            if (!bl2) {
                Report.attrError(lexer, node, "href", (short)2);
            }
        }
    }

    public static class CheckIMG
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            node.checkUniqueAttributes(lexer);
            AttVal attVal = node.attributes;
            while (attVal != null) {
                Attribute attribute = attVal.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrAlt) {
                    bl = true;
                } else if (attribute == AttributeTable.attrSrc) {
                    bl2 = true;
                } else if (attribute == AttributeTable.attrUsemap) {
                    bl3 = true;
                } else if (attribute == AttributeTable.attrIsmap) {
                    bl4 = true;
                } else if (attribute == AttributeTable.attrDatafld) {
                    bl5 = true;
                } else if (attribute == AttributeTable.attrWidth || attribute == AttributeTable.attrHeight) {
                    lexer.versions = (short)(lexer.versions & 0xFFFFFFFE);
                }
                attVal = attVal.next;
            }
            if (!bl) {
                lexer.badAccess = (short)(lexer.badAccess | 1);
                Report.attrError(lexer, node, "alt", (short)2);
                if (lexer.configuration.altText != null) {
                    node.addAttribute("alt", lexer.configuration.altText);
                }
            }
            if (!bl2 && !bl5) {
                Report.attrError(lexer, node, "src", (short)2);
            }
            if (bl4 && !bl3) {
                Report.attrError(lexer, node, "ismap", (short)8);
            }
        }
    }

    public static class CheckHR
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            if (node.getAttrByName("src") != null) {
                Report.attrError(lexer, node, "src", (short)6);
            }
        }
    }

    public static class CheckCaption
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            String string = null;
            node.checkUniqueAttributes(lexer);
            AttVal attVal = node.attributes;
            while (attVal != null) {
                if (Lexer.wstrcasecmp(attVal.attribute, "align") == 0) {
                    string = attVal.value;
                    break;
                }
                attVal = attVal.next;
            }
            if (string != null) {
                if (Lexer.wstrcasecmp(string, "left") == 0 || Lexer.wstrcasecmp(string, "right") == 0) {
                    lexer.versions = (short)(lexer.versions & 0x18);
                } else if (Lexer.wstrcasecmp(string, "top") == 0 || Lexer.wstrcasecmp(string, "bottom") == 0) {
                    lexer.versions = (short)(lexer.versions & 0x1E);
                } else {
                    Report.attrError(lexer, node, string, (short)4);
                }
            }
        }
    }

    public static class CheckTABLE
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            boolean bl = false;
            node.checkUniqueAttributes(lexer);
            AttVal attVal = node.attributes;
            while (attVal != null) {
                Attribute attribute = attVal.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrSummary) {
                    bl = true;
                }
                attVal = attVal.next;
            }
            if (!bl && lexer.doctype != 1 && lexer.doctype != 2) {
                lexer.badAccess = (short)(lexer.badAccess | 4);
                Report.attrError(lexer, node, "summary", (short)2);
            }
            if (lexer.configuration.XmlOut && (attVal = node.getAttrByName("border")) != null && attVal.value == null) {
                attVal.value = "1";
            }
        }
    }

    public static class CheckSCRIPT
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            AttVal attVal = node.getAttrByName("language");
            AttVal attVal2 = node.getAttrByName("type");
            if (attVal2 == null) {
                Report.attrError(lexer, node, "type", (short)2);
                if (attVal != null) {
                    String string = attVal.value;
                    if (string.length() > 10) {
                        string = string.substring(0, 10);
                    }
                    if (Lexer.wstrcasecmp(string, "javascript") == 0 || Lexer.wstrcasecmp(string, "jscript") == 0) {
                        node.addAttribute("type", "text/javascript");
                    }
                } else {
                    node.addAttribute("type", "text/javascript");
                }
            }
        }
    }

    public static class CheckHTML
    implements CheckAttribs {
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            AttVal attVal = node.attributes;
            while (attVal != null) {
                Attribute attribute = attVal.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrXmlns) {
                    lexer.isvoyager = true;
                }
                attVal = attVal.next;
            }
        }
    }
}

