/*
 * Decompiled with CFR 0.152.
 */
package luke;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import luke.BrowserLauncher;
import luke.HighFreqTerms;
import luke.PersistentStringList;
import luke.TermInfo;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import thinlet.FrameLauncher;
import thinlet.Thinlet;

public class Luke
extends Thinlet
implements ClipboardOwner {
    private PersistentStringList mruList = new PersistentStringList(new File(String.valueOf(HOME_DIR) + SEP_CHAR + ".luke"), "mru", 10);
    private FSDirectory dir = null;
    private String pName = null;
    private IndexReader ir = null;
    private Collection fn = null;
    private String[] idxFields = null;
    private Object error = null;
    private Object statmsg = null;
    private Analyzer stdAnalyzer = new StandardAnalyzer();
    private Analyzer analyzer = null;
    private QueryParser qp = null;
    private boolean readOnly = false;
    private boolean useCompound = false;
    private static final String MSG_NOINDEX = "FAILED: No index, or index is closed. Reopen it.";
    private static final String MSG_READONLY = "FAILED: Read-Only index.";
    private static final String PROP_NAME = ".luke";
    private static final String HOME_DIR = System.getProperty("user.home");
    private static final String SEP_CHAR = System.getProperty("file.separator");
    private DecimalFormat df = new DecimalFormat("0.0000");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Luke() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setColors(15526360, 0, 16119024, 9542554, 0xB0B0B0, 0xEDEDED, 0xB9B9B9, 16746906, 0xC5C5DD);
        this.addComponent(this, "luke.xml", null, null);
        this.error = this.addComponent(null, "error.xml", null, null);
        this.statmsg = this.find("statmsg");
        this.actionOpen();
    }

    private void showStatus(final String msg) {
        Thread thr = new Thread(){

            public void run() {
                Luke.this.setString(Luke.this.statmsg, "text", msg);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Luke.this.setString(Luke.this.statmsg, "text", "");
            }
        };
        thr.start();
    }

    public Object addComponent(Object parent, String compView, String handlerStr, Object[] argv) {
        Object res = null;
        Object handler = null;
        try {
            if (handlerStr != null) {
                if (argv == null) {
                    Class<?> clazz = Class.forName(handlerStr);
                    Class[] classArray = new Class[1];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("thinlet.Thinlet");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    handler = clazz.getConstructor(classArray).newInstance(this);
                } else {
                    Class<?> clazz = Class.forName(handlerStr);
                    Class[] classArray = new Class[2];
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("thinlet.Thinlet");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz3;
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("[Ljava.lang.Object;");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz4;
                    handler = clazz.getConstructor(classArray).newInstance(this, argv);
                }
            }
            res = handler != null ? this.parse(compView, handler) : this.parse(compView);
            if (parent != null) {
                if (parent instanceof Thinlet) {
                    this.add(res);
                } else {
                    this.add(parent, res);
                }
            }
            return res;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.errorMsg(exc.getMessage());
            return null;
        }
    }

    public void errorMsg(String msg) {
        System.out.println(msg);
        Object fMsg = this.find(this.error, "msg");
        this.setString(fMsg, "text", msg);
        this.add(this.error);
    }

    public void actionOpen() {
        this.addComponent(this, "lukeinit.xml", null, null);
    }

    public void openBrowse(Object path) {
        JFileChooser fd = new JFileChooser();
        fd.setDialogType(0);
        fd.setDialogTitle("Select Index directory");
        fd.setFileSelectionMode(2);
        fd.setFileHidingEnabled(false);
        int res = fd.showOpenDialog(this);
        File iDir = null;
        if (res == 0) {
            iDir = fd.getSelectedFile();
        }
        if (iDir != null && iDir.exists()) {
            if (!iDir.isDirectory()) {
                iDir = iDir.getParentFile();
            }
            this.setString(path, "text", iDir.toString());
        }
    }

    public void setupInit(Object dialog) {
        Object path = this.find(dialog, "path");
        this.syncMRU(path);
    }

    public void openOk(Object dialog) {
        Object path = this.find(dialog, "path");
        this.pName = this.getString(path, "text").trim();
        boolean force = this.getBoolean(this.find(dialog, "force"), "selected");
        if (this.pName == null || this.pName.trim().equals("") || !IndexReader.indexExists((String)this.pName)) {
            this.errorMsg("Invalid path, or not a Lucene index.");
            return;
        }
        this.readOnly = this.getBoolean(this.find(dialog, "ro"), "selected");
        this.remove(dialog);
        this.removeAll();
        this.addComponent(this, "luke.xml", null, null);
        if (this.dir != null) {
            try {
                if (this.ir != null) {
                    this.ir.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mruList.add(this.pName);
            this.syncMRU(path);
            this.dir = FSDirectory.getDirectory((String)this.pName, (boolean)false);
            if (IndexReader.isLocked((Directory)this.dir)) {
                if (this.readOnly) {
                    this.showStatus("Index is locked and Read-Only. Open for read-write and 'Force unlock'.");
                    this.dir.close();
                    return;
                }
                if (force) {
                    IndexReader.unlock((Directory)this.dir);
                } else {
                    this.showStatus("Index is locked. Try 'Force unlock' when opening.");
                    this.dir.close();
                    return;
                }
            }
            this.showFiles(this.dir);
            Object fileSize = this.find("iFileSize");
            BigInteger totalFileSize = this.calcTotalFileSize(this.pName, this.dir);
            this.setString(fileSize, "text", String.valueOf(this.normalizeSize(totalFileSize)) + this.normalizeUnit(totalFileSize));
            System.out.println(this.dir);
            this.ir = IndexReader.open((Directory)this.dir);
            this.initOverview();
            this.showStatus("Index successfully open.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg(e.getMessage());
            return;
        }
    }

    private void initOverview() {
        try {
            Object pOver = this.find("pOver");
            Object iName = this.find("idx");
            this.setString(iName, "text", String.valueOf(this.pName) + (this.readOnly ? " (R)" : ""));
            iName = this.find(pOver, "iName");
            this.setString(iName, "text", String.valueOf(this.pName) + (this.readOnly ? " (Read-Only)" : ""));
            Object iDocs = this.find(pOver, "iDocs");
            String numdocs = String.valueOf(this.ir.numDocs());
            this.setString(iDocs, "text", numdocs);
            iDocs = this.find("iDocs1");
            this.setString(iDocs, "text", String.valueOf(this.ir.numDocs() - 1));
            Object iFields = this.find(pOver, "iFields");
            this.fn = this.ir.getFieldNames();
            this.idxFields = new String[this.fn.size()];
            this.setString(iFields, "text", String.valueOf(this.fn.size()));
            Object fList = this.find(pOver, "fList");
            Object defFld = this.find("defFld");
            Object fCombo = this.find("fCombo");
            Iterator it = this.fn.iterator();
            int i = 0;
            this.removeAll(fList);
            this.removeAll(fCombo);
            while (it.hasNext()) {
                Object item = Thinlet.create("item");
                this.add(fList, item);
                String name = (String)it.next();
                this.setString(item, "text", "<" + name + ">");
                this.putProperty(item, "fName", name);
                item = Thinlet.create("choice");
                this.add(defFld, item);
                this.setString(item, "text", name);
                item = Thinlet.create("choice");
                this.add(fCombo, item);
                this.setString(item, "text", name);
                this.putProperty(item, "fName", name);
                this.idxFields[i++] = name;
            }
            this.setString(defFld, "text", this.idxFields[0]);
            Object iTerms = this.find(pOver, "iTerms");
            TermEnum te = this.ir.terms();
            int cnt = 0;
            while (te.next()) {
                ++cnt;
            }
            te.close();
            this.setString(iTerms, "text", String.valueOf(cnt));
            Object iMod = this.find(pOver, "iMod");
            this.setString(iMod, "text", new Date(IndexReader.lastModified((Directory)this.dir)).toString());
            Object iVer = this.find(pOver, "iVer");
            this.setString(iVer, "text", String.valueOf(IndexReader.getCurrentVersion((Directory)this.dir)));
            Object iDel = this.find(pOver, "iDel");
            this.setString(iDel, "text", this.ir.hasDeletions() ? "Yes" : "No");
            this.setString(this.find("defFld"), "text", this.idxFields[0]);
            Object header = Thinlet.get(this.find("sTable"), "header");
            Object col = Thinlet.get(header, ":comp");
            Object tail = col = Thinlet.get(col, ":next");
            Object next = Thinlet.get(col, ":next");
            while (next != null) {
                Thinlet.set(col, ":next", null);
                col = next;
                next = Thinlet.get(col, ":next");
            }
            int j = 0;
            while (j < this.idxFields.length) {
                Object c = Thinlet.create("column");
                this.setString(c, "text", this.idxFields[j]);
                Thinlet.set(tail, ":next", c);
                tail = c;
                ++j;
            }
            this.actionTopTerms(this.find("nTerms"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg(e.getMessage());
        }
    }

    public void showFiles(FSDirectory dir) throws Exception {
        String[] files = dir.list();
        Object filesTable = this.find("filesTable");
        this.removeAll(filesTable);
        int i = 0;
        while (i < files.length) {
            String filename = this.pName.endsWith(SEP_CHAR) ? this.pName : String.valueOf(this.pName) + SEP_CHAR;
            File file = new File(String.valueOf(filename) + files[i]);
            Object row = Thinlet.create("row");
            Object nameCell = Thinlet.create("cell");
            this.setString(nameCell, "text", files[i]);
            this.add(row, nameCell);
            Object sizeCell = Thinlet.create("cell");
            this.setString(sizeCell, "text", this.normalizeSize(file.length()));
            this.add(row, sizeCell);
            Object unitCell = Thinlet.create("cell");
            this.setString(unitCell, "text", this.normalizeUnit(file.length()));
            this.add(row, unitCell);
            this.add(filesTable, row);
            ++i;
        }
    }

    private void syncMRU(Object path) {
        this.removeAll(path);
        Iterator iter = this.mruList.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            Object choice = Thinlet.create("choice");
            this.setString(choice, "text", element);
            this.add(path, choice);
        }
    }

    private String normalizeUnit(long len) {
        if (len == 1L) {
            return " byte";
        }
        if (len < 1024L) {
            return " bytes";
        }
        if (len < 51200000L) {
            return " kB";
        }
        return " MB";
    }

    private String normalizeUnit(BigInteger len) {
        if (len.compareTo(new BigInteger("1")) == 0) {
            return " byte";
        }
        if (len.compareTo(new BigInteger("1024")) == -1) {
            return " bytes";
        }
        if (len.compareTo(new BigInteger("51200000")) == -1) {
            return " kB";
        }
        return " MB";
    }

    private String normalizeSize(BigInteger len) {
        if (len.compareTo(new BigInteger("1")) == 0) {
            return len.toString();
        }
        if (len.compareTo(new BigInteger("1024")) == -1) {
            return len.toString();
        }
        if (len.compareTo(new BigInteger("51200000")) == -1) {
            return len.divide(new BigInteger("1024")).toString();
        }
        return len.divide(new BigInteger("102400")).toString();
    }

    private BigInteger calcTotalFileSize(String path, FSDirectory fsdir) {
        BigInteger totalFileSize = new BigInteger("0");
        try {
            String[] files = fsdir.list();
            int i = 0;
            while (i < files.length) {
                String filename = this.pName.endsWith(SEP_CHAR) ? this.pName : String.valueOf(this.pName) + SEP_CHAR;
                File file = new File(String.valueOf(filename) + files[i]);
                totalFileSize = totalFileSize.add(new BigInteger(String.valueOf(file.length())));
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return totalFileSize;
    }

    private String normalizeSize(long len) {
        if (len == 1L) {
            return String.valueOf(len);
        }
        if (len < 1024L) {
            return String.valueOf(len);
        }
        if (len < 51200000L) {
            return String.valueOf(len / 1024L);
        }
        return String.valueOf(len / 102400L);
    }

    public void actionTopTerms(Object nTerms) {
        int ndoc = this.getInteger(nTerms, "value");
        System.out.println("nTerms=" + ndoc);
        Object[] fields = this.getSelectedItems(this.find("fList"));
        String[] flds = null;
        if (fields == null || fields.length == 0) {
            flds = this.idxFields;
        } else {
            flds = new String[fields.length];
            int i = 0;
            while (i < fields.length) {
                flds[i] = (String)this.getProperty(fields[i], "fName");
                System.out.println(" - " + flds[i]);
                ++i;
            }
        }
        try {
            TermInfo[] tis = HighFreqTerms.getHighFreqTerms((Directory)this.dir, null, ndoc, flds);
            Object table = this.find("tTable");
            this.removeAll(table);
            if (tis == null || tis.length == 0) {
                System.out.println("tis=" + tis + " (no results)");
                Object row = Thinlet.create("row");
                Object cell = Thinlet.create("cell");
                this.add(row, cell);
                cell = Thinlet.create("cell");
                this.add(row, cell);
                cell = Thinlet.create("cell");
                this.add(row, cell);
                cell = Thinlet.create("cell");
                this.setBoolean(cell, "enabled", false);
                this.setString(cell, "text", "No Results");
                this.add(row, cell);
                this.add(table, row);
                return;
            }
            int i = 0;
            while (i < tis.length) {
                Object row = Thinlet.create("row");
                this.add(table, row);
                this.putProperty(row, "term", tis[i].term);
                Object cell = Thinlet.create("cell");
                this.setChoice(cell, "alignment", "right");
                this.setString(cell, "text", String.valueOf(i + 1));
                this.add(row, cell);
                cell = Thinlet.create("cell");
                this.setChoice(cell, "alignment", "right");
                this.setString(cell, "text", String.valueOf(String.valueOf(tis[i].docFreq)) + "  ");
                this.add(row, cell);
                cell = Thinlet.create("cell");
                this.setString(cell, "text", " <" + tis[i].term.field() + "> ");
                this.add(row, cell);
                cell = Thinlet.create("cell");
                this.setString(cell, "text", "  " + tis[i].term.text());
                this.add(row, cell);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg(e.getMessage());
        }
    }

    public void browseTermDocs(Object tTable) {
        Object row = this.getSelectedItem(tTable);
        if (row == null) {
            return;
        }
        Term t = (Term)this.getProperty(row, "term");
        if (t == null) {
            return;
        }
        Object tabpane = this.find("maintpane");
        this.setInteger(tabpane, "selected", 1);
        this._showTerm(this.find("fCombo"), this.find("fText"), t);
        this.repaint();
    }

    public void showTermDocs(Object tTable) {
        Object row = this.getSelectedItem(tTable);
        if (row == null) {
            return;
        }
        Term t = (Term)this.getProperty(row, "term");
        if (t == null) {
            return;
        }
        Object tabpane = this.find("maintpane");
        this.setInteger(tabpane, "selected", 2);
        Object qField = this.find("qField");
        this.setString(qField, "text", String.valueOf(t.field()) + ":" + t.text());
        this.search(qField);
        this.repaint();
    }

    public void actionUseCompound(Object check) {
        this.useCompound = this.getBoolean(check, "selected");
    }

    public void actionUndelete() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.ir.undeleteAll();
            this.initOverview();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg(e.getMessage());
        }
    }

    public void actionOptimize() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.ir.close();
            IndexWriter iw = new IndexWriter((Directory)this.dir, (Analyzer)new WhitespaceAnalyzer(), false);
            iw.setUseCompoundFile(this.useCompound);
            BigInteger startSize = this.calcTotalFileSize(this.pName, this.dir);
            long startTime = System.currentTimeMillis();
            iw.optimize();
            long endTime = System.currentTimeMillis();
            BigInteger endSize = this.calcTotalFileSize(this.pName, this.dir);
            BigInteger deltaSize = startSize.subtract(endSize);
            String sign = deltaSize.compareTo(new BigInteger("0")) < 0 ? " Increased " : " Reduced ";
            String sizeMsg = String.valueOf(sign) + this.normalizeSize(deltaSize.abs()) + this.normalizeUnit(deltaSize.abs());
            String timeMsg = String.valueOf(String.valueOf(endTime - startTime)) + " ms";
            this.showStatus(String.valueOf(sizeMsg) + " in " + timeMsg);
            this.showFiles(this.dir);
            iw.close();
            this.ir = IndexReader.open((Directory)this.dir);
            this.initOverview();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    public void showPrevDoc(Object docNum) {
        this._showDoc(docNum, -1);
    }

    public void showNextDoc(Object docNum) {
        this._showDoc(docNum, 1);
    }

    public void showDoc(Object docNum) {
        this._showDoc(docNum, 0);
    }

    private void _showDoc(Object docNum, int incr) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        String num = this.getString(docNum, "text");
        if (num.trim().equals("")) {
            num = String.valueOf(-incr);
        }
        try {
            int iNum = Integer.parseInt(num);
            if ((iNum += incr) < 0 || iNum >= this.ir.numDocs()) {
                this.showStatus("Document number outside valid range.");
                return;
            }
            Document doc = null;
            if (!this.ir.isDeleted(iNum)) {
                doc = this.ir.document(iNum);
            } else {
                this.showStatus("This document has been deleted and is not available.");
            }
            this._showDocFields(iNum, doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    private void _showDocFields(int docid, Document doc) {
        Object table = this.find("docTable");
        this.setString(this.find("docNum"), "text", String.valueOf(docid));
        this.setString(this.find("docNum1"), "text", String.valueOf(docid));
        this.removeAll(table);
        this.putProperty(table, "doc", doc);
        if (doc == null) {
            return;
        }
        Enumeration e = doc.fields();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            Object row = Thinlet.create("row");
            this.add(table, row);
            this.putProperty(row, "field", f);
            Object cell = Thinlet.create("cell");
            this.setString(cell, "text", "<" + f.name() + ">");
            this.add(row, cell);
            cell = Thinlet.create("cell");
            if (f.isIndexed()) {
                this.setString(cell, "text", "+");
            }
            this.add(row, cell);
            cell = Thinlet.create("cell");
            if (f.isTokenized()) {
                this.setString(cell, "text", "+");
            }
            this.add(row, cell);
            cell = Thinlet.create("cell");
            if (f.isStored()) {
                this.setString(cell, "text", "+");
            }
            this.add(row, cell);
            cell = Thinlet.create("cell");
            this.setString(cell, "text", String.valueOf(f.getBoost()));
            this.add(row, cell);
            cell = Thinlet.create("cell");
            this.setString(cell, "text", f.stringValue());
            this.add(row, cell);
        }
        this.doLayout(table);
    }

    public void clipCopyFields(Object table) {
        Object[] rows = this.getSelectedItems(table);
        if (rows == null || rows.length == 0) {
            return;
        }
        Document doc = (Document)this.getProperty(table, "doc");
        if (doc == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < rows.length) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(((Field)this.getProperty(rows[i], "field")).toString());
            ++i;
        }
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    public void clipCopyDoc(Object table) {
        Document doc = (Document)this.getProperty(table, "doc");
        if (doc == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Object[] rows = this.getItems(table);
        int i = 0;
        while (i < rows.length) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(((Field)this.getProperty(rows[i], "field")).toString());
            ++i;
        }
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    public void showFirstTerm(Object fCombo, Object fText) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermEnum te = this.ir.terms();
            te.next();
            Term t = te.term();
            this._showTerm(fCombo, fText, t);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    public void showNextTerm(Object fCombo, Object fText) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            String text = this.getString(fText, "text");
            String fld = this.getString(fCombo, "text");
            TermEnum te = null;
            te = text == null || text.trim().equals("") ? this.ir.terms() : this.ir.terms(new Term(fld, text));
            te.next();
            Term t = te.term();
            this._showTerm(fCombo, fText, t);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    public void showTerm(Object fCombo, Object fText) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            String text = this.getString(fText, "text");
            String fld = this.getString(fCombo, "text");
            if (text == null || text.trim().equals("")) {
                return;
            }
            Term t = new Term(fld, text);
            this._showTerm(fCombo, fText, t);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    private void _showTerm(Object fCombo, Object fText, Term t) {
        if (t == null) {
            this.showStatus("No terms?!");
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Object[] choices = this.getItems(fCombo);
        int i = 0;
        while (i < choices.length) {
            if (t.field().equals(this.getString(choices[i], "text"))) {
                this.setInteger(fCombo, "selected", i);
                break;
            }
            ++i;
        }
        this.setString(fText, "text", t.text());
        this.putProperty(fText, "term", t);
        this.putProperty(fText, "td", null);
        this.setString(this.find("tdNum"), "text", "?");
        this.setString(this.find("tFreq"), "text", "?");
        Object dFreq = this.find("dFreq");
        try {
            int freq = this.ir.docFreq(t);
            this.setString(dFreq, "text", String.valueOf(freq));
            dFreq = this.find("tdMax");
            this.setString(dFreq, "text", String.valueOf(freq));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
            this.setString(dFreq, "text", "?");
        }
    }

    public void showFirstTermDoc(Object fText) {
        Term t = (Term)this.getProperty(fText, "term");
        if (t == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermDocs td = this.ir.termDocs(t);
            td.next();
            this.setString(this.find("tdNum"), "text", "1");
            this.putProperty(fText, "td", td);
            this._showTermDoc(fText, td);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    public void showNextTermDoc(Object fText) {
        Term t = (Term)this.getProperty(fText, "term");
        if (t == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            TermDocs td = (TermDocs)this.getProperty(fText, "td");
            if (td == null) {
                this.showFirstTermDoc(fText);
                return;
            }
            if (!td.next()) {
                return;
            }
            Object tdNum = this.find("tdNum");
            String sCnt = this.getString(tdNum, "text");
            int cnt = 1;
            try {
                cnt = Integer.parseInt(sCnt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setString(tdNum, "text", String.valueOf(cnt + 1));
            this._showTermDoc(fText, td);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public void showAllTermDoc(Object fText) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 220->224)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private QueryParser createQueryParser() {
        String sAnal = this.getString(this.find("cbType"), "text");
        if (sAnal.trim().equals("")) {
            sAnal = "org.apache.lucene.analysis.standard.StandardAnalyzer";
            this.setString(this.find("cbType"), "text", sAnal);
        }
        try {
            this.analyzer = (Analyzer)Class.forName(sAnal).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg("Analyzer '" + sAnal + "' error: " + e.getMessage() + ". Using StandardAnalyzer.");
            this.analyzer = this.stdAnalyzer;
        }
        String defField = this.getString(this.find("defFld"), "text");
        if (defField == null || defField.trim().equals("")) {
            defField = this.idxFields[0];
            this.setString(this.find("defFld"), "text", defField);
        }
        return new QueryParser(defField, this.analyzer);
    }

    public void showParsed() {
        QueryParser qp = this.createQueryParser();
        Object qField = this.find("qField");
        Object qFieldParsed = this.find("qFieldParsed");
        String queryS = this.getString(qField, "text");
        if (queryS.trim().equals("")) {
            this.setBoolean(qFieldParsed, "enabled", false);
            this.setString(qFieldParsed, "text", "<Empty query>");
            return;
        }
        this.setBoolean(qFieldParsed, "enabled", true);
        try {
            Query q = qp.parse(queryS);
            this.setString(qFieldParsed, "text", q.toString());
        }
        catch (Throwable t) {
            this.setString(qFieldParsed, "text", t.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public void search(Object qField) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 172->176)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _search(Query q, IndexSearcher is, Object sTable) throws Exception {
        long startTime = System.currentTimeMillis();
        Hits hits = is.search(q);
        long endTime = System.currentTimeMillis();
        this.showStatus(String.valueOf(endTime - startTime) + " ms");
        if (hits == null || hits.length() == 0) {
            Object row = Thinlet.create("row");
            Object cell = Thinlet.create("cell");
            this.add(sTable, row);
            this.add(row, cell);
            cell = Thinlet.create("cell");
            this.add(row, cell);
            cell = Thinlet.create("cell");
            this.setString(cell, "text", "No Results");
            this.setBoolean(cell, "enabled", false);
            this.add(row, cell);
            this.setString(this.find("resNum"), "text", "0");
            return;
        }
        this.setString(this.find("resNum"), "text", String.valueOf(hits.length()));
        int i = 0;
        while (i < hits.length()) {
            Object row = Thinlet.create("row");
            Object cell = Thinlet.create("cell");
            this.add(sTable, row);
            this.setString(cell, "text", String.valueOf((double)Math.round(1000.0f * hits.score(i)) / 10.0));
            this.add(row, cell);
            cell = Thinlet.create("cell");
            this.setString(cell, "text", String.valueOf(hits.id(i)));
            this.add(row, cell);
            Document doc = hits.doc(i);
            this.putProperty(row, "docid", new Integer(hits.id(i)));
            int j = 0;
            while (j < this.idxFields.length) {
                cell = Thinlet.create("cell");
                this.setString(cell, "text", doc.get(this.idxFields[j]));
                this.add(row, cell);
                ++j;
            }
            ++i;
        }
        this.putProperty(sTable, "query", q);
    }

    public void explainResult(Object sTable) {
        Object row = this.getSelectedItem(sTable);
        if (row == null) {
            return;
        }
        Integer docid = (Integer)this.getProperty(row, "docid");
        if (docid == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Query q = (Query)this.getProperty(sTable, "query");
        if (q == null) {
            return;
        }
        try {
            IndexSearcher is = new IndexSearcher((Directory)this.dir);
            Explanation expl = is.explain(q, docid.intValue());
            Object dialog = this.addComponent(null, "explain.xml", null, null);
            Object eTree = this.find(dialog, "eTree");
            this.addNode(eTree, expl);
            this.add(dialog);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg(e.getMessage());
        }
    }

    private void addNode(Object tree, Explanation expl) {
        Explanation[] kids;
        Object node = Thinlet.create("node");
        this.setString(node, "text", String.valueOf(this.df.format(expl.getValue())) + "  " + expl.getDescription());
        this.add(tree, node);
        if (Thinlet.getClass(tree) == "tree") {
            this.setFont(node, this.getFont().deriveFont(1));
        }
        if ((kids = expl.getDetails()) != null && kids.length > 0) {
            int i = 0;
            while (i < kids.length) {
                this.addNode(node, kids[i]);
                ++i;
            }
        }
    }

    public void gotoDoc(Object sTable) {
        Object row = this.getSelectedItem(sTable);
        if (row == null) {
            return;
        }
        Integer docid = (Integer)this.getProperty(row, "docid");
        if (docid == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Document doc = null;
        try {
            doc = this.ir.document(docid.intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
            return;
        }
        this._showDocFields(docid, doc);
        Object tabpane = this.find("maintpane");
        this.setInteger(tabpane, "selected", 1);
        this.repaint();
    }

    private void _showTermDoc(Object fText, TermDocs td) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            Document doc = this.ir.document(td.doc());
            this.setString(this.find("docNum"), "text", String.valueOf(td.doc()));
            this.setString(this.find("tFreq"), "text", String.valueOf(td.freq()));
            this._showDocFields(td.doc(), doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    public void deleteTermDoc(Object fText) {
        Term t = (Term)this.getProperty(fText, "term");
        if (t == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            this.showNextTerm(this.find("fCombo"), fText);
            this.ir.delete(t);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
        this.initOverview();
    }

    public void deleteDoc(Object docNum) {
        int docid = 0;
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            docid = Integer.parseInt(this.getString(docNum, "text"));
            this.showNextDoc(docNum);
            this.ir.delete(docid);
            this.initOverview();
        }
        catch (Exception e) {
            this.showStatus(e.getMessage());
            e.printStackTrace();
        }
    }

    public void deleteDocList(Object sTable) {
        Object[] rows = this.getSelectedItems(sTable);
        if (rows == null || rows.length == 0) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        int i = 0;
        while (i < rows.length) {
            block7: {
                Integer docId = (Integer)this.getProperty(rows[i], "docid");
                if (docId != null) {
                    try {
                        this.ir.delete(docId.intValue());
                    }
                    catch (Exception e) {
                        break block7;
                    }
                    this.remove(rows[i]);
                }
            }
            ++i;
        }
        this.initOverview();
    }

    public void actionAbout() {
        Object about = this.addComponent(this, "about.xml", null, null);
        this.requestFocus(this.find(about, "bOk"));
    }

    public boolean destroy() {
        if (this.ir != null) {
            try {
                this.ir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dir != null) {
            try {
                this.dir.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.destroy();
    }

    public void actionExit() {
        this.destroy();
        System.exit(0);
    }

    public void goUrl(Object url) {
        String u = (String)this.getProperty(url, "url");
        if (u == null) {
            return;
        }
        try {
            BrowserLauncher.openURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    public static void main(String[] args) {
        FrameLauncher f = new FrameLauncher("Luke - Lucene Index Browser, v 0.45 (2004-01-17)", new Luke(), 640, 400);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("luke.Luke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        f.setIconImage(toolkit.createImage(clazz.getResource("luke.gif")));
        f.start();
    }

    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }
}

