/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.NOPCacheValidity;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EncodeURLTransformer
extends AbstractTransformer
implements Configurable {
    public static final String EXCLUDE_NAME = "exclude-name";
    public static final String INCLUDE_NAME = "include-name";
    public static final String EXCLUDE_NAME_DEFAULT = "img/@src";
    public static final String INCLUDE_NAME_DEFAULT = ".*/@href|.*/@action|frame/@src";
    private String includeNameConfigure = ".*/@href|.*/@action|frame/@src";
    private String excludeNameConfigure = "img/@src";
    private ElementAttributeMatching elementAttributeMatching;
    private Response response;
    private Session session;

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        this.session = request.getSession(false);
        if (null != this.session) {
            if (request.isRequestedSessionIdFromURL() || this.session.isNew()) {
                this.response = ObjectModelHelper.getResponse(objectModel);
                String includeName = parameters.getParameter(INCLUDE_NAME, this.includeNameConfigure);
                String excludeName = parameters.getParameter(EXCLUDE_NAME, this.excludeNameConfigure);
                try {
                    this.elementAttributeMatching = new ElementAttributeMatching(includeName, excludeName);
                }
                catch (RESyntaxException reex) {
                    String message = "Cannot parse include-name: " + includeName + " " + "or exclude-name: " + excludeName + "!";
                    throw new ProcessingException(message, reex);
                }
            } else {
                this.session = null;
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String message;
        if (configuration != null) {
            Configuration child = configuration.getChild(INCLUDE_NAME);
            this.includeNameConfigure = child.getValue(INCLUDE_NAME_DEFAULT);
            child = configuration.getChild(EXCLUDE_NAME);
            this.excludeNameConfigure = child.getValue(EXCLUDE_NAME_DEFAULT);
        }
        if (this.includeNameConfigure == null) {
            message = "Configure include-name!";
            throw new ConfigurationException(message);
        }
        if (this.excludeNameConfigure == null) {
            message = "Configure exclude-name!";
            throw new ConfigurationException(message);
        }
    }

    public void recycle() {
        super.recycle();
        this.response = null;
        this.session = null;
        this.elementAttributeMatching = null;
    }

    public long generateKey() {
        if (null == this.session) {
            return 1L;
        }
        return 0L;
    }

    public CacheValidity generateValidity() {
        if (null == this.session) {
            return NOPCacheValidity.CACHE_VALIDITY;
        }
        return null;
    }

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        if (this.session != null && this.elementAttributeMatching != null) {
            String lname = name;
            if (attributes != null && attributes.getLength() > 0) {
                AttributesImpl new_attributes = new AttributesImpl(attributes);
                int i = 0;
                while (i < new_attributes.getLength()) {
                    String attr_lname = new_attributes.getLocalName(i);
                    String value = new_attributes.getValue(i);
                    if (this.elementAttributeMatching.matchesElementAttribute(lname, attr_lname)) {
                        String new_value = this.response.encodeURL(value);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("element/@attribute matches: " + name + "/@" + attr_lname);
                            this.getLogger().debug("encodeURL: " + value + " -> " + new_value);
                        }
                        new_attributes.setValue(i, new_value);
                    }
                    ++i;
                }
                this.contentHandler.startElement(uri, name, raw, new_attributes);
                return;
            }
        }
        this.contentHandler.startElement(uri, name, raw, attributes);
    }

    public class ElementAttributeMatching {
        protected RE includeNameRE;
        protected RE excludeNameRE;

        public ElementAttributeMatching(String includeName, String excludeName) throws RESyntaxException {
            this.includeNameRE = new RE(includeName, 1);
            this.excludeNameRE = new RE(excludeName, 1);
        }

        public boolean matchesElementAttribute(String element_name, String attr_name) {
            String element_attr_name = this.canonicalizeElementAttribute(element_name, attr_name);
            if (this.excludeNameRE != null && this.includeNameRE != null) {
                return !this.matchesExcludesElementAttribute(element_attr_name) && this.matchesIncludesElementAttribute(element_attr_name);
            }
            return false;
        }

        private String canonicalizeElementAttribute(String element_name, String attr_name) {
            return element_name + "/@" + attr_name;
        }

        private boolean matchesExcludesElementAttribute(String element_attr_name) {
            boolean match = this.excludeNameRE.match(element_attr_name);
            return match;
        }

        private boolean matchesIncludesElementAttribute(String element_attr_name) {
            boolean match = this.includeNameRE.match(element_attr_name);
            return match;
        }
    }
}

