/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.Handler;

public class Manager
extends AbstractLoggable
implements Component,
Configurable,
Composable,
Contextualizable,
ThreadSafe,
LogKitManageable,
Disposable {
    protected Context context;
    protected Configuration conf;
    protected ComponentManager manager;
    protected RoleManager sitemapRoles;
    protected LogKitManager sitemapLogKitManager;
    protected Class handlerClass = class$org$apache$cocoon$sitemap$Handler == null ? (class$org$apache$cocoon$sitemap$Handler = Manager.class$("org.apache.cocoon.sitemap.Handler")) : class$org$apache$cocoon$sitemap$Handler;
    static /* synthetic */ Class class$org$apache$cocoon$sitemap$Handler;

    public void setRoleManager(RoleManager roles) {
        this.sitemapRoles = roles;
    }

    public void setLogKitManager(LogKitManager logkit) {
        this.sitemapLogKitManager = logkit;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.conf = conf;
        String value = conf.getAttribute("handler-class", null);
        if (value != null) {
            try {
                this.handlerClass = Class.forName(value);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Cannot find Handler class " + value);
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public boolean invoke(Handler sitemapHandler, Environment environment, String uri_prefix, String source) throws Exception {
        this.setupProcessing(sitemapHandler, environment);
        String prefix = environment.getURIPrefix();
        String uri = environment.getURI();
        try {
            environment.changeContext(uri_prefix, source);
            boolean bl = sitemapHandler.process(environment);
            Object var9_8 = null;
            environment.setContext(prefix, uri);
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            environment.setContext(prefix, uri);
            throw throwable;
        }
    }

    public boolean invoke(Handler sitemapHandler, Environment environment, String uri_prefix, String source, StreamPipeline pipeline, EventPipeline eventPipeline) throws Exception {
        this.setupProcessing(sitemapHandler, environment);
        String prefix = environment.getURIPrefix();
        String uri = environment.getURI();
        try {
            environment.changeContext(uri_prefix, source);
            boolean bl = sitemapHandler.process(environment, pipeline, eventPipeline);
            Object var11_10 = null;
            environment.setContext(prefix, uri);
            return bl;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            environment.setContext(prefix, uri);
            throw throwable;
        }
    }

    private void setupProcessing(Handler sitemapHandler, Environment environment) throws Exception {
        if (!sitemapHandler.available() || sitemapHandler.hasChanged()) {
            sitemapHandler.regenerate(environment);
        }
        if (!sitemapHandler.available()) {
            if (sitemapHandler.getException() != null) {
                throw sitemapHandler.getException();
            }
            throw new ProcessingException("The sitemap handler's sitemap is not available. Please check logs for the exact error.");
        }
    }

    protected Handler createHandler(ComponentManager newManager, String source, boolean check_reload, boolean reload_async, long check_delay) throws Exception {
        Handler sitemapHandler = null;
        Manager manager = this;
        synchronized (manager) {
            sitemapHandler = (Handler)this.handlerClass.newInstance();
            sitemapHandler.setSourceFileName(source);
            sitemapHandler.setCheckReload(check_reload);
            sitemapHandler.setCheckDelay(check_delay);
            sitemapHandler.setLogger(this.getLogger());
            sitemapHandler.compose(newManager);
            sitemapHandler.contextualize(this.context);
            if (sitemapHandler instanceof Configurable) {
                ((Configurable)sitemapHandler).configure(this.conf);
            }
        }
        return sitemapHandler;
    }

    public void dispose() {
        this.context = null;
        this.conf = null;
        this.manager = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

