/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.IOException;
import java.io.InputStream;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ModifiableSource;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.xml.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DelayedRefreshSourceWrapper
implements Source,
ModifiableSource,
XMLizable {
    private Source source;
    private long delay;
    private long nextCheckTime = 0L;
    private long lastModified = 0L;
    private boolean isModifiableSource;

    public DelayedRefreshSourceWrapper(Source source, long delay) {
        this.source = source;
        this.delay = delay;
        this.isModifiableSource = source instanceof ModifiableSource;
    }

    public final long getLastModified() {
        if (System.currentTimeMillis() >= this.nextCheckTime) {
            this.refresh();
        }
        return this.lastModified;
    }

    public final synchronized void refresh() {
        this.nextCheckTime = System.currentTimeMillis() + this.delay;
        if (this.isModifiableSource) {
            ((ModifiableSource)this.source).refresh();
        }
        this.lastModified = this.source.getLastModified();
    }

    public final long getContentLength() {
        return this.source.getContentLength();
    }

    public final InputStream getInputStream() throws ProcessingException, IOException {
        return this.source.getInputStream();
    }

    public final InputSource getInputSource() throws ProcessingException, IOException {
        return this.source.getInputSource();
    }

    public final String getSystemId() {
        return this.source.getSystemId();
    }

    public final void recycle() {
        this.source.recycle();
    }

    public final void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
        this.source.toSAX(handler);
    }
}

