/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.xscript.XScriptManager;
import org.apache.cocoon.components.xscript.XScriptObject;
import org.apache.cocoon.components.xscript.XScriptObjectInlineXML;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.xml.sax.InputSource;

public class SOAPHelper {
    XScriptManager xscriptManager;
    URL url;
    String action = "";
    XScriptObject xscriptObject;

    public SOAPHelper(ComponentManager manager, String urlContext, String url, String action, XScriptObject xscriptObject) throws MalformedURLException, ComponentException {
        this.xscriptManager = (XScriptManager)manager.lookup("org.apache.cocoon.components.xscript.XScriptManager");
        URL context = new URL(urlContext);
        this.url = new URL(context, url);
        this.action = action;
        this.xscriptObject = xscriptObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XScriptObject invoke() throws ProcessingException {
        HttpConnection conn = null;
        try {
            try {
                if (this.action == null || this.action.equals("")) {
                    this.action = "\"\"";
                }
                String host = this.url.getHost();
                int port = this.url.getPort();
                if (System.getProperty("http.proxyHost") != null) {
                    String proxyHost = System.getProperty("http.proxyHost");
                    int proxyPort = Integer.parseInt(System.getProperty("http.proxyPort"));
                    conn = new HttpConnection(proxyHost, proxyPort, host, port);
                } else {
                    conn = new HttpConnection(host, port);
                }
                PostMethod method = new PostMethod(this.url.getFile()){

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    protected String generateRequestBody(HashMap params) {
                        try {
                            StringBuffer bodyBuffer = new StringBuffer(super.generateRequestBody(params));
                            if (SOAPHelper.this.xscriptObject instanceof XScriptObjectInlineXML) {
                                bodyBuffer.append(((XScriptObjectInlineXML)SOAPHelper.this.xscriptObject).getContent());
                                return bodyBuffer.toString();
                            }
                            InputSource saxSource = SOAPHelper.this.xscriptObject.getInputSource();
                            Reader r = null;
                            r = saxSource.getByteStream() != null ? new InputStreamReader(saxSource.getByteStream()) : saxSource.getCharacterStream();
                            try {
                                int len;
                                char[] buffer = new char[1024];
                                while ((len = r.read(buffer)) > 0) {
                                    void var6_7;
                                    bodyBuffer.append(buffer, 0, (int)var6_7);
                                }
                                Object var8_8 = null;
                                if (r == null) return bodyBuffer.toString();
                            }
                            catch (Throwable throwable) {
                                Object var8_9 = null;
                                if (r == null) throw throwable;
                                r.close();
                                throw throwable;
                            }
                            r.close();
                            return bodyBuffer.toString();
                        }
                        catch (Exception ex) {
                            return null;
                        }
                    }
                };
                method.setRequestHeader(new Header("Content-type", "text/xml; charset=\"utf-8\""));
                method.setRequestHeader(new Header("SOAPAction", this.action));
                method.setUseDisk(false);
                method.execute(new HttpState(), conn);
                String ret = method.getResponseBodyAsString();
                int startOfXML = ret.indexOf("<?xml");
                if (startOfXML == -1) {
                    throw new ProcessingException("Invalid response - no xml");
                }
                XScriptObjectInlineXML xScriptObjectInlineXML = new XScriptObjectInlineXML(this.xscriptManager, ret.substring(startOfXML));
                Object var9_10 = null;
                try {
                    if (conn == null) return xScriptObjectInlineXML;
                    conn.close();
                    return xScriptObjectInlineXML;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return xScriptObjectInlineXML;
            }
            catch (Exception ex) {
                throw new ProcessingException("Error invoking remote service: " + ex, ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {}
            catch (Exception ex) {
                throw throwable;
            }
            if (conn == null) throw throwable;
            conn.close();
            throw throwable;
        }
    }
}

