/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.Logicsheet;
import org.apache.cocoon.components.language.markup.LogicsheetCodeGenerator;
import org.apache.cocoon.components.language.markup.MarkupLanguage;
import org.apache.cocoon.components.language.markup.NamedLogicsheet;
import org.apache.cocoon.components.language.programming.ProgrammingLanguage;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.URLFactorySourceResolver;
import org.apache.cocoon.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractMarkupLanguage
extends AbstractLoggable
implements MarkupLanguage,
Composable,
Configurable,
Parameterizable,
Recyclable,
Disposable {
    private static final String FILE = "file:";
    private static final String CACHE_PREFIX = "logicsheet:";
    protected String name;
    protected HashMap languages;
    protected Store logicsheetCache;
    protected String uri;
    protected String prefix;
    protected ComponentManager manager;
    private URLFactory urlFactory;
    private URLFactorySourceResolver urlResolver;
    private final LinkedList logicSheetList = new LinkedList();

    public AbstractMarkupLanguage() {
        this.languages = new HashMap();
    }

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            this.name = conf.getAttribute("name");
            Configuration[] l = conf.getChildren("target-language");
            int i = 0;
            while (i < l.length) {
                LanguageDescriptor language = new LanguageDescriptor();
                language.setName(l[i].getAttribute("name"));
                Logicsheet logicsheet = this.createLogicsheet(l[i], false);
                language.setLogicsheet(logicsheet.getSystemId());
                Configuration[] n = l[i].getChildren("builtin-logicsheet");
                int j = 0;
                while (j < n.length) {
                    NamedLogicsheet namedLogicsheet = (NamedLogicsheet)this.createLogicsheet(n[j], true);
                    language.addNamedLogicsheet(namedLogicsheet.getURI(), namedLogicsheet.getPrefix(), namedLogicsheet.getSystemId());
                    ++j;
                }
                this.languages.put(language.getName(), language);
                ++i;
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Configuration Error: " + e.getMessage(), (Throwable)e);
            throw new ConfigurationException("AbstractMarkupLanguage: " + e.getMessage(), (Throwable)e);
        }
    }

    private Logicsheet createLogicsheet(Configuration configuration, boolean named) throws Exception {
        Logicsheet logicsheet;
        String location;
        Parameters params = Parameters.fromConfiguration((Configuration)configuration);
        if (named) {
            location = params.getParameter("href", null);
            String uri = params.getParameter("uri", null);
            String prefix = params.getParameter("prefix", null);
            NamedLogicsheet namedLogicsheet = new NamedLogicsheet(location, this.manager, (SourceResolver)this.urlResolver);
            namedLogicsheet.setLogger(this.getLogger());
            namedLogicsheet.setURI(uri);
            namedLogicsheet.setPrefix(prefix);
            logicsheet = namedLogicsheet;
        } else {
            location = params.getParameter("core-logicsheet", null);
            logicsheet = new Logicsheet(location, this.manager, (SourceResolver)this.urlResolver);
            logicsheet.setLogger(this.getLogger());
        }
        String logicsheetName = logicsheet.getSystemId();
        this.logicsheetCache.store(CACHE_PREFIX + logicsheetName, (Object)logicsheet);
        return logicsheet;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.logicsheetCache = (Store)manager.lookup("org.apache.cocoon.components.store.Store/TransientCache");
        this.urlFactory = (URLFactory)this.manager.lookup("org.apache.cocoon.components.url.URLFactory");
        this.urlResolver = new URLFactorySourceResolver(this.urlFactory, manager);
    }

    public void recycle() {
        this.logicSheetList.clear();
    }

    public void dispose() {
        if (this.logicsheetCache != null) {
            this.manager.release((Component)this.logicsheetCache);
        }
        this.logicsheetCache = null;
        if (this.urlFactory != null) {
            this.manager.release((Component)this.urlFactory);
        }
        this.urlFactory = null;
        this.urlResolver = null;
        this.manager = null;
        this.languages.clear();
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.uri = params.getParameter("uri");
        this.prefix = params.getParameter("prefix", null);
    }

    public String getName() {
        return this.name;
    }

    public String getEncoding() {
        return null;
    }

    protected TransformerChainBuilderFilter getTransformerChainBuilder(LogicsheetCodeGenerator logicsheetMarkupGenerator, SourceResolver resolver) {
        return new TransformerChainBuilderFilter(logicsheetMarkupGenerator, resolver);
    }

    protected XMLFilter getPreprocessFilter(String filename, ProgrammingLanguage language) {
        return new XMLFilterImpl();
    }

    protected abstract void addDependency(String var1);

    public String generateCode(InputSource input, String filename, ProgrammingLanguage programmingLanguage, SourceResolver resolver) throws Exception {
        String languageName = programmingLanguage.getLanguageName();
        LanguageDescriptor language = (LanguageDescriptor)this.languages.get(languageName);
        if (language == null) {
            throw new IllegalArgumentException("Unsupported programming language: " + languageName);
        }
        XMLReader reader = XMLReaderFactory.createXMLReader();
        XMLFilter preprocessFilter = this.getPreprocessFilter(filename, programmingLanguage);
        preprocessFilter.setParent(reader);
        LogicsheetCodeGenerator codeGenerator = new LogicsheetCodeGenerator();
        codeGenerator.setLogger(this.getLogger());
        codeGenerator.initialize();
        TransformerChainBuilderFilter tranBuilder = this.getTransformerChainBuilder(codeGenerator, resolver);
        tranBuilder.setLanguageDescriptor(language);
        tranBuilder.setParent(preprocessFilter);
        return codeGenerator.generateCode(tranBuilder, input, filename);
    }

    protected void addLogicsheetsToGenerator(LogicsheetCodeGenerator codeGenerator) throws MalformedURLException, IOException, SAXException, ProcessingException {
        if (codeGenerator == null) {
            this.getLogger().debug("This should never happen: codeGenerator is null");
            throw new SAXException("codeGenerator must never be null.");
        }
        LinkedList<Logicsheet> newLogicSheetList = new LinkedList<Logicsheet>();
        int i = this.logicSheetList.size() - 1;
        while (i >= 0) {
            Logicsheet logicsheet = (Logicsheet)((Object)this.logicSheetList.get(i));
            if (newLogicSheetList.indexOf((Object)logicsheet) == -1) {
                newLogicSheetList.addFirst(logicsheet);
            }
            --i;
        }
        Iterator iterator = newLogicSheetList.iterator();
        while (iterator.hasNext()) {
            Logicsheet logicsheet = (Logicsheet)((Object)iterator.next());
            codeGenerator.addLogicsheet(logicsheet);
        }
    }

    protected void addLogicsheetToList(LanguageDescriptor language, String logicsheetLocation, SourceResolver resolver) throws IOException, SAXException, ProcessingException {
        Logicsheet logicsheet = (Logicsheet)((Object)this.logicsheetCache.get(CACHE_PREFIX + logicsheetLocation));
        if (logicsheet == null) {
            Source inputSource = this.urlResolver.resolve(logicsheetLocation);
            logicsheet = new Logicsheet(inputSource, this.manager, (SourceResolver)this.urlResolver);
            this.logicsheetCache.store(CACHE_PREFIX + logicsheet.getSystemId(), (Object)logicsheet);
        }
        String logicsheetName = logicsheet.getSystemId();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("addLogicsheetToList: name: " + logicsheetName + ", location: " + logicsheetLocation + ", instance: " + (Object)((Object)logicsheet));
        }
        if (logicsheetName.startsWith(FILE)) {
            String filename = logicsheetName.substring(FILE.length());
            this.addDependency(filename);
            this.getLogger().debug("addLogicsheetToList: adding dependency on file " + filename);
        }
        this.logicSheetList.add(logicsheet);
        Map namespaces = logicsheet.getNamespaceURIs();
        if (!logicsheetLocation.equals(language.getLogicsheet()) && namespaces != null && namespaces.size() > 0) {
            Iterator iter = namespaces.keySet().iterator();
            while (iter.hasNext()) {
                String namespace = (String)iter.next();
                String namedLogicsheetName = language.getNamedLogicsheetByURI(namespace);
                if (namedLogicsheetName == null || logicsheetLocation.equals(namedLogicsheetName)) continue;
                this.getLogger().debug("Adding embedded logic sheet for " + namespace + ": " + namedLogicsheetName);
                this.addLogicsheetToList(language, namedLogicsheetName, resolver);
            }
        }
    }

    public class TransformerChainBuilderFilter
    extends XMLFilterImpl {
        protected LogicsheetCodeGenerator logicsheetMarkupGenerator;
        protected LanguageDescriptor language;
        protected SourceResolver resolver;
        private boolean isRootElem;
        private List startPrefixes;

        protected TransformerChainBuilderFilter(LogicsheetCodeGenerator logicsheetMarkupGenerator, SourceResolver resolver) {
            this.logicsheetMarkupGenerator = logicsheetMarkupGenerator;
            this.resolver = resolver;
        }

        protected void setLanguageDescriptor(LanguageDescriptor language) {
            this.language = language;
        }

        public void startDocument() throws SAXException {
            this.isRootElem = true;
            this.startPrefixes = new ArrayList();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (!this.isRootElem) {
                super.startPrefixMapping(prefix, uri);
            } else {
                String[] prefixNamingArray = new String[]{prefix, uri};
                this.startPrefixes.add(prefixNamingArray);
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.isRootElem) {
                String[] prefixNamingArray;
                int i;
                int prefixesCount;
                this.isRootElem = false;
                try {
                    prefixesCount = this.startPrefixes.size();
                    i = 0;
                    while (i < prefixesCount) {
                        prefixNamingArray = (String[])this.startPrefixes.get(i);
                        String namedLogicsheetName = this.language.getNamedLogicsheetByURI(prefixNamingArray[1]);
                        if (namedLogicsheetName != null) {
                            AbstractMarkupLanguage.this.addLogicsheetToList(this.language, namedLogicsheetName, this.resolver);
                        }
                        ++i;
                    }
                    AbstractMarkupLanguage.this.addLogicsheetToList(this.language, this.language.getLogicsheet(), this.resolver);
                    AbstractMarkupLanguage.this.addLogicsheetsToGenerator(this.logicsheetMarkupGenerator);
                }
                catch (ProcessingException pe) {
                    throw new SAXException((Exception)((Object)pe));
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
                super.startDocument();
                prefixesCount = this.startPrefixes.size();
                i = 0;
                while (i < prefixesCount) {
                    prefixNamingArray = (String[])this.startPrefixes.get(i);
                    super.startPrefixMapping(prefixNamingArray[0], prefixNamingArray[1]);
                    ++i;
                }
            }
            super.startElement(namespaceURI, localName, qName, atts);
        }
    }

    protected class LanguageDescriptor {
        protected String name;
        protected String logicsheet;
        protected HashMap namedLogicsheets = new HashMap();

        protected LanguageDescriptor() {
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected String getName() {
            return this.name;
        }

        protected void setLogicsheet(String logicsheet) {
            this.logicsheet = logicsheet;
        }

        protected String getLogicsheet() {
            return this.logicsheet;
        }

        protected void addNamedLogicsheet(String uri, String prefix, String namedLogicsheet) {
            this.namedLogicsheets.put(uri, namedLogicsheet);
        }

        protected String getNamedLogicsheetByURI(String uri) {
            return (String)this.namedLogicsheets.get(uri);
        }
    }
}

