/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;

public final class Jdk14Logger
implements Log {
    protected Logger logger = null;

    public Jdk14Logger(String name) {
        this.logger = Logger.getLogger(name);
        this.logger.setUseParentHandlers(true);
        this.logger.setLevel(Level.INFO);
    }

    public void debug(Object message) {
        this.logger.log(Level.FINE, message.toString());
    }

    public void debug(Object message, Throwable exception) {
        this.logger.log(Level.FINE, message.toString(), exception);
    }

    public void error(Object message) {
        this.logger.log(Level.SEVERE, message.toString());
    }

    public void error(Object message, Throwable exception) {
        this.logger.log(Level.SEVERE, message.toString(), exception);
    }

    public void fatal(Object message) {
        this.logger.log(Level.SEVERE, message.toString());
    }

    public void fatal(Object message, Throwable exception) {
        this.logger.log(Level.SEVERE, message.toString(), exception);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void info(Object message) {
        this.logger.log(Level.INFO, message.toString());
    }

    public void info(Object message, Throwable exception) {
        this.logger.log(Level.INFO, message.toString(), exception);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void trace(Object message) {
        this.logger.log(Level.FINEST, message.toString());
    }

    public void trace(Object message, Throwable exception) {
        this.logger.log(Level.FINEST, message.toString(), exception);
    }

    public void warn(Object message) {
        this.logger.log(Level.WARNING, message.toString());
    }

    public void warn(Object message, Throwable exception) {
        this.logger.log(Level.WARNING, message.toString(), exception);
    }
}

