package msn;

#   Rebot 0.10 (beta): Bot para aventuras de texto por red - By Presi
#   Mdulo de protocolo MSN - R 810.17 - By Sarganar
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#   http://www.gnu.org/licenses/gpl.html

use msn_conf;

BEGIN
{
  use File::Spec;

  unshift (@INC, 'MSNLib');
  unshift (@INC, File::Spec->catfile('MSNLib','lib'));
}

use MSN;

use Encode;
use URI::Escape;

BEGIN
{
  $mod_lang="msn_lang_$rebot_conf::language";
  eval "require $mod_lang";
}

$actual_nick=$msn_conf::nick;
$change = $main::pref_no_com; # prefijo para comenatrios: 1 los comentarios deben ir con prefijo
									# 0 todo lo que no sea comentario debe ir con prefijo
$max_long_nicks=$msn_conf::max_long_nicks;
$master_user=lc($msn_conf::master_user);
$pSB= undef ;     # permanent Switchboard; track the SB using as 'chatroom' in SaloonMode
$typeSB = undef; # can be Publico or Privado
$mode_state = lc($msn_conf::mode_state); # set bot's mode
$SBList = undef;  # keep the actived SB
$SBList_ticks = undef;  # keep the actived SB
$silencioso = undef;
$not_comentary = undef;
$prefijo_cmd= undef;

################################################################################################	
# Functions required for rebot kernel interface

sub texto_inicial
{
  return $MSG_ini;
}

sub texto_ayuda
{
  my $t_com;

  if ($change) { $t_com=$MSG_help_c;  }
  else         { $t_com=$MSG_help_nc; }
  return $MSG_help1.$t_com.$MSG_help2;
}

sub configurar
{
   # at the moment, config tasks are done in conectar( )
   
}

sub conectar
{
# we should choose one of theese ways:

# way1: create object MSN+SERVER errors & other errors
   #~ $msn = new MSN( 'Handle' => $msn_conf::handle, 'Password' => $msn_conf::password );

# way2: create object MSN without error messages
   # $msn = new MSN( 'Handle' => $handle, 'Password' => $password, 'ServerError' => 0, 'Error' => 0 );

# way3: create object MSN+SERVER erros+Full debugging info . Some variants.
#~ $msn = new MSN( 'Handle' => $msn_conf::handle, 'Password' => $msn_conf::password, 'AutoloadError' => 1, 'Debug' => 1, 'ShowTX' => 1, 'ShowRX' => 1 );
#~ $msn = new MSN( 'Handle' => $msn_conf::handle, 'Password' => $msn_conf::password, 'AutoloadError' => 1, 'Debug' => 1, 'ShowRX' => 1 );
  $msn = new MSN( 'Handle' => $msn_conf::handle, 'Password' => $msn_conf::password, 'AutoloadError' => 1, 'Debug' => 1);

# Set client info. Ej: MSNC2 is the MSN proto managing for this client
  $msn->setClientInfo( 'Client' => 'MSNC2' );
  #~ $msn->setClientInfo( 'Client' => 'MSNC5' );

# Set client capabilities (caps) (x-clientcaps)
  $msn->setClientCaps( 'Client-Name' => 'RebotMSN /0.5', 'Chat-Logging' => 'Y', 'Client-Template' => 'None' );

# Set message syles and P4 Name
  $msn->setMessageStyle( 'Font'=>'Verdana', 'Color' => 'FF0000', 'Name' => $actual_nick );

#setMessageStyle:
#~ Font: Font to be use.
#~ Effect: Bold, Italic, Underline, Strikethrough nad mixes. It uses first letter each one. Ej: BI, BU, etc
#~ Color: Formatt BLUE-GREEN-RED hexadecimal. Ej: FF0000 (blue)
#~ CharacterSet: 0 is ANSI_CHARSET (most common used)
#~ PitchFamily: What do if Font not exist. It uses 0 (=dont'care)
#~ Name:Name to show in 'user says:' in chat window. It's the P4-context. Some clients not support it. Ej, Gaim.

# set MSN handlers for events
	$msn->setHandler( 'Connected' => \&msn_on_connect );
	$msn->setHandler( 'Message' => \&msn_on_message );
	$msn->setHandler( 'Disconnected' => \&msn_on_disconnected );
	$msn->setHandler( 'Status' => \&msn_on_Status );
	$msn->setHandler( 'ContactAddingUs' => \&msn_on_NewContact );
	$msn->setHandler( 'ContactRemovingUs' => \&msn_on_lostContact );
	$msn->setHandler( 'MemberJoined' => \&msn_on_MemberJoined );
	$msn->setHandler( 'MemberLeft' => \&msn_on_MemberLeft );
	$msn->setHandler( 'RoomOpened' => \&msn_on_RoomOpened );
	$msn->setHandler( 'RoomUpdated' => \&msn_on_RoomUpdated );
	$msn->setHandler( 'MemberHere' => \&msn_on_MemberHere );
	$msn->setHandler( 'RoomClosed' => \&msn_on_RoomClosed );
	$msn->setHandler( 'ClientCaps' => \&msn_on_ClientCaps );	
	$msn->setHandler( 'Ring' => \&msn_on_Ring );
	$msn->setHandler( 'Typing' => \&msn_on_Typing );
	$msn->setHandler( 'Answer' => \&msn_on_answer );
	$msn->setHandler( 'Ping' => \&msn_on_ping );

   #~ ${main::log}->eslog("  * msn: Conectando como $msn_conf::handle",3);
   ${main::log}->eslog("$MSG_connecting $msn_conf::handle",3);
   #~ ${main::log}->eslog("  * msn: mode_state : $mode_state",2);
   $msn->connect();
  
   # run the bot
   my $run = 1;
   while( $run )
   {
	$msn->do_one_loop();
    }
    #~ ${main::log}->eslog('  * msn: Desconectado',3);
    ${main::log}->eslog("$MSG_disconnected",3);
   
}

#######################################################################################
# enviar_mensaje($SB,$texto,$quien)
#   $SB  = 'msn': Si el modo es Saloon, el destino ser el pSB (permanent Switchboard (socket) o Saloon)
#		Si el modo es Privado, se hace un broadcast del mensaje
#		si el modo es Simple, el destino ser el user $quien
#              = Si no es 'msn', entonces el parametro es la referencia a un SB especifico como destino [SB es parte de la teoria protocolo MSN]
	   
sub enviar_mensaje
{
   my $SB = $_[0];#recordar q este parametro 0 no viene en el argumento sino que es la ref usada: $con->enviar_mensaje() : alli $_[0] sera lo q valga '$con'
   my $texto=$_[1];
   #~ my $quien=$_[2] || $msn_conf::admin; #si no est definido, enva al master
   my $quien=$_[2];
   my $not_coding=$_[3] || 0;
   my $text_encoding = undef;
   
   #~ print "####### msn:enviar_mensaje:\n";
   
   if ($not_coding){ # not_coding vale 1 para mensajes que Rebot 'devuele' a la red MSN (ergo, ya estan codificados) ej: \me <emotion>
	$text_encoding = $texto;
   }else{
	$text_encoding = encode($msn_conf::encoding_out,$texto);
   }
   
   #~ print " msn:enviar_mensaje:1 arg: $SB \n";
    #~ ${main::log}->eslog("  * msn:enviar_mensaje:$texto \n",3);
    ${main::log}->eslog("$MSG_send_msg:$texto \n",3);

   #~ print "    quien: $quien \n";
   #~ print "    SB actual: $SB\n";
   #~ print "    pSB actual: $pSB\n\n";
   
   if ($SB eq 'msn'){ # envo generico (desde rebot kernel): no hay SB especifico sino hasta saber el mode_state
	if ($mode_state eq 'saloon_chating'){
		if (defined $quien) {
			$msn->call( $quien, $text_encoding );
		}else{
			$pSB->sendMessage($text_encoding); #pSB es el permanent Switchboard
		}
	}elsif ($mode_state eq 'privado' && $main::multi && !$main::modo_comando){ # modo multijugador, solo enviar a jugador especifico
		#~ print "~~~~~~   modo multi \n";
		if (defined $quien) {
			$msn->call( $quien, $text_encoding );		        # y si est en modo juego.
		}else{
			#~ $msn->broadcast($text_encoding);			# y si est en modo juego.			
			broadcast($text_encoding);			# y si est en modo juego.			
		}
	}elsif ($mode_state eq 'privado'){
		#~ print "~~~~~~   modo privado normal \n";
		#~ $msn->broadcast($text_encoding);
		broadcast($text_encoding);
	}else{#modo simple, para un usuario (viejo modo, no usado)
		$msn->call( $quien, $text_encoding );
   	}	
   }else{ #envo especifico: hay un SB especifico
		$SB->sendMessage($text_encoding);
   }	
#~ print "########################################\n";

}

sub comando  # return =0 es NO reconocido, return =1 es reconocido
{
  
	${main::log}->eslog("$MSG_no_com",3); # 'comando no reconocido'
  
	return 0; # at this point, command was no recognized neither Rebot nor MSN module
}

###############################################################################################
# MSN module private-specific functions   #
###############################################################################################

BEGIN
{

sub msn_on_connect
{
	my $self = shift;
	
        ${main::log}->eslog($MSG_connected,4);
	$msn->setStatus(uc($msn_conf::start_status)); # set bot intial status
	$msn->setName($actual_nick); 			   # set bot nick. It appears in clients on-line list.
	
	# Set display picture; (Not working in Gaim)
	if ($msn_conf::msn_botpicture) {
		if (-e $msn_conf::msn_botpicture) { # -e: is file exist? (File Management)
			if ($msn_conf::msn_botpicture =~ /\.png/i) {
				$msn->setDisplayPicture($msn_conf::msn_botpicture);	
				#~ ${main::log}->eslog("   * msn: Enviando imagen avatar.",3);
				${main::log}->eslog("$MSG_send_avatar",3);
			} else {
				print "   * msn:<Display picture> WARNING! $msn_conf::msn_botpicture is not a PNG file.\n";	
			}
		} else {
			print "   * msn:<Display picture> WARNING! Cannot find $msn_conf::msn_botpicture for display picture.\n";	
		}
		
	}	
	#~ ${main::log}->eslog("  * msn::Avisando al admin que el bot est online...\n",4);
	#~ $msn->call( $msn_conf::admin, "Ya estoy ONLINE!", 'Effect' => 'BI', 'Color' => 'FA0F00', 'Name' => 'Rebot is ready and' );
	#~ $msn->call( $msn_conf::admin, "Ya estoy ONLINE!", 'Effect' => 'BI', 'Color' => 'FAFF05');
        
	#mensaje welcome
	#~ enviar_mensaje('msn',$main::texto_inicial."\n".texto_inicial(),$msn_conf::admin);

	#~ main::modo('comando');


# lo siguiente solo anda con MSNP11 (version mas nueva, no soportada x el modulo MSN disponible)
   #~ my $loc = 'Cordoba';
   #~ my $data = '<Data><PSM></PSM><CurrentMedia></CurrentMedia><LOC>\0Location\01\0'.$loc.'\0'.$loc.'\0\01\0</LOC></Data>';
   #~ $msn->sendraw("UUX",  length($data)."\r\n" . $data);
   
   #~ setPSMData($msn,"Type the message you want","",0,"",""); 
}

sub msn_on_disconnected {
	my ($self,$message) = @_;
	#~ ${main::log}->eslog("  * msn:Disconnected from server. $message",3);
	${main::log}->eslog("$MSG_disconn_server $message",3);
	exit 0;

}

# msn_on_message: Recibe lo que escriben desde la red MSN
# 	handle-event for 'message is coming'
# 	$self = SB (switch board) que envia mensaje
sub msn_on_message
{
   my( $self, $username, $name, $message, %style ) = @_;

   my $texto=$message;  # text received
   my $quien=$username; # user who send it

   #~ print "msn_on_message: length of text:".length($texto)."\n";
   return 1 if (length($texto) eq 0); # el cliente 'kopete' envia string vacio cada tanto. Qu bagayo!
  #~ return 0 if ($user_level eq 0); #MSN stuff, NO process in Rebot kernel  (for security)

   $name = substr($name,0,$max_long_nicks); # snip long nicks
   $silencioso = msn_comando_silencioso($texto); # devuelve 1 si comando empieza con  con \ o / ( funcion 'emocion' o 'silencioso' [sin Broadcasting])
   $not_comentary = msn_no_comentario($texto); # devuelve 1: procesar comando; no es comentario
   $prefijo_cmd= msn_comando_msn($texto); # devuelve 1 si comando empieza con el 'prefijo comando'

   reset_SBticks($self->getID);  # reseteo de timeout IDLE sesion


  # Tratamiento de bienvenida
   my $id = $self->getID; # get SB id.
   if ($SBList {$id} eq 0){
	#~ print "Primer mensaje de $username \n";
	$SBList {$id} = 1;
	msn_welcome($self,$username,$name);
	return;
   }


   # Tratamiento del mensaje segun el modo del modulo (SaloonMode, Privado, etc)
   if ($mode_state eq 'saloon_chating'){ # el broadcast lo hace hace la misma red msn, NO rebot (salvo que el SB no sea el chatroom)

       if ($self eq $pSB) { # is the message sended from the Chatroom (pSB)?
		$typeSB = 'publico'; # luego esto se usa en el parseo de comandos, para ver de dnde viene el comando
        }else{
        # it's a private chat window, could be a console for master commands, or a whisper channel
		$typeSB = 'privado';
	}
       	
   }elsif ($mode_state eq 'saloon'){    # saloon_idle (1st state), sin pSB asignado. Starting converstaion with Rebot

      # esto era el mensaje de bienvenida, pero ahora se cambio a mas arriba (con el msn_welcome)
      #~ msn_on_MemberHere($self,$username,$name);# ahora el ChatRoom ser este SB, llamar a MemberHere
      
   }elsif ($mode_state eq 'privado' && filter1() ){  # hace un broadcast a cada SB abierto, para informar a todos lo que el bot ha recibido y va a procesar
      
      $typeSB = 'privado';
      msn_broadcast($self,$texto,$name); # si es 'silencioso' msn_broadcast no envia (msn_broadcast is smart!)
   }
   
   #~ ${main::log}->eslog(" * msn: <Conversation> $mode_state - Mensaje $typeSB de $username: $texto",3);
   ${main::log}->eslog("$MSG_chat_info1 $mode_state - $MSG_chat_info2 $typeSB $MSG_from $username: $texto",3);

   # extraer 'prefijo comando' (solo si es necesario)
   if ( $prefijo_cmd != 0 )  {$texto=substr($texto,$prefijo_cmd);$prefijo_cmd = 1;} #$prefijo_cmd puede ser 1 o 2, pero se resetea a 1 para el codigo que sigue.

   # extraer simbolo '/', '.'. etc Esto es, la primera letra del comando (solo si es necesario)
   if ( $silencioso || $change )  {$texto=substr($texto,1);}
   # ahora texto est limpio de toda particula 'comentario' o 'silencioso'. De aqui en mas
   # NO funcionaran las FUNCIONES no_comentario o comando_silencioso

  # Tabla de verdad:
  # not_comentary=1 es procesar		change =0 es !comentario	silencioso=1 es '\mensaje' o '/mensaje'
  # not_comentary=0 es no procesar	change =1 es !comando
  if ($silencioso || $prefijo_cmd){
	  
	msn_comando($self,$quien,$name,$texto); # los silenciosos no se pasan a Rebot kernel, por seguridad	  
	  
  }elsif ($not_comentary){
  
	if (msn_comando($self,$quien,$name,$texto)){ # si es TRUE; NO ES comando MSN, pasar mensaje a Rebot kernel,
									 # tambien puede ser FALSE por tratarse de usuario no permitido
			# Avisar a todos que 'rebot esta tipeando un mensaje'
			foreach my $convo (values %{$msn->getConvoList()})
			{
				$convo->sendTyping();
			}
			#~ print " ---- enviando '$texto' al kernel\n";
			main::tratar_texto($texto,$quien); # enviar al kernel rebot el texto recibido
			#~ print " ---- comando tratado\n";
	}else{ # ES FALSE
	# Si llego hasta aqui, es porque el comando se reconoci en este modulo (MSN), o era user anonimo o baneado.
	# No se lo pas a Rebot (por seguridad).
	#~ enviar_mensaje($self,"msn: Comando no procesado en Rebot.");
	}
  
  } # _if

}

###################################################################################
# Uso sub-interno
###################################################################################

# filter1: devuelve 0 si esta en 'modo multi' && 'modo juego'
# usado en modo privado para broadcast de lo que user ha escrito
sub filter1
{
	my $a=$main::multi;
	my $b=$main::modo_comando;
	
	return ( (!$a*!$b) || (!$a*$b) || ($a*$b) ); # devuelve 0 si esta en 'modo multi' y 'modo juego'

	
}

# smart broadcast
sub msn_broadcast
{
	my $self = shift;
	my $texto = shift;
	my $name = shift;

	my $friendly_name = undef;
	my $texto_final= undef;

       #~ return 1 if (length($texto) = 0); # el cliente kopete envia string vacio cada tanto. Qu bagayo!

	# uso del friendly name en 'Rebot says:' (algunos clientes no lo soportan) 
	if ( $msn_conf::P4_Context) {
		$friendly_name = $name; #"Presi says: Hola"
		$texto_final = $texto;
	}else{
		$friendly_name = $actual_nick; #"Rebot says: [presi] Hola"
		$texto_final = "[$name] $texto";
	}	 
 
	if (!msn_comando_silencioso($texto)) {
		# broadcast selectivo: a todos menos al SB del user que mand el mensaje (para no repetirlo en su ventana)
		foreach my $convo (values %{$msn->getConvoList()})
		{
			if ( ($convo != $self) && ($SBList{$convo->getID} != 0 ) ){$convo->sendMessage($texto_final , 'Name' => $friendly_name);} 
		}
	}
 
}


# smart broadcast 2: No envia mensajes a clientes que solo iniciaron SB, pero que el usuario no escribio nada (Kopete-like)
sub broadcast
{
	my $texto = shift;

	foreach my $convo (values %{$msn->getConvoList()})
	{
		if  ($SBList{$convo->getID} != 0 ) {
			#~ print " broadcast: enviando $texto a $convo->getID \n";
			$convo->sendMessage( $texto );
			}
	}
}


# msn_comando_silencioso:
# Retorna '1' si se trata de un comando silencioso
sub msn_comando_silencioso
{      
	my $texto = shift;
	
	my $p_letra = substr($texto,0,1); #e xtraer primera letra
        
	return 1 if ($p_letra eq '/');
	return 1 if ($p_letra eq '\\'); # contemplar las dos posibilidades / o \
	
	return 0;
}

# msn_comando_msn:
# Retorna '1' si se trata de un comando msn
sub msn_comando_msn
{      
	my $texto = shift;
	
	# Los comandos pueden entrarse como &&comando (protocolo Rebot) o +comando (protocolo MSN)
	
	# 1ro: Chequeo de rebot_prefix (Ej: &&list)
	my $p_letra = substr($texto,0,2); # extraer 2 primeras letras
	return 2 if ($p_letra eq $rebot_conf::com_prefix);
	
	# 1ro: Chequeo de MSN_prefix (Ej: +menuad)
	$p_letra = substr($texto,0,1); # extraer primera letra
	return 1 if ($p_letra eq '+');
	
	return 0;
}

sub msn_no_comentario
{
  my $texto=$_[0];

  my $primero=substr($texto,0,1);
  # la operacion es : negar($change XOR 'primera_letra_del texto')
  return (!(  $change xor ( ($primero eq '.') || ($primero eq "'") || ($primero eq '#') || ($primero eq '!') )  ));
}


# not used actually
sub msn_no_autorizado
{
  my $donde=$_[0];

  if ($msn_conf::errors){
      enviar_mensaje('msn',$MSG_no_aut,$donde);
      main::modo('',$donde);
    }
}

# msn_welcome : 
#   Se ejecuta al detectar Rebot coneccion con el usuario nuevo (o nueva coneccion con un abandonado)
sub msn_welcome {
	my ($self,$username,$name) = @_;  # $self: SB	$username: email	$name : friendly name 

	my $what_rebot_mode = '';
	my $all_members = "\n";
	my $members = undef;
	my $acumul = 1;
	
	$name = substr($name,0,$max_long_nicks); # snip long nicks

	if ($main::modo_comando){
		#~ $what_rebot_mode = "Modo actual: --Modo comando--";
	#~ }else{
		#~ $what_rebot_mode= "Modo actual: --Modo juego o aplicacion--";
		$what_rebot_mode = $MSG_rebot_mode_cmd;
	}else{
		$what_rebot_mode= $MSG_rebot_mode_app;
	}

	#welcome message
	#~ enviar_mensaje($self,"Hola $name!\n".$main::texto_inicial."\n".texto_inicial()."\n".$what_rebot_mode."\nModo MSN: ".$mode_state);
	enviar_mensaje($self,"$MSG_hello $name!\n".$main::texto_inicial."\n".texto_inicial()."\n".$what_rebot_mode."\n$MSG_msn_mode: ".$mode_state);

        if ($mode_state eq 'saloon_chating'){ # estado normal de Modo Salon
		$members = $pSB->getMembers();
		if( !(defined $members->{$username}) ){ # verificar si ya existe en el pSB, para no re-invitar
			#~ enviar_mensaje($self,"Ahora ingresaras al ChatRoom...\nEsta ventana es para mensajes privados a Rebot (si ests autorizado). Busca la ventana (o solapa) del Chatroom, que debera haberse abierto ya.");
			enviar_mensaje($self,"$MSG_now_you_in");
			$pSB->invite($username);
			sleep 3;
			#~ enviar_mensaje($pSB,"$name acaba de entrar al Chatroom.");  # y esto tambien abre una ventana para el recien llegado
			enviar_mensaje($pSB,"$name $MSG_just_in.");  # y esto tambien abre una ventana para el recien llegado
		}
		upgrade_users();
		#~ $self->leave(); #esto dio problemas ***************
		
	}elsif ($mode_state eq 'saloon'){ # estado inicial de Modo Salon
		$pSB = $msn->findMember($username); # localizar el SB de quin escribi el comando y asignarlo al pSB
		$mode_state = 'saloon_chating';
		#~ enviar_mensaje($pSB,"Ahora este es el ChatRoom.");
		enviar_mensaje($pSB,"$MSG_now_thisRoom");
		${main::log}->eslog("  * msn: mode_state: $mode_state",3);
		upgrade_users();

	}elsif ($mode_state eq 'privado'){
		# obetener los friendly de todos los user 'conectados' al bot, para listarlos en la bienvenida al new user
		foreach my $convo (values %{$msn->getConvoList()})
		{
			if  ($SBList{$convo->getID} != 0 ) { # SB con id=0 aun no han escrito nada
			  $members = $convo->getMembers();
			#~ print values %{$members};*******
			#~ print "\n";*************
			  $all_members = $all_members.join('\n',uri_unescape(values %{$members}))."\n"; # no se restringen los nombres largos aqui
			}
		}
		
		upgrade_users();
		
		#~ enviar_mensaje('msn',"Ahora [$name] tambin est chateando con Rebot."); # avisar a todos
		#~ enviar_mensaje($self,"Actualmente chatean con Rebot : ".$all_members); # info para el nuevo (solo para su canal o SB)
		enviar_mensaje('msn',"$MSG_now [$name] $MSG_is_chatting."); # avisar a todos
		enviar_mensaje($self,"$MSG_actually_chatting : ".$all_members); # info para el nuevo (solo para su canal o SB)
		
		# Descomentar la siguiente linea si el master quiere enterarse siempre de quien entra al Rebot
		#~ $msn->call( $master_user, "msn for MASTER: Ahora [$username] tambin est chateando con Rebot.");

        }
}

# lo siguiente solo anda con MSNP11 (version mas nueva, no soportada x el modulo MSN disponible)
#   setPSMData

#~ for the music icon:
#~ 	$msn->setPSMData("","Music",1,"title","artist");
#~ for the game icon:
#~ 	$msn->setPSMData("","Games",1,"the game...","");
#~ for the office icon:
#~ 	$msn->setPSMData("","Office",1,"the document...","");
#~ if you don't want to use an icon:
#~ 	$msn->setPSMData("Type the message you want","",0,"","");

sub setPSMData
{
	my $self = shift;
	my $psm = shift;
	my $type = shift;
	my $music = shift;
	my $artist = shift;
	my $title = shift;
	my $btween = $title ? ' - {1}' : '';
	my $ifmusic = $music ? '<CurrentMedia>\0'.$type.'\0'.$music.'\0{0}'.$btween.'\0'.$artist.'\0'.$title.'\0\0\0</CurrentMedia>' : '';
	my $data = '<Data><PSM>'.$psm.'</PSM>'.$ifmusic.'</Data>';
	
	$self->{Notification}->sendraw("UUX", length($data)."\r\n" . $data);
}


############################################################################################
# Otros Eventos de la Red MSN
############################################################################################

sub msn_on_MemberJoined {
	my ($self,$username,$name) = @_;	
	
	#~ ${main::log}->eslog("  * msn: $username has joined the conversation.",3);
	${main::log}->eslog("  * msn: $username $MSG_has_joined",3);
	#~ print "msn: $username has joined the conversation.\n";	
}

#Alguien quiere chatear con nosotros (no se cumple igual con todos los clientes, ej Gaim lo hace al conectarse l o Rebot, no al iniciar ventana)
sub msn_on_Ring {
	my ($self,$username,$name) = @_;	
	
	#~ ${main::log}->eslog("  * msn: <Ring> $username want chat with Rebot.",3);
	${main::log}->eslog("  * msn: <Ring> $username $MSG_wan_chat",3);
	return; #807.14 un bug extrao; que haca que se cuelgue esto sin el 'return'
}

#Alguien nos agreg a sus contactos
sub msn_on_NewContact {
	my ($self,$username) = @_;	
	#~ enviar_mensaje('msn',"Hola!\n".$main::texto_inicial."\n".texto_inicial(),$username);#ojo en esta situacion que todavia no hay una ventana de chat habilitada
	#~ main::modo('',$username);
	#~ ${main::log}->eslog("  * msn: <New contact> $username has added the bot.",3);
	${main::log}->eslog("$MSG_new_contact $username $MSG_has_added",3);

	#~ $msn->call( $master_user, "$username has added the bot. Type add $username master/public for accept him");
	return 1; 	# IMPORTANTE: devolver 0 para que no lo agregue automaticamente a la AL (Allow List), y entonces poder
			# gestionar miembros a mano mediante los comandos MSN desde la sesion de chat con Rebot
}

sub msn_on_lostContact {
	my ($self,$username) = @_;	
	$msn->disallowContact($username);
	$msn->remContact($username);
	#~ enviar_mensaje('msn',"$username deleted Rebot from his contact list.");
	enviar_mensaje('msn',"$username $MSG_deleted_us");

}

#Se ha abierto una Room ('Invite...' command o simplemente alguien inici una ventana de chat con nosotros) (oficialmente)
sub msn_on_RoomOpened {
	my $self = shift;

	#~ ${main::log}->eslog('  * msn: <Conversation> Room opened.',3);
	${main::log}->eslog("$MSG_room_opened",3);
	
	my $id = $self->getID; # get SB id.
	$SBList {$id} = 0;
	#~ print "id: $id \n";
	#~ print "Valores de SBList: SBs:     ",join(', ',keys %SBList),"\n";
	#~ print "Valores de SBList: Welcomed:",join(', ',values %SBList),"\n";
}

sub msn_on_RoomClosed {
	my $self = shift; # recibir el SB que se cerr
	
	# verificar si el SB que se cerr era del Chatroom (modo saloon)
	if ($mode_state eq 'saloon_chating'){

            if ($self eq $pSB){	   
		$mode_state = 'saloon'; #volver a estado saloon-idle, sin pSB asignado
		#~ ${main::log}->eslog('  * msn: Chatroom Cerrado.',3);
		${main::log}->eslog("$MSG_chat_closed",3);
	   }	
	}	
	
	if (defined $self){ # check if is there a real SB
	 my $id = $self->getID; # get SB id.
	 delete $SBList {$id};	# Borrar SB id de la lista
	 upgrade_users();
	}
	#~ ${main::log}->eslog('  * msn: <Conversation> Room Closed.',3);
	${main::log}->eslog("$MSG_room_closed",3);

	${main::log}->eslog("  * msn: mode_state: $mode_state",3);
}

sub msn_on_RoomUpdated {	
	my $self = shift;
	#~ $self->sendMessage( "Hola $name!\n".$main::texto_inicial."\n".texto_inicial(), %style );

	#~ ${main::log}->eslog('  * msn: <Conversation> Room Update. The conversation is fully up to date.',3);
	${main::log}->eslog("$MSG_room_update",3);

}

# msn_on_MemberHere: Evento generado toda vez que alguien inicia una ventana de chat (quiere chatear con rebot) o responde al pedido de chat de terceros
#			Clientes como Gaim generan este evento al logearse el bot a la red (o logearse Gaim a la red)
#self: el SB (socket) desde donde el user avisa que est
sub msn_on_MemberHere { #user dice 'presente'en el SB
	my ($self,$username,$name) = @_;  # $self: SB	$username: email	$name : friendly name 
	
	#~ msn_welcome($self,$username,$name);
	
	#~ ${main::log}->eslog("  * msn:<MemberHere> $username is here.",3);
	${main::log}->eslog("  * msn:<MemberHere> $username $MSG_member_here",3);

}



#alguien est tipeando un mensaje, avisarle a todos (modo privado)
sub msn_on_Typing {
	my ($self,$username,$name) = @_;	
	
	if ($mode_state eq 'privado'){
		foreach my $convo (values %{$msn->getConvoList()})
		{
			if ($convo != $self){$convo->sendTyping();}
		}
	}

	${main::log}->eslog("  * msn: <Typing> $username",3);
	
	# Tratamiento de bienvenida. Pensado para clientes Gaim-like
	my $id = $self->getID; # get SB id.
	if ($SBList {$id} eq 0){
		#~ print "Primer mensaje de $username \n";
		$SBList {$id} = 1;
		msn_welcome($self,$username,$name);
	}
}


sub msn_on_MemberLeft {
	my ($self,$username,$name) = @_;  # $self: SB	$username: email	$name : friendly name 
	upgrade_users();
	
	if ($mode_state eq 'privado'){
		#~ enviar_mensaje('msn',"Alguien se ha ido....."); # avisar a todos
		enviar_mensaje('msn',"$MSG_member_left"); # avisar a todos
	}
	
	#~ ${main::log}->eslog("  * msn: <MemberLeft> $username se ha ido.....",3);
	${main::log}->eslog("  * msn: <MemberLeft> $username $MSG_logmember_left",3);

}

sub msn_on_answer{
	my $self = shift;
	${main::log}->eslog("  * msn: <Answer> event.",2);

}

sub msn_on_Status{
	my ($self,$username,$status) = @_;
	#~ if ($username =~ /\w/i) {
		#~ print "<Status2>$username changed status to $status.\n\n" if ($status eq 'FLN');
		#~ if ($msn->uptime() >= 10) {
			#~ print "<Status3>$username changed to $status";
		#~ }
	#~ }
	#~ ${main::log}->eslog("  * msn: <Status> $username changed status to $status.",2);
	${main::log}->eslog("  * msn: <Status> $username $MSG_change_status $status.",2);

	#~ print "<Status1> $username changed status to $status\n";
}

sub msn_on_ClientCaps {
	my ($self,$username,%client_caps) = @_;
	${main::log}->eslog("  * msn:<ClientCaps> from $username",3);
	#~ print "<ClientCaps> from $username\n";

	foreach my $key (keys %client_caps)	{
		${main::log}->eslog("  * msn:     $key = $client_caps{$key}",3);
		#~ print "    $key = $client_caps{$key}\n";
	}

}

# Ping es llamado internamente por el main loop de rebot:msn cada 30 segundos
#     Internamente se utiliza para enviar mensajes de still alive al server remoto
#     Este entry point permite agregar otras tareas, como la que se hace aqui:
#      se controla el estado idle de la conexin. Si pasan 5 minutos en IDLE, se mata la conexion.
#        Esto es asi porque el server remoto tambien la elimina (pautas Microsoft), pero no avisa nada (quedando el SB huerfano)
sub msn_on_ping{
	my $self = shift;
	${main::log}->eslog("  * msn: <Ping> event.",1);
	foreach my $keys (keys %SBList) #aumenta en un tick por cada PING (30 segundos), esto se resetea con reset_SBticks (llamado en message_on)
	{
		$SBList_ticks{$keys} = $SBList_ticks{$keys} + 1;
		#~ print "   tick: $SBList_ticks{$keys} \n";
	}

	foreach my $keys (keys %SBList) # cheking si se paso los 10 ticks (5 minutos antes de la desconexion x parte del SwitchBoard)
	{						# para una ms exacta (y simple)resolucion se tendria que usar $msn->uptime() 
		if ($SBList_ticks{$keys} >=10){
			my $conversations = $msn->getConvoList;
			my $temp = $conversations->{$keys};
                        #~ ${main::log}->eslog("  * msn: msn_on_ping: SB $keys closed for inactivity\n",3);
			${main::log}->eslog("  * msn: msn_on_ping: SB $keys $MSG_close_idle\n",3);
			msn_on_RoomClosed ($temp);
			$msn->getConvoList->{$keys}->leave;	
		}
	}
}

# reset_SBticks: resetea el conteo de IDLE state para ese SB (apuntado por el id)
sub reset_SBticks{
	my $id = shift;
	
	$SBList_ticks{$id} = 0;

}

# upgrade_users: re-count of players connected to rebot, for apgrade de rebot nickname
sub upgrade_users{
	my $acumul=0;			# para actualizar el nickname de rebot con la cantidad de conectados a l
	#~ my $jugador="jugadores"; 	# para actualizar el nickname de rebot con la cantidad de conectados a l
	my $jugador=$MSG_players; 	# para actualizar el nickname de rebot con la cantidad de conectados a l
	my $member=undef;

	return 1 if (!$msn_conf::upgrade_players); # si no se quiere actualizar el numero de jugadores en el nickname de Rebot
	
	# Calculo de jugadores conectados
        if ($mode_state eq 'privado'){ # el modo de Rebot es 'privado'
		foreach my $convo (values %{$msn->getConvoList()})
		{
			$members = $convo->getMembers();
			$acumul = $acumul + scalar(keys %{$members});
			#~ ${main::log}->eslog("  * msn: modo privado  - calculando jugadores...\n",3);
			${main::log}->eslog("  * msn: $MSG_private_mode  - $MSG_calculating_players:$acumul",3);

		}
	}elsif (defined $pSB)   { # el modo de Rebot es 'saloon-chating', solo si est definido $pSB
		
		$members = $pSB->getMembers();
		$acumul = scalar(keys %{$members}); # correccion para que no cuente a Rebot mismo
		#~ ${main::log}->eslog("  * msn: modo saloon  - calculando jugadores...\n",3);
		${main::log}->eslog("  * msn: $MSG_saloon_mode  - $MSG_calculating_players",3);
	}


	# Actualizar NICK Name del bot, con la cantidad de jugadores conectados
	#~ $jugador = "jugador" if ($acumul eq 1);
	$jugador = $MSG_player if ($acumul eq 1);
	$jugador = "" if ($acumul eq 0);
	#~ $acumul = "esperando..."  if ($acumul eq 0);
	$acumul = $MSG_waiting  if ($acumul eq 0);

	$msn->setName(encode($msn_conf::encoding_out,"Rebot, $acumul $jugador")); # set bot nick. It appears in clients on-line contact list.
	${main::log}->eslog("  * msn: Upgrade_users:Rebot, $acumul $jugador\n",3);


}
############################################################
#  msn_comando 
#  Funcion : Parser de comandos MSN

#  Retorno : 	1: Comando NO MSN, puede pasarse a Rebot
#		0: Comando MSN, no pasarlo a Rebot, ya fue tratado aqui
	     
sub msn_comando
{
  my $SB = $_[0];     # referencia al SwitchBoard origen del comando
  my $quien = $_[1]; # user email, a man who type the command
  my $name = $_[2]; # ya recortado a un maximo de caracteres (ver msn_on_message)
  my $texto = $_[3]; # command (sin particula primera letra)
  my $all_members = "\n";

  # separar comando de argumento
  my @elem=split(' ',$texto);
  lc ($elem[0]);
  my $comando = $elem[0]; # guardar comando (primer palabra del array)
  my $size = $#elem; 	# indice mximo (size fisico -1) de @elem
  my $arg = join(' ', @elem [1..$size]);# armar argumento de comando

  #~ print  "size: $size";
 
  $user_level = msn_get_user_level ($quien); # obtener nivel de usuario (permisos de comando)

   ${main::log}->eslog("  * msn:user level: $user_level",2);
   ${main::log}->eslog("  * msn:command: $comando",2);
   ${main::log}->eslog("  * msn:arg : $arg",2);

  #~ print "msn_comando: modo_comando:". $main::modo_comando."\n";
  #~ print "msn_comando: prefijo_cmd:$prefijo_cmd\n";

 if ( !$main::modo_comando && !$prefijo_cmd){ # (en modo juego, no atender comandos MSN sin prefijo comando)
	return 0 if ($user_level eq 0); # user anonimous, not pass to Rebot kernel
	return 1; # user allowed, pass to Rebot kernel, NOT Process in MSN cmds.
 }

   #~ print msn_comando_silencioso($texto)."\n";
   #~ print "cambio : $change \n";
   ${main::log}->eslog("  * msn:cmd:user level: $user_level",1);

  # Parseo de comandos:
  
  # MASTER LEVEL
  if ( $user_level >= 3 ) {
	if ( $comando eq $COM_salir )
	{
		$msn->disconnect();
		exit 0;
	}elsif ( $comando eq $COM_status) # SET BOT STATUS
	{
		my $status = uc($arg);
		my $allowed = $msn_conf::msn_status; 
		if (exists $allowed->{$status}) {
			$msn->setStatus($status);
			#~ enviar_mensaje($SB,"Status set to $allowed->{$status}", $username);
			enviar_mensaje($SB,"$MSG_set_status $allowed->{$status}", $username);
			${main::log}->eslog("  * msn:$MSG_set_status $allowed->{$status}",2);
		} else {
			#~ enviar_mensaje($SB,"Invalid status. Read the docs files. :-(", $username);
			enviar_mensaje($SB,"$MSG_invalid_status", $username);
		}		
		return 0;
		
	}elsif ( $comando eq $COM_display_name) # DISPLAY BOT NAME
	{
		if ($arg) {
		$msn->setName($arg); # set bot nick. It appears in clients on-line contact list.
		#~ enviar_mensaje($SB,"Bot name set to $arg.", $username);	
		enviar_mensaje($SB,"$MSG_setbot_named $arg.", $username);	
		} else {
		#~ enviar_mensaje($SB,"You must specify a name to set, e.g Rebot", $username);
		enviar_mensaje($SB,"$MSG_query_name", $username);			
		}
		return 0;
	}elsif ( $comando eq $COM_display_pic ) # DISPLAY NEW PICTURE (BOT AVATAR)
	{
		my $path = $arg;
		if ($path =~ /(\.png)$/i) {
			if (-e $path) {
			  $msn->setDisplayPicture($path);
			  #~ enviar_mensaje($SB,"Display picture set to $path", $username);
			  enviar_mensaje($SB,"$MSG_set_picture $path", $username);
			} else {
			  #~ enviar_mensaje($SB,"The file $path does not appear to exist!", $username);
			  enviar_mensaje($SB,"$MSG_the_file $path $MSG_not_exist", $username);
			}
		} else {
			#~ enviar_mensaje($SB,"You must specify a .png file", $username);
			enviar_mensaje($SB,"$MSG_must_png", $username);
		}
		return 0;
	}elsif ( $comando eq $COM_socks) # SB COMMAND: SHOW OR KILL A SOCKETS
	{
		my $nextbit = $arg;
		if ($nextbit =~ /show/i) 
		{
			#~ my $sockets = "Open Sockets:\n";
			my $sockets = "$MSG_open_sockets\n";
	
			my $conversations = $msn->getConvoList;
			foreach my $id (keys %{$conversations}) {
				my $temp = $conversations->{$id};
				my $members = $temp->getMembers();
				my $users;
				foreach my $member (keys %{$members}) {		
				  $users .= "$member,";
				}	
				$users =~ s/\,$//;
				$sockets .= "$id [$users]\n";
			}
			chomp $sockets;
			enviar_mensaje($SB,$sockets,$username);
			return 0;
			#~ goto end;
		}
		if ($nextbit =~ /kill (.*)|kill$/i) {
			my $msg = $1;
			if ($msg) {
				#~ enviar_mensaje($SB,"[Socket] $msg Eliminated.", $username);
				enviar_mensaje($SB,"[Socket] $msg $MSG_eliminated.", $username);
				$msn->getConvoList->{$msg}->leave;	
			} else {
				#~ enviar_mensaje($SB,"[Socket] You must provide a socket number.", $username);
				enviar_mensaje($SB,"[Socket] $MSG_query_socket", $username);
			}
			return 0;
			#~ goto end;
		}
		#~ enviar_mensaje($SB,"[Sockets] Please use either show or kill with the socks command.", $username);
		enviar_mensaje($SB,"[Sockets] $MSG_help_sockscmd", $username);
	end:	return 0;
	}elsif ( $comando eq $COM_add) # ADD MEMBER WITH PERMISSIONS
	{
		my ($rank,$user) = split (/\s/,$arg,2);
		if (!$rank || !$user) {
			#~ enviar_mensaje($SB,"You must specify a rank and user. Ej: add master juan\@juan.net", $username);
			enviar_mensaje($SB,"$MSG_query_rank. Ej: add master juan\@juan.net", $username);
		}elsif ($user =~ /\@/ && $user =~ /\./) {

			if ($rank eq $COM_public) {
				$msn->unblockContact($user);
				$msn->allowContact($user);
				#~ enviar_mensaje($SB,"User added like public. He'll could see the status bot.", $username);
				enviar_mensaje($SB,"$MSG_user_addedlist", $username);
			}elsif ($rank eq $COM_master) {
				$msn->unblockContact($user);
				$msn->allowContact($user);
				$msn->addContact($user);
				#~ enviar_mensaje($SB,"User added like master. He is in the contact Rebot list now.", $username);
				enviar_mensaje($SB,"$MSG_now_user_master", $username);
			}else{
				#~ enviar_mensaje($SB,"The rank \'$rank\' does not appear to exist.", $username);
				enviar_mensaje($SB,"$MSG_the_rank \'$rank\' $MSG_not_exist", $username);
			}
		}else{
			#~ enviar_mensaje($SB,"Not a correct email address. Ej: add master juan\@juan.net", $username);
			enviar_mensaje($SB,"$MSG_wrong_email. Ej: add master juan\@juan.net", $username);
		}
		return 0;
	}elsif ( $comando eq $COM_list)  # LIST MEMBERS IN BOT INTERNAL LIST
	{
		my $strl = "$MSG_main_master:\n    ".$master_user."\n";
		$strl = $strl."$MSG_list_master\n    ";
		my @list = $msn->getContactList('FL');
		$strl = $strl.join("\n    ", @list);
		@ALlist = $msn->getContactList('AL');
		$strl = $strl."\n$MSG_list_public\n    ";
		$strl = $strl.join("\n    ", @ALlist);
		@list = $msn->getContactList('BL');
		$strl = $strl."\n$MSG_list_bloqued\n    ";
		$strl = $strl.join("\n    ", @list);
		$strl = $strl."\n$MSG_list_pending\n    "; # gente que agregaron al bot a sus contactos, esperando ser admitidas
		@list = $msn->getContactList('RL');
		my $onlyRL = 0;
		foreach my $boy (@list){ # la PL se obtiene: son los users de RL que no aparecen en FL
			foreach (@ALlist){
				$onlyRL = 1 if ($boy eq $_);
			}
        		$strl = $strl.$boy."\n    " if ($onlyRL eq 0);
			$onlyRL = 0;

		}
		enviar_mensaje($SB,$strl, $username);
		return 0;
	}elsif ( $comando eq $COM_delete) # DELETE MEMBER
	{
		my $user = $arg;
		if (!$user) {
			#~ enviar_mensaje($SB,"You must specify a user. Ej: del juan\@juan.net", $username);
			enviar_mensaje($SB,"$MSG_query_user. Ej: del juan\@juan.net", $username);
		}elsif ($user =~ /\@/ && $user =~ /\./) {

			$msn->disallowContact($user);
			$msn->remContact($user);
			#~ enviar_mensaje($SB,"Comand processed.", $username);
			enviar_mensaje($SB,"$MSG_cmd_processed", $username);

		}else{
			enviar_mensaje($SB,"$MSG_wrong_email. Ej: del juan\@juan.net", $username);
		}
		return 0;
	}elsif ( $comando eq $COM_block_member) # BLOCK MEMBER
	{
		my $user = $arg;
		if (!$user) {
			enviar_mensaje($SB,"$MSG_query_user. Ej: ban juan\@juan.net", $username);
		}elsif ( $user eq $master_user){
			#~ enviar_mensaje($SB,"I can't block to my master!", $username);
			enviar_mensaje($SB,"$MSG_cant_blockhim", $username);
		}elsif ($user =~ /\@/ && $user =~ /\./) {

			$msn->blockContact($user);
			#~ $msn->remContact($user);
			#~ enviar_mensaje($SB,"User blocked. He can't chat with Rebot.", $username);
			enviar_mensaje($SB,"$MSG_user_blocked", $username);
		}else{
			enviar_mensaje($SB,"$MSG_wrong_email. Ej: ban juan\@juan.net", $username);
		}
		return 0;
	}elsif ( $comando eq $COM_unblock_member) # UNBLOCK CONTACT
	{
		my $user = $arg;
		if (!$user) {
			enviar_mensaje($SB,"$MSG_query_user. Ej: unban juan\@juan.net", $username);
		}elsif ($user =~ /\@/ && $user =~ /\./) {

		$msn->unblockContact($user);
		#~ $msn->remContact($user);

		}else{
			enviar_mensaje($SB,"$MSG_wrong_email. Ej: unban juan\@juan.net", $username);
		}
		return 0;

	}elsif ( $comando eq $COM_show_menuad) # SHOW COMMAND MENU FOR MASTERS
	{
		enviar_mensaje($SB,$MSG_menuad, $username);
		return 0;
	}
}

  # OPERATOR LEVEL - (actually not in use)
  if ( $user_level >= 2 ) {

  }

  # PUBLIC LEVEL 1 - normal - acces to 'main::tratar_texto' (ie, rebot/juego/aplicacion)
  if ( $user_level >= 1 ) {
 
  }
  # PUBLIC LEVEL 0 - no access to 'main::tratar_texto' (ie, no acces to rebot/game/aplication, resolved in this MSN module)
  if ( $user_level >= 0 ) {
	if ( $comando eq 'me' && $size>0) #emotion: pensado para funcionar en modo privado (like IRC /me)
	{
		enviar_mensaje('msn',$name." ".$arg,$quien,1); 
		return 0;
  
	}elsif ( $comando eq $COM_who && $mode_state eq 'privado') # lista la gente que actualmente chatea con Rebot (solo para modo privado)
	{
		# obetener los friendly de todos los user 'conectados' al bot
		foreach my $convo (values %{$msn->getConvoList()})
		{
			$members = $convo->getMembers();
			
			$all_members = $all_members.join('\n',uri_unescape(values %{$members}))."\n"; # aqui no se restringen los nombres largos
		}
		#~ enviar_mensaje($SB,"Actualmente chatean con Rebot : ".$all_members);
		enviar_mensaje($SB,"$MSG_now_chating : ".$all_members);
		return 0;
		
	}elsif ( $comando eq 'ver') {# Rebot Version 
		#~ enviar_mensaje($SB,$main::texto_inicial."\n".texto_inicial()."\n".$what_rebot_mode."\nModo MSN: ".$mode_state);
		enviar_mensaje($SB,$main::texto_inicial."\n".texto_inicial()."\n".$what_rebot_mode."\n$MSG_msn_mode: ".$mode_state);
		return 0;
	}elsif ( $comando eq $COM_mylevel) {# Show User Level
		#~ enviar_mensaje($SB,"For Rebot you has level $user_level.");
		enviar_mensaje($SB,"$MSG_your_level $user_level.");
		return 0;
	}elsif ( $comando eq $COM_disconnect && $mode_state eq 'privado') {# Kill my connection with rebot - only for 'private' mode
		#~ enviar_mensaje($SB,"Que tengas un buen da, aventurero!", $username);
		enviar_mensaje($SB,"$MSG_nice_day", $username);
                my $id = $SB->getID; # get SB id.
		delete $SBList {$id};	# Borrar SB id de la lista (usada para los ticks)
		$SB->leave();
		upgrade_users();
		enviar_mensaje('msn',"$MSG_member_left"); # avisar a todos
		${main::log}->eslog("  * msn: <MemberLeft> $username $MSG_logmember_left",3);
		return 0;
	}elsif ( $comando eq '*') {# speak
		$texto=substr($texto,1); # extraer '?'
		#~ $msn->broadcast("$name dice: \"$texto\".");				# y si est en modo juego.			
		broadcast("$name dice: \"$texto\".");				# y si est en modo juego.			
		return 0;
	}

  }


  return 0 if ($user_level eq 0); #MSN stuff, NO process in Rebot kernel  (for security)
 
  return 1; # no MSN command , pass to Rebot kernel
  
}

sub msn_get_user_level
{
	my $quien = shift;
 
	return 3 if ( $msn_conf::all_auth );      # MASTER LEVEL
 
	return 3 if ( $quien eq $master_user ); # MASTER LEVEL
 
	my @list = $msn->getContactList('FL');
	foreach my $boy (@list){
		return 3 if ($boy eq $quien);	# MASTER LEVEL
	}

	@list = $msn->getContactList('AL');
	foreach my $boy (@list){
		return 1 if ($boy eq $quien);	# PUBLIC LEVEL 1
	}

	@list = $msn->getContactList('BL');
	foreach my $boy (@list){
		return 0 if ($boy eq $quien);	# PUBLIC LEVEL 0 - Kick ass!
	}

	return 0 if ( ($mode_state eq 'saloon_chating') &&  ($typeSB eq 'privado') ); # PUBLIC LEVEL 0 ; tratando de meter comandos por otra ventana privada (y no es MASTER)
 
	return 0 if ( ($mode_state eq 'privado') && $silencioso );   # PUBLIC LEVEL 0; tratando de meter comandos silenciosos no permitidos
 
	#~ return 1; # PUBLIC LEVEL 1
	return 0; # PUBLIC LEVEL 0 - por defecto

}



}   # BEGIN

BEGIN      # Extrayendo mensajes y comandos para simplificar sintaxis / Ahora ordenados alfabeticamente
{

  $COM_cambiar=${qq(${mod_lang}::cambiar)};
  $COM_cambio=${qq(${mod_lang}::cambio)};
  $COM_salir=${qq(${mod_lang}::salir)};
  $COM_status=${qq(${mod_lang}::status)};
  $COM_display_name=${qq(${mod_lang}::display_name)};
  $COM_display_pic=${qq(${mod_lang}::display_pic)};
  $COM_socks=${qq(${mod_lang}::socks)};
  $COM_add=${qq(${mod_lang}::add)};
  $COM_public=${qq(${mod_lang}::public)};
  $COM_master=${qq(${mod_lang}::master)};
  $COM_list=${qq(${mod_lang}::list)};
  $COM_delete=${qq(${mod_lang}::delete)};
  $COM_block_member=${qq(${mod_lang}::block_member)};
  $COM_unblock_member=${qq(${mod_lang}::unblock_member)};
  $COM_show_menuad=${qq(${mod_lang}::show_menuad)};
  $COM_who=${qq(${mod_lang}::who)};
  $COM_mylevel=${qq(${mod_lang}::mylevel)};
  $COM_disconnect=${qq(${mod_lang}::disconnect)};



  $MSG_com_no=${qq(${mod_lang}::com_no)};
  $MSG_com=${qq(${mod_lang}::com)};
  $MSG_coma=${qq(${mod_lang}::coma)};
  $MSG_come=${qq(${mod_lang}::come)};
  $MSG_connected=${qq(${mod_lang}::connected)};
  $MSG_help_c=${qq(${mod_lang}::help_c)};
  $MSG_help_nc=${qq(${mod_lang}::help_nc)};
  $MSG_help1=${qq(${mod_lang}::help1)};
  $MSG_help2=${qq(${mod_lang}::help2)};
  $MSG_ini=${qq(${mod_lang}::ini)};
  $MSG_no_aut=${qq(${mod_lang}::no_aut)};
  $MSG_no_com=${qq(${mod_lang}::no_com)};
  $MSG_menuad=${qq(${mod_lang}::menuad)};
  
  $MSG_connecting=${qq(${mod_lang}::connecting)};
  $MSG_disconnected=${qq(${mod_lang}::disconnected)};
  $MSG_send_msg=${qq(${mod_lang}::send_msg)};
  $MSG_send_avatar=${qq(${mod_lang}::send_avatar)};
  $MSG_disconn_server=${qq(${mod_lang}::disconn_server)};
  $MSG_chat_info1=${qq(${mod_lang}::chat_info1)};
  $MSG_chat_info2=${qq(${mod_lang}::chat_info2)};
  $MSG_from=${qq(${mod_lang}::from)};
  $MSG_has_joined=${qq(${mod_lang}::has_joined)};
  $MSG_wan_chat=${qq(${mod_lang}::wan_chat)};
  $MSG_new_contact=${qq(${mod_lang}::new_contact)};
  $MSG_has_added=${qq(${mod_lang}::has_added)};
  $MSG_deleted_us=${qq(${mod_lang}::deleted_us)};
  $MSG_room_opened=${qq(${mod_lang}::room_opened)};
  $MSG_chat_closed=${qq(${mod_lang}::chat_closed)};
  $MSG_room_closed=${qq(${mod_lang}::room_closed)};
  $MSG_room_update=${qq(${mod_lang}::room_update)};
  $MSG_member_here=${qq(${mod_lang}::member_here)};
  $MSG_member_left=${qq(${mod_lang}::member_left)};
  $MSG_logmember_left=${qq(${mod_lang}::logmember_left)};
  $MSG_change_status=${qq(${mod_lang}::change_status)};
  $MSG_close_idle=${qq(${mod_lang}::close_idle)};
  $MSG_players=${qq(${mod_lang}::players)};
  $MSG_calculating_players=${qq(${mod_lang}::calculating_players)};
  $MSG_saloon_mode=${qq(${mod_lang}::saloon_mode)};
  $MSG_private_mode=${qq(${mod_lang}::private_mode)};
  $MSG_player=${qq(${mod_lang}::player)};
  $MSG_waiting=${qq(${mod_lang}::waiting)};
  $MSG_set_status=${qq(${mod_lang}::set_status)};
  $MSG_invalid_status=${qq(${mod_lang}::invalid_status)};
  $MSG_setbot_named=${qq(${mod_lang}::setbot_named)};
  $MSG_query_name=${qq(${mod_lang}::query_name)};
  $MSG_set_picture =${qq(${mod_lang}::set_picture)};
  $MSG_the_file =${qq(${mod_lang}::the_file)};
  $MSG_not_exist=${qq(${mod_lang}::not_exist)};
  $MSG_must_png=${qq(${mod_lang}::must_png)};
  $MSG_open_sockets=${qq(${mod_lang}::open_sockets)};
  $MSG_eliminated=${qq(${mod_lang}::eliminated)};
  $MSG_query_socket=${qq(${mod_lang}::query_socket)};
  $MSG_help_sockscmd=${qq(${mod_lang}::help_sockscmd)};
  $MSG_query_rank=${qq(${mod_lang}::query_rank)};
  $MSG_user_addedlist=${qq(${mod_lang}::user_addedlist)};
  $MSG_now_user_master=${qq(${mod_lang}::now_user_master)};
  $MSG_the_rank=${qq(${mod_lang}::the_rank)};
  $MSG_wrong_email=${qq(${mod_lang}::wrong_email)};
  $MSG_query_user=${qq(${mod_lang}::query_user)};
  $MSG_cmd_processed=${qq(${mod_lang}::cmd_processed)};
  $MSG_cant_blockhim=${qq(${mod_lang}::cant_blockhim)};
  $MSG_user_blocked=${qq(${mod_lang}::user_blocked)};
  $MSG_now_chating=${qq(${mod_lang}::now_chating)};
  $MSG_msn_mode=${qq(${mod_lang}::msn_mode)};
  $MSG_your_level=${qq(${mod_lang}::your_level)};
  $MSG_hello=${qq(${mod_lang}::hello)};
  $MSG_now_you_in=${qq(${mod_lang}::now_you_in)};
  $MSG_just_in=${qq(${mod_lang}::just_in)};
  $MSG_now_thisRoom=${qq(${mod_lang}::now_thisRoom)};
  $MSG_now=${qq(${mod_lang}::now)};
  $MSG_is_chatting=${qq(${mod_lang}::is_chatting)};
  $MSG_actually_chatting=${qq(${mod_lang}::actually_chatting)};
  $MSG_nice_day=${qq(${mod_lang}::nice_day)};
  $MSG_rebot_mode_cmd=${qq(${mod_lang}::rebot_mode_cmd)};
  $MSG_rebot_mode_app=${qq(${mod_lang}::rebot_mode_app)};
  $MSG_main_master=${qq(${mod_lang}::main_master)};
  $MSG_list_master=${qq(${mod_lang}::list_master)};
  $MSG_list_public=${qq(${mod_lang}::list_public)};
  $MSG_list_bloqued=${qq(${mod_lang}::list_bloqued)};
  $MSG_list_pending=${qq(${mod_lang}::list_pending)};

}

1;
